/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LimitRangeItem;
import io.kubernetes.client.openapi.models.V1LimitRangeItemBuilder;
import io.kubernetes.client.openapi.models.V1LimitRangeItemFluent;
import io.kubernetes.client.openapi.models.V1LimitRangeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LimitRangeSpecFluent<A extends V1LimitRangeSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1LimitRangeItemBuilder> limits;

    public V1LimitRangeSpecFluent() {
    }

    public V1LimitRangeSpecFluent(V1LimitRangeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1LimitRangeSpec instance) {
        V1LimitRangeSpec v1LimitRangeSpec = instance = instance != null ? instance : new V1LimitRangeSpec();
        if (instance != null) {
            this.withLimits(instance.getLimits());
        }
    }

    public A addToLimits(int index, V1LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get("limits").add(index, builder);
            this.limits.add(index, builder);
        }
        return (A)this;
    }

    public A setToLimits(int index, V1LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get("limits").set(index, builder);
            this.limits.set(index, builder);
        }
        return (A)this;
    }

    public A addToLimits(V1LimitRangeItem ... items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    public A addAllToLimits(Collection<V1LimitRangeItem> items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    public A removeFromLimits(V1LimitRangeItem ... items) {
        if (this.limits == null) {
            return (A)this;
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.get("limits").remove(builder);
            this.limits.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromLimits(Collection<V1LimitRangeItem> items) {
        if (this.limits == null) {
            return (A)this;
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.get("limits").remove(builder);
            this.limits.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromLimits(Predicate<V1LimitRangeItemBuilder> predicate) {
        if (this.limits == null) {
            return (A)this;
        }
        Iterator<V1LimitRangeItemBuilder> each = this.limits.iterator();
        Object visitables = this._visitables.get("limits");
        while (each.hasNext()) {
            V1LimitRangeItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LimitRangeItem> buildLimits() {
        return this.limits != null ? V1LimitRangeSpecFluent.build(this.limits) : null;
    }

    public V1LimitRangeItem buildLimit(int index) {
        return this.limits.get(index).build();
    }

    public V1LimitRangeItem buildFirstLimit() {
        return this.limits.get(0).build();
    }

    public V1LimitRangeItem buildLastLimit() {
        return this.limits.get(this.limits.size() - 1).build();
    }

    public V1LimitRangeItem buildMatchingLimit(Predicate<V1LimitRangeItemBuilder> predicate) {
        for (V1LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLimit(Predicate<V1LimitRangeItemBuilder> predicate) {
        for (V1LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLimits(List<V1LimitRangeItem> limits) {
        if (this.limits != null) {
            this._visitables.get("limits").clear();
        }
        if (limits != null) {
            this.limits = new ArrayList();
            for (V1LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        } else {
            this.limits = null;
        }
        return (A)this;
    }

    public A withLimits(V1LimitRangeItem ... limits) {
        if (this.limits != null) {
            this.limits.clear();
            this._visitables.remove("limits");
        }
        if (limits != null) {
            for (V1LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    public boolean hasLimits() {
        return this.limits != null && !this.limits.isEmpty();
    }

    public LimitsNested<A> addNewLimit() {
        return new LimitsNested(-1, null);
    }

    public LimitsNested<A> addNewLimitLike(V1LimitRangeItem item) {
        return new LimitsNested(-1, item);
    }

    public LimitsNested<A> setNewLimitLike(int index, V1LimitRangeItem item) {
        return new LimitsNested(index, item);
    }

    public LimitsNested<A> editLimit(int index) {
        if (this.limits.size() <= index) {
            throw new RuntimeException("Can't edit limits. Index exceeds size.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editFirstLimit() {
        if (this.limits.size() == 0) {
            throw new RuntimeException("Can't edit first limits. The list is empty.");
        }
        return this.setNewLimitLike(0, this.buildLimit(0));
    }

    public LimitsNested<A> editLastLimit() {
        int index = this.limits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last limits. The list is empty.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editMatchingLimit(Predicate<V1LimitRangeItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.limits.size(); ++i) {
            if (!predicate.test(this.limits.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching limits. No match found.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LimitRangeSpecFluent that = (V1LimitRangeSpecFluent)o;
        return Objects.equals(this.limits, that.limits);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limits, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitsNested<N>
    extends V1LimitRangeItemFluent<LimitsNested<N>>
    implements Nested<N> {
        V1LimitRangeItemBuilder builder;
        int index;

        LimitsNested(int index, V1LimitRangeItem item) {
            this.index = index;
            this.builder = new V1LimitRangeItemBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1LimitRangeSpecFluent.this.setToLimits(this.index, this.builder.build());
        }

        public N endLimit() {
            return this.and();
        }
    }
}

