/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IngressTLSFluent<A extends V1IngressTLSFluent<A>>
extends BaseFluent<A> {
    private List<String> hosts;
    private String secretName;

    public V1IngressTLSFluent() {
    }

    public V1IngressTLSFluent(V1IngressTLS instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressTLS instance) {
        V1IngressTLS v1IngressTLS = instance = instance != null ? instance : new V1IngressTLS();
        if (instance != null) {
            this.withHosts(instance.getHosts());
            this.withSecretName(instance.getSecretName());
        }
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)this;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove("hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressTLSFluent that = (V1IngressTLSFluent)o;
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        return Objects.equals(this.secretName, that.secretName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hosts, this.secretName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }
}

