/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.kubernetes.client.openapi.models.V1EnvVarSourceBuilder;
import io.kubernetes.client.openapi.models.V1EnvVarSourceFluent;
import java.util.Objects;
import java.util.Optional;

public class V1EnvVarFluent<A extends V1EnvVarFluent<A>>
extends BaseFluent<A> {
    private String name;
    private String value;
    private V1EnvVarSourceBuilder valueFrom;

    public V1EnvVarFluent() {
    }

    public V1EnvVarFluent(V1EnvVar instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1EnvVar instance) {
        V1EnvVar v1EnvVar = instance = instance != null ? instance : new V1EnvVar();
        if (instance != null) {
            this.withName(instance.getName());
            this.withValue(instance.getValue());
            this.withValueFrom(instance.getValueFrom());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public V1EnvVarSource buildValueFrom() {
        return this.valueFrom != null ? this.valueFrom.build() : null;
    }

    public A withValueFrom(V1EnvVarSource valueFrom) {
        this._visitables.remove("valueFrom");
        if (valueFrom != null) {
            this.valueFrom = new V1EnvVarSourceBuilder(valueFrom);
            this._visitables.get("valueFrom").add(this.valueFrom);
        } else {
            this.valueFrom = null;
            this._visitables.get("valueFrom").remove(this.valueFrom);
        }
        return (A)this;
    }

    public boolean hasValueFrom() {
        return this.valueFrom != null;
    }

    public ValueFromNested<A> withNewValueFrom() {
        return new ValueFromNested(null);
    }

    public ValueFromNested<A> withNewValueFromLike(V1EnvVarSource item) {
        return new ValueFromNested(item);
    }

    public ValueFromNested<A> editValueFrom() {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(null));
    }

    public ValueFromNested<A> editOrNewValueFrom() {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(new V1EnvVarSourceBuilder().build()));
    }

    public ValueFromNested<A> editOrNewValueFromLike(V1EnvVarSource item) {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EnvVarFluent that = (V1EnvVarFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.valueFrom, that.valueFrom);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.valueFrom, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.valueFrom != null) {
            sb.append("valueFrom:");
            sb.append(this.valueFrom);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ValueFromNested<N>
    extends V1EnvVarSourceFluent<ValueFromNested<N>>
    implements Nested<N> {
        V1EnvVarSourceBuilder builder;

        ValueFromNested(V1EnvVarSource item) {
            this.builder = new V1EnvVarSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EnvVarFluent.this.withValueFrom(this.builder.build());
        }

        public N endValueFrom() {
            return this.and();
        }
    }
}

