/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1EndpointHints;
import io.kubernetes.client.openapi.models.V1ForZone;
import io.kubernetes.client.openapi.models.V1ForZoneBuilder;
import io.kubernetes.client.openapi.models.V1ForZoneFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1EndpointHintsFluent<A extends V1EndpointHintsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1ForZoneBuilder> forZones;

    public V1EndpointHintsFluent() {
    }

    public V1EndpointHintsFluent(V1EndpointHints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1EndpointHints instance) {
        V1EndpointHints v1EndpointHints = instance = instance != null ? instance : new V1EndpointHints();
        if (instance != null) {
            this.withForZones(instance.getForZones());
        }
    }

    public A addToForZones(int index, V1ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").add(index, builder);
            this.forZones.add(index, builder);
        }
        return (A)this;
    }

    public A setToForZones(int index, V1ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").set(index, builder);
            this.forZones.set(index, builder);
        }
        return (A)this;
    }

    public A addToForZones(V1ForZone ... items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (V1ForZone item : items) {
            V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public A addAllToForZones(Collection<V1ForZone> items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (V1ForZone item : items) {
            V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public A removeFromForZones(V1ForZone ... items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (V1ForZone item : items) {
            V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromForZones(Collection<V1ForZone> items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (V1ForZone item : items) {
            V1ForZoneBuilder builder = new V1ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromForZones(Predicate<V1ForZoneBuilder> predicate) {
        if (this.forZones == null) {
            return (A)this;
        }
        Iterator<V1ForZoneBuilder> each = this.forZones.iterator();
        Object visitables = this._visitables.get("forZones");
        while (each.hasNext()) {
            V1ForZoneBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ForZone> buildForZones() {
        return this.forZones != null ? V1EndpointHintsFluent.build(this.forZones) : null;
    }

    public V1ForZone buildForZone(int index) {
        return this.forZones.get(index).build();
    }

    public V1ForZone buildFirstForZone() {
        return this.forZones.get(0).build();
    }

    public V1ForZone buildLastForZone() {
        return this.forZones.get(this.forZones.size() - 1).build();
    }

    public V1ForZone buildMatchingForZone(Predicate<V1ForZoneBuilder> predicate) {
        for (V1ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingForZone(Predicate<V1ForZoneBuilder> predicate) {
        for (V1ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withForZones(List<V1ForZone> forZones) {
        if (this.forZones != null) {
            this._visitables.get("forZones").clear();
        }
        if (forZones != null) {
            this.forZones = new ArrayList();
            for (V1ForZone item : forZones) {
                this.addToForZones(item);
            }
        } else {
            this.forZones = null;
        }
        return (A)this;
    }

    public A withForZones(V1ForZone ... forZones) {
        if (this.forZones != null) {
            this.forZones.clear();
            this._visitables.remove("forZones");
        }
        if (forZones != null) {
            for (V1ForZone item : forZones) {
                this.addToForZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasForZones() {
        return this.forZones != null && !this.forZones.isEmpty();
    }

    public ForZonesNested<A> addNewForZone() {
        return new ForZonesNested(-1, null);
    }

    public ForZonesNested<A> addNewForZoneLike(V1ForZone item) {
        return new ForZonesNested(-1, item);
    }

    public ForZonesNested<A> setNewForZoneLike(int index, V1ForZone item) {
        return new ForZonesNested(index, item);
    }

    public ForZonesNested<A> editForZone(int index) {
        if (this.forZones.size() <= index) {
            throw new RuntimeException("Can't edit forZones. Index exceeds size.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editFirstForZone() {
        if (this.forZones.size() == 0) {
            throw new RuntimeException("Can't edit first forZones. The list is empty.");
        }
        return this.setNewForZoneLike(0, this.buildForZone(0));
    }

    public ForZonesNested<A> editLastForZone() {
        int index = this.forZones.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last forZones. The list is empty.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editMatchingForZone(Predicate<V1ForZoneBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.forZones.size(); ++i) {
            if (!predicate.test(this.forZones.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching forZones. No match found.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EndpointHintsFluent that = (V1EndpointHintsFluent)o;
        return Objects.equals(this.forZones, that.forZones);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.forZones, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.forZones != null && !this.forZones.isEmpty()) {
            sb.append("forZones:");
            sb.append(this.forZones);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ForZonesNested<N>
    extends V1ForZoneFluent<ForZonesNested<N>>
    implements Nested<N> {
        V1ForZoneBuilder builder;
        int index;

        ForZonesNested(int index, V1ForZone item) {
            this.index = index;
            this.builder = new V1ForZoneBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointHintsFluent.this.setToForZones(this.index, this.builder.build());
        }

        public N endForZone() {
            return this.and();
        }
    }
}

