/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.cio.RequestResponseBuilder;
import io.ktor.server.testing.HighLoadHttpGenerator$ClientState$WhenMappings;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.ByteReadPacket;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 -2\u00020\u0001:\u0003,-.B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBF\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010(\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0010R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u000e\u0010!\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator;", "", "url", "", "host", "port", "", "numberConnections", "queueSize", "highPressure", "", "(Ljava/lang/String;Ljava/lang/String;IIIZ)V", "numberOfConnections", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;IIIZLkotlin/jvm/functions/Function1;)V", "cancelled", "codeCounts", "", "Ljava/util/concurrent/atomic/AtomicLong;", "[Ljava/util/concurrent/atomic/AtomicLong;", "connectErrors", "count", "getHighPressure", "()Z", "getHost", "()Ljava/lang/String;", "getNumberOfConnections", "()I", "getQueueSize", "readErrors", "remote", "Ljava/net/InetSocketAddress;", "request", "Lio/ktor/utils/io/core/ByteReadPacket;", "requestByteBuffer", "Ljava/nio/ByteBuffer;", "shutdown", "writeErrors", "mainLoop", "stop", "ClientState", "Companion", "ParseState", "ktor-server-test-host"})
public final class HighLoadHttpGenerator {
    private final InetSocketAddress remote;
    private final ByteReadPacket request;
    private final ByteBuffer requestByteBuffer;
    private final AtomicLong count;
    private final AtomicLong[] codeCounts;
    private final AtomicLong readErrors;
    private final AtomicLong writeErrors;
    private final AtomicLong connectErrors;
    private volatile boolean cancelled;
    private volatile boolean shutdown;
    @NotNull
    private final String host;
    private final int numberOfConnections;
    private final int queueSize;
    private final boolean highPressure;
    private static final byte[] HTTP11;
    private static final long HTTP11Long = 5211883372140375601L;
    private static final int HTTP1_length = 8;
    private static final int HTTP_200_SPACE_Int = 0x32303020;
    private static final int HTTP_200_R_Int = 842018829;
    private static final byte N = 10;
    private static final byte S = 32;
    public static final Companion Companion;

    public final void shutdown() {
        this.shutdown = true;
    }

    public final void stop() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void mainLoop() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNull((Object)selectorProvider);
        SelectorProvider provider = selectorProvider;
        AbstractSelector abstractSelector = provider.openSelector();
        Intrinsics.checkNotNull((Object)abstractSelector);
        AbstractSelector selector = abstractSelector;
        Closeable closeable = selector;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AbstractSelector it = (AbstractSelector)closeable;
            boolean bl3 = false;
            int connectionsCount = 0;
            ArrayList<ClientState> writeReady = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> writeReadyTmp = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> readReady = new ArrayList<ClientState>(this.numberOfConnections);
            ArrayList<ClientState> pending = new ArrayList<ClientState>(this.numberOfConnections * 2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
            Intrinsics.checkNotNull((Object)byteBuffer);
            ByteBuffer bb = byteBuffer;
            bb.order(ByteOrder.BIG_ENDIAN);
            while (!this.cancelled) {
                int selectedCount;
                int n;
                ClientState c;
                int idx;
                if (connectionsCount < this.numberOfConnections) {
                    SocketChannel ch;
                    Intrinsics.checkNotNull((Object)provider.openSocketChannel());
                    ch.configureBlocking(false);
                    try {
                        ClientState client = new ClientState(ch);
                        client.send(this.queueSize);
                        if (ch.connect(this.remote)) {
                            writeReady.add(client);
                        } else {
                            client.setKey(ch.register(selector, 8, client));
                            client.setCurrentOps(8);
                        }
                        ++connectionsCount;
                    }
                    catch (Throwable t) {
                        this.connectErrors.incrementAndGet();
                    }
                }
                int ch = 0;
                int t = writeReady.size();
                while (ch < t && !this.cancelled) {
                    void idx2;
                    Object e = writeReady.get((int)idx2);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"writeReady[idx]");
                    ClientState c22 = (ClientState)e;
                    try {
                        if (!c22.doWrite$ktor_server_test_host()) {
                            c22.setWritePending(true);
                            readReady.add(c22);
                            pending.add(c22);
                        } else {
                            readReady.add(c22);
                            if (c22.getWritePending()) {
                                c22.setWritePending(false);
                                pending.add(c22);
                            }
                            if (c22.getRemaining$ktor_server_test_host() > 0) {
                                writeReadyTmp.add(c22);
                            }
                        }
                    }
                    catch (Throwable t2) {
                        this.writeErrors.incrementAndGet();
                        c22.close();
                        --connectionsCount;
                    }
                    ++idx2;
                }
                writeReady.clear();
                ArrayList<ClientState> tmp = writeReadyTmp;
                writeReadyTmp = writeReady;
                writeReady = tmp;
                t = 0;
                int c22 = readReady.size();
                while (t < c22 && !this.cancelled) {
                    Object e = readReady.get(idx);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"readReady[idx]");
                    c = (ClientState)e;
                    try {
                        int rc;
                        while ((rc = c.doRead$ktor_server_test_host(bb)) > 0) {
                        }
                        if (rc == -1) {
                            --connectionsCount;
                            c.close();
                        } else {
                            c.setReadPending(true);
                            pending.add(c);
                            if (c.getRemaining$ktor_server_test_host() > 0) {
                                writeReady.add(c);
                            }
                        }
                    }
                    catch (Throwable t3) {
                        this.readErrors.incrementAndGet();
                        c.close();
                        --connectionsCount;
                    }
                    ++idx;
                }
                readReady.clear();
                c22 = pending.size();
                for (idx = 0; idx < c22 && !this.cancelled; ++idx) {
                    Object e = pending.get(idx);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"pending[idx]");
                    c = (ClientState)e;
                    c.interest(selector);
                }
                pending.clear();
                Set<SelectionKey> set = selector.keys();
                Intrinsics.checkNotNullExpressionValue(set, (String)"selector.keys()");
                Collection c22 = set;
                boolean c32 = false;
                boolean hasKeys = !c22.isEmpty();
                if (this.cancelled) {
                    n = 0;
                } else if (!hasKeys) {
                    n = 0;
                } else if (connectionsCount < this.numberOfConnections) {
                    n = selector.selectNow();
                } else {
                    Collection c32 = writeReady;
                    boolean t3 = false;
                    if (!c32.isEmpty()) {
                        n = selector.selectNow();
                    } else {
                        c32 = readReady;
                        t3 = false;
                        n = !c32.isEmpty() ? selector.selectNow() : selector.select(500L);
                    }
                }
                if ((selectedCount = n) <= 0) continue;
                Iterator<SelectionKey> iter = selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key;
                    Intrinsics.checkNotNull((Object)iter.next());
                    Object object = key.attachment();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type io.ktor.server.testing.HighLoadHttpGenerator.ClientState");
                    }
                    ClientState client = (ClientState)object;
                    if (client.getChannel$ktor_server_test_host().isConnectionPending()) {
                        try {
                            client.getChannel$ktor_server_test_host().finishConnect();
                            writeReady.add(client);
                        }
                        catch (Throwable t4) {
                            client.close();
                            --connectionsCount;
                            this.connectErrors.incrementAndGet();
                        }
                    } else {
                        int readyOps = key.readyOps();
                        if ((readyOps & 1) != 0) {
                            client.setReadPending(false);
                            readReady.add(client);
                        }
                        if ((readyOps & 4) != 0) {
                            client.setWritePending(false);
                            writeReady.add(client);
                        }
                    }
                    iter.remove();
                    client.interest(selector);
                }
            }
            Set<SelectionKey> set = selector.keys();
            Intrinsics.checkNotNullExpressionValue(set, (String)"selector.keys()");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelectionKey it2 = (SelectionKey)element$iv;
                boolean bl4 = false;
                it2.cancel();
                try {
                    it2.channel().close();
                }
                catch (Throwable throwable2) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final boolean getHighPressure() {
        return this.highPressure;
    }

    /*
     * WARNING - void declaration
     */
    public HighLoadHttpGenerator(@NotNull String host, int port, int numberOfConnections, int queueSize, boolean highPressure, @NotNull Function1<? super RequestResponseBuilder, Unit> builder) {
        void $this$apply2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.host = host;
        this.numberOfConnections = numberOfConnections;
        this.queueSize = queueSize;
        this.highPressure = highPressure;
        this.remote = new InetSocketAddress(this.host, port);
        Object object = new RequestResponseBuilder();
        boolean bl = false;
        int n = 0;
        builder.invoke(object);
        this.request = object.build();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)this.request.getRemaining());
        Intrinsics.checkNotNull((Object)byteBuffer);
        object = byteBuffer;
        bl = false;
        n = 0;
        Object object2 = object;
        HighLoadHttpGenerator highLoadHttpGenerator = this;
        boolean bl2 = false;
        ByteBuffersKt.readFully((ByteReadPacket)this.request.copy(), (ByteBuffer)$this$apply2);
        $this$apply2.clear();
        AtomicLong[] atomicLongArray = Unit.INSTANCE;
        highLoadHttpGenerator.requestByteBuffer = object;
        this.count = new AtomicLong(0L);
        int n2 = 1000;
        highLoadHttpGenerator = this;
        AtomicLong[] atomicLongArray2 = new AtomicLong[n2];
        n = 0;
        while (n < n2) {
            AtomicLong atomicLong;
            int $this$apply2 = n;
            int n3 = n++;
            atomicLongArray = atomicLongArray2;
            boolean bl3 = false;
            atomicLongArray[n3] = atomicLong = new AtomicLong(0L);
        }
        atomicLongArray = atomicLongArray2;
        highLoadHttpGenerator.codeCounts = atomicLongArray;
        this.readErrors = new AtomicLong();
        this.writeErrors = new AtomicLong();
        this.connectErrors = new AtomicLong();
    }

    public HighLoadHttpGenerator(final @NotNull String url, final @NotNull String host, final int port, int numberConnections, int queueSize, boolean highPressure) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this(host, port, numberConnections, queueSize, highPressure, (Function1<? super RequestResponseBuilder, Unit>)((Function1)new Function1<RequestResponseBuilder, Unit>(){

            public final void invoke(@NotNull RequestResponseBuilder $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.requestLine(HttpMethod.Companion.getGet(), (CharSequence)url, (CharSequence)"HTTP/1.1");
                $receiver.headerLine((CharSequence)HttpHeaders.INSTANCE.getHost(), (CharSequence)(host + ':' + port));
                $receiver.headerLine((CharSequence)HttpHeaders.INSTANCE.getAccept(), (CharSequence)"*/*");
                $receiver.emptyLine();
            }
        }));
    }

    static {
        Companion = new Companion(null);
        String string = "HTTP/1.1";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        HTTP11 = byArray;
    }

    public static final /* synthetic */ void access$setShutdown$p(HighLoadHttpGenerator $this, boolean bl) {
        $this.shutdown = bl;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "", "(Ljava/lang/String;I)V", "EOL", "HTTP", "SPACE", "CODE", "ktor-server-test-host"})
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState EOL;
        public static final /* enum */ ParseState HTTP;
        public static final /* enum */ ParseState SPACE;
        public static final /* enum */ ParseState CODE;
        private static final /* synthetic */ ParseState[] $VALUES;

        static {
            ParseState[] parseStateArray = new ParseState[4];
            ParseState[] parseStateArray2 = parseStateArray;
            parseStateArray[0] = EOL = new ParseState();
            parseStateArray[1] = HTTP = new ParseState();
            parseStateArray[2] = SPACE = new ParseState();
            parseStateArray[3] = CODE = new ParseState();
            $VALUES = parseStateArray;
        }

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String string) {
            return Enum.valueOf(ParseState.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020\bJ\u0006\u0010'\u001a\u00020(J\u0015\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b+J\u000e\u0010,\u001a\u00020\u001aH\u0080\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u00100\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020(2\b\b\u0002\u0010:\u001a\u00020\bJ\u0010\u0010;\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u0010<\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001e\u00a8\u0006="}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ClientState;", "", "channel", "Ljava/nio/channels/SocketChannel;", "(Lio/ktor/server/testing/HighLoadHttpGenerator;Ljava/nio/channels/SocketChannel;)V", "getChannel$ktor_server_test_host", "()Ljava/nio/channels/SocketChannel;", "code", "", "current", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "currentOps", "getCurrentOps", "()I", "setCurrentOps", "(I)V", "key", "Ljava/nio/channels/SelectionKey;", "getKey", "()Ljava/nio/channels/SelectionKey;", "setKey", "(Ljava/nio/channels/SelectionKey;)V", "parseState", "Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "readPending", "", "getReadPending", "()Z", "setReadPending", "(Z)V", "<set-?>", "remaining", "getRemaining$ktor_server_test_host", "tokenSize", "writePending", "getWritePending", "setWritePending", "calcOps", "close", "", "doRead", "bb", "doRead$ktor_server_test_host", "doWrite", "doWrite$ktor_server_test_host", "findEol", "findHttp", "findHttpSlow", "position", "limit", "gotStatus", "interest", "selector", "Ljava/nio/channels/Selector;", "parseCode", "parseLoop", "send", "qty", "skipSpaces", "skipSpacesSlow", "ktor-server-test-host"})
    private final class ClientState {
        private final ByteBuffer current;
        private int remaining;
        private ParseState parseState;
        private int tokenSize;
        private int code;
        @Nullable
        private SelectionKey key;
        private boolean writePending;
        private boolean readPending;
        private int currentOps;
        @NotNull
        private final SocketChannel channel;

        public final int getRemaining$ktor_server_test_host() {
            return this.remaining;
        }

        @Nullable
        public final SelectionKey getKey() {
            return this.key;
        }

        public final void setKey(@Nullable SelectionKey selectionKey) {
            this.key = selectionKey;
        }

        public final boolean getWritePending() {
            return this.writePending;
        }

        public final void setWritePending(boolean bl) {
            this.writePending = bl;
        }

        public final boolean getReadPending() {
            return this.readPending;
        }

        public final void setReadPending(boolean bl) {
            this.readPending = bl;
        }

        public final int getCurrentOps() {
            return this.currentOps;
        }

        public final void setCurrentOps(int n) {
            this.currentOps = n;
        }

        public final int calcOps() {
            int ops = 0;
            if (this.writePending) {
                ops |= 4;
            }
            if (this.readPending) {
                ops |= 1;
            }
            return ops;
        }

        public final void interest(@NotNull Selector selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            int ops = this.calcOps();
            SelectionKey key = this.key;
            try {
                if (key == null) {
                    this.key = this.channel.register(selector, ops, this);
                    this.currentOps = ops;
                } else if (this.currentOps != ops) {
                    key.interestOps(ops);
                    this.currentOps = ops;
                }
            }
            catch (Throwable t) {
                this.close();
            }
        }

        public final void send(int qty) {
            boolean bl = qty > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (!HighLoadHttpGenerator.this.shutdown) {
                this.remaining += qty;
                if (!this.current.hasRemaining()) {
                    this.current.clear();
                }
            }
        }

        public static /* synthetic */ void send$default(ClientState clientState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            clientState.send(n);
        }

        public final void close() {
            SelectionKey selectionKey = this.key;
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.key = null;
            this.readPending = false;
            this.writePending = false;
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public final boolean doWrite$ktor_server_test_host() {
            block4: {
                boolean bl;
                block5: {
                    while (true) {
                        if (this.remaining == 0) {
                            return true;
                        }
                        boolean hp = HighLoadHttpGenerator.this.getHighPressure();
                        this.channel.write(this.current);
                        if (this.current.hasRemaining()) break block4;
                        HighLoadHttpGenerator.this.count.incrementAndGet();
                        if (HighLoadHttpGenerator.this.shutdown) {
                            this.remaining = 0;
                            bl = true;
                            break block5;
                        }
                        if (hp) {
                            this.current.clear();
                            continue;
                        }
                        ClientState clientState = this;
                        clientState.remaining += -1;
                        if (clientState.remaining <= 0) break;
                        this.current.clear();
                    }
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public final int doRead$ktor_server_test_host(@NotNull ByteBuffer bb) {
            Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
            bb.clear();
            int rc = this.channel.read(bb);
            if (rc == -1) {
                this.close();
                return -1;
            }
            if (rc == 0) {
                return 0;
            }
            if (!HighLoadHttpGenerator.this.getHighPressure()) {
                bb.flip();
                this.parseLoop(bb);
            }
            return 1;
        }

        private final void parseLoop(ByteBuffer bb) {
            while (bb.hasRemaining()) {
                switch (HighLoadHttpGenerator$ClientState$WhenMappings.$EnumSwitchMapping$0[this.parseState.ordinal()]) {
                    case 1: {
                        this.findEol(bb);
                        break;
                    }
                    case 2: {
                        this.findHttp(bb);
                        break;
                    }
                    case 3: {
                        this.skipSpaces(bb);
                        break;
                    }
                    case 4: {
                        this.parseCode(bb);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void findEol(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            int n = position;
            int n2 = limit;
            while (n < n2) {
                void idx;
                if (bb.get((int)idx) == 10) {
                    this.parseState = ParseState.HTTP;
                    this.tokenSize = 0;
                    bb.position((int)(idx + true));
                    return;
                }
                ++idx;
            }
            bb.position(limit);
        }

        private final void findHttp(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            if (this.tokenSize == 0 && limit - position >= 8) {
                if (bb.getLong(position) == 5211883372140375601L) {
                    this.parseState = ParseState.SPACE;
                    this.tokenSize = 0;
                    bb.position(position + 8);
                    return;
                }
                this.parseState = ParseState.EOL;
                return;
            }
            this.findHttpSlow(bb, position, limit);
        }

        /*
         * WARNING - void declaration
         */
        private final void findHttpSlow(ByteBuffer bb, int position, int limit) {
            byte[] http = HTTP11;
            int offset = this.tokenSize - position;
            int n = position;
            int n2 = limit;
            while (n < n2) {
                void idx;
                byte b = bb.get((int)idx);
                if (b == 32) {
                    this.parseState = ParseState.SPACE;
                    this.tokenSize = 0;
                    bb.position((int)(idx + true));
                    return;
                }
                if (b == http[idx + offset]) {
                    ClientState clientState = this;
                    ++clientState.tokenSize;
                    if (clientState.tokenSize > 8) {
                        this.parseState = ParseState.EOL;
                        bb.position((int)(idx + true));
                        return;
                    }
                } else {
                    this.parseState = ParseState.EOL;
                    bb.position((int)idx);
                    return;
                }
                ++idx;
            }
            bb.position(limit);
        }

        private final void skipSpaces(ByteBuffer bb) {
            int i;
            int position = bb.position();
            int limit = bb.limit();
            if (limit - position >= 4 && ((i = bb.getInt(position)) == 0x32303020 || i == 842018829)) {
                this.gotStatus(200);
                this.parseState = ParseState.EOL;
                bb.position(position + 3);
                return;
            }
            this.skipSpacesSlow(bb, position, limit);
        }

        /*
         * WARNING - void declaration
         */
        private final void skipSpacesSlow(ByteBuffer bb, int position, int limit) {
            int n = position;
            int n2 = limit;
            while (n < n2) {
                void idx;
                byte b = bb.get((int)idx);
                if (b == 10) {
                    this.parseState = ParseState.HTTP;
                    bb.position((int)(idx + true));
                    return;
                }
                if (b == 32) {
                    ClientState clientState = this;
                    ++clientState.tokenSize;
                    if (clientState.tokenSize > 10) {
                        this.parseState = ParseState.EOL;
                        bb.position((int)(idx + true));
                        return;
                    }
                } else {
                    int i;
                    if (b == (byte)50 && limit - idx >= 4 && ((i = bb.getInt((int)idx)) == 0x32303020 || i == 842018829)) {
                        this.gotStatus(200);
                        this.parseState = ParseState.EOL;
                        bb.position((int)(idx + 3));
                        return;
                    }
                    int n3 = b - 48;
                    int n4 = n3;
                    if (0 <= n4 && 9 >= n4) {
                        this.parseState = ParseState.CODE;
                        this.code = n3;
                        this.tokenSize = 1;
                        bb.position((int)(idx + true));
                        return;
                    }
                    this.parseState = ParseState.EOL;
                    bb.position((int)(idx + true));
                    return;
                }
                ++idx;
            }
            bb.position(limit);
        }

        private final void parseCode(ByteBuffer bb) {
            int code = this.code;
            while (bb.hasRemaining()) {
                byte b = bb.get();
                if (b == 32 || b == 10) {
                    int n = code;
                    if (100 <= n && 999 >= n) {
                        this.gotStatus(code);
                    }
                    this.parseState = ParseState.EOL;
                    return;
                }
                int n = b - 48;
                if (n < 0 || n > 9) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                ClientState clientState = this;
                ++clientState.tokenSize;
                if (clientState.tokenSize > 3) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                code = code * 10 + n;
            }
            this.code = code;
        }

        private final void gotStatus(int code) {
            HighLoadHttpGenerator.this.codeCounts[code].incrementAndGet();
            this.send(1);
        }

        @NotNull
        public final SocketChannel getChannel$ktor_server_test_host() {
            return this.channel;
        }

        public ClientState(SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
            this.current = HighLoadHttpGenerator.this.requestByteBuffer.duplicate();
            this.parseState = ParseState.HTTP;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J_\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000f0\u001d\u00a2\u0006\u0002\b\u001fJN\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001b\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0007\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$Companion;", "", "()V", "HTTP11", "", "HTTP11Long", "", "HTTP1_length", "", "HTTP_200_R_Int", "HTTP_200_SPACE_Int", "N", "", "S", "doRun", "", "loadGenerator", "Lio/ktor/server/testing/HighLoadHttpGenerator;", "numberOfThreads", "gracefulMillis", "timeMillis", "host", "", "port", "connectionsPerThread", "queueSize", "highPressure", "", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "Lkotlin/ExtensionFunctionType;", "url", "main", "args", "", "([Ljava/lang/String;)V", "ktor-server-test-host"})
    public static final class Companion {
        public final void doRun(@NotNull String url, @NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(url, host, port, connectionsPerThread, queueSize, highPressure);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        public final void doRun(@NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis, @NotNull Function1<? super RequestResponseBuilder, Unit> builder) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(host, port, connectionsPerThread, queueSize, highPressure, builder);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void doRun(HighLoadHttpGenerator loadGenerator, int numberOfThreads, long gracefulMillis, long timeMillis) {
            boolean $this$mapTo$iv$iv2;
            String $i$f$map2;
            void $this$mapTo$iv$iv2;
            String string = "Running...";
            int n = 0;
            System.out.println((Object)string);
            n = 1;
            Iterable $this$map$iv = (Iterable)new IntRange(n, numberOfThreads);
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(loadGenerator){
                    final /* synthetic */ HighLoadHttpGenerator $loadGenerator$inlined;
                    {
                        this.$loadGenerator$inlined = highLoadHttpGenerator;
                        super(0);
                    }

                    public final void invoke() {
                        this.$loadGenerator$inlined.mainLoop();
                    }
                }), (int)31, null);
                collection.add(thread);
            }
            List threads = (List)destination$iv$iv;
            Thread joiner2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(threads, gracefulMillis){
                final /* synthetic */ List $threads;
                final /* synthetic */ long $gracefulMillis;

                public final void invoke() {
                    Iterable $this$forEach$iv = this.$threads;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl = false;
                        it.join(this.$gracefulMillis);
                    }
                }
                {
                    this.$threads = list;
                    this.$gracefulMillis = l;
                    super(0);
                }
            }), (int)30, null);
            try {
                Thread.sleep(timeMillis);
                $i$f$map2 = "Shutting down...";
                $this$mapTo$iv$iv2 = false;
                System.out.println((Object)$i$f$map2);
                loadGenerator.shutdown();
                joiner2.start();
                joiner2.join(gracefulMillis);
            }
            finally {
                $i$f$map2 = "Termination...";
                $this$mapTo$iv$iv2 = false;
                System.out.println((Object)$i$f$map2);
                loadGenerator.stop();
                Iterable $this$forEach$iv = threads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl = false;
                    it.interrupt();
                }
                joiner2.join();
                String string2 = "Terminated.";
                $i$f$forEach = false;
                System.out.println((Object)string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void main(@NotNull String[] args) {
            boolean bl;
            HighLoadHttpGenerator manager;
            boolean bl2;
            block9: {
                Iterator $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                boolean debug = false;
                URL url = new URL("http://localhost:8081/");
                int connections = 4000;
                int queue = 100;
                int time = 20;
                boolean highPressure = false;
                int numberCpu = Runtime.getRuntime().availableProcessors();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                bl2 = false;
                Object $this$buildString = stringBuilder;
                boolean bl5 = false;
                ((StringBuilder)$this$buildString).append(url.getPath());
                CharSequence charSequence = url.getQuery();
                boolean bl6 = false;
                boolean bl7 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    ((StringBuilder)$this$buildString).append('?');
                    ((StringBuilder)$this$buildString).append(url.getQuery());
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String pathAndQuery = string;
                String string2 = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.host");
                manager = new HighLoadHttpGenerator(pathAndQuery, string2, url.getPort() == -1 ? 80 : url.getPort(), connections / numberCpu, queue, highPressure);
                n = 1;
                Iterable $this$map$iv = (Iterable)new IntRange(n, numberCpu);
                boolean $i$f$map = false;
                $this$buildString = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(manager){
                        final /* synthetic */ HighLoadHttpGenerator $manager$inlined;
                        {
                            this.$manager$inlined = highLoadHttpGenerator;
                            super(0);
                        }

                        public final void invoke() {
                            this.$manager$inlined.mainLoop();
                        }
                    }), (int)30, null);
                    collection.add(thread);
                }
                List threads = (List)destination$iv$iv;
                Iterable $this$forEach$iv = threads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl9 = false;
                    it.start();
                }
                TimeUnit.SECONDS.sleep(time);
                manager.shutdown();
                Thread.sleep(1000L);
                manager.stop();
                $this$forEach$iv = threads;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl10 = false;
                    it.join(1000L);
                }
                Iterable $this$any$iv = threads;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl11 = false;
                        if (!it.isAlive()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                String string = "There are threads get stuck";
                bl2 = false;
                System.out.println((Object)string);
            }
            boolean bl12 = false;
            bl2 = false;
            HighLoadHttpGenerator $this$with = manager;
            boolean bl13 = false;
            String it = "count: " + $this$with.count.get();
            boolean bl11 = false;
            System.out.println((Object)it);
            it = "errors: read " + $this$with.readErrors.get() + ", write " + $this$with.writeErrors.get() + ", connect: " + $this$with.connectErrors.get();
            bl11 = false;
            System.out.println((Object)it);
            it = "statuses:";
            bl11 = false;
            System.out.println((Object)it);
            AtomicLong[] $this$forEachIndexed$iv = $this$with.codeCounts;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (AtomicLong item$iv : $this$forEachIndexed$iv) {
                void a;
                int n = index$iv++;
                AtomicLong atomicLong = item$iv;
                int idx = n;
                boolean bl14 = false;
                long cnt = a.get();
                if (cnt <= 0L) continue;
                String string = "  " + idx + "    " + cnt;
                boolean bl15 = false;
                System.out.println((Object)string);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

