/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        String string;
        String string2;
        File file;
        Config environmentConfig;
        Map commandLineMap;
        File configFile;
        URL jar;
        Map argsMap;
        block15: {
            block14: {
                File $this$mapKeysTo$iv$iv;
                File file2;
                URL uRL;
                Object object;
                void $this$mapNotNullTo$iv$iv2;
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                String[] $this$mapNotNull$iv = args;
                boolean $i$f$mapNotNull2 = false;
                String[] stringArray = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                void var9_26 = $this$forEach$iv$iv$iv;
                int n = ((void)var9_26).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = var9_26[i];
                    boolean bl8 = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    if (CommandLineKt.splitPair((String)it, '=') == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair<String, String> it$iv$iv = object;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                argsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                String string3 = (String)argsMap.get("-jar");
                if (string3 != null) {
                    String $i$f$mapNotNull2 = string3;
                    boolean $this$mapNotNullTo$iv$iv2 = false;
                    boolean destination$iv$iv2 = false;
                    String it = $i$f$mapNotNull2;
                    boolean bl = false;
                    uRL = StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
                } else {
                    uRL = null;
                }
                jar = uRL;
                String string4 = (String)argsMap.get("-config");
                if (string4 != null) {
                    String $this$mapNotNullTo$iv$iv2 = string4;
                    boolean destination$iv$iv2 = false;
                    boolean it = false;
                    String it2 = $this$mapNotNullTo$iv$iv2;
                    boolean bl = false;
                    file2 = new File(it2);
                } else {
                    file2 = null;
                }
                configFile = file2;
                Map $this$filterKeys$iv = argsMap;
                boolean $i$f$filterKeys = false;
                Map result$iv = new LinkedHashMap();
                Map bl = $this$filterKeys$iv;
                boolean bl6 = false;
                for (Map.Entry entry$iv : bl.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl7 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-P:", (boolean)false, (int)2, null)) continue;
                    ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map $this$mapKeys$iv = result$iv;
                boolean $i$f$mapKeys = false;
                result$iv = $this$mapKeys$iv;
                Map destination$iv$iv22 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Object it;
                    Map.Entry bl8 = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv22;
                    boolean bl9 = false;
                    String string5 = StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)"-P:");
                    Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
                    object = string5;
                    Map map2 = map;
                    boolean bl10 = false;
                    it = it$iv$iv.getValue();
                    map2.put(object, it);
                }
                commandLineMap = destination$iv$iv22;
                environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
                file = configFile;
                if (file == null) break block14;
                $this$mapKeysTo$iv$iv = file;
                boolean destination$iv$iv22 = false;
                $i$f$mapKeysTo = false;
                File it = $this$mapKeysTo$iv$iv;
                boolean bl11 = false;
                file = ConfigFactory.parseFile((File)it);
                if (file != null) break block15;
            }
            file = ConfigFactory.load();
        }
        File fileConfig = file;
        Config argConfig = ConfigFactory.parseMap((Map)commandLineMap, (String)"Command-line options");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback((ConfigMergeable)environmentConfig).resolve();
        String applicationIdPath = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String rootPathPath = "ktor.deployment.rootPath";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        Config config = combinedConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
        String string6 = HoconApplicationConfigKt.tryGetString((Config)config, (String)applicationIdPath);
        if (string6 == null) {
            string6 = "Application";
        }
        String applicationId = string6;
        Logger appLog = LoggerFactory.getLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        if ((string2 = (String)argsMap.get("-path")) == null) {
            string2 = string = HoconApplicationConfigKt.tryGetString((Config)combinedConfig, (String)rootPathPath);
        }
        if (string2 == null) {
            string = "";
        }
        String rootPath = string;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar, combinedConfig, rootPath, argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, hostWatchPaths){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $hostWatchPaths;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                block29: {
                    Object object;
                    Object object2;
                    String sslKeyAlias;
                    String string;
                    String string2;
                    String string3;
                    String sslPort;
                    String string4;
                    String port;
                    String string5;
                    String host;
                    String string6;
                    String string7;
                    ClassLoader classLoader;
                    Intrinsics.checkParameterIsNotNull((Object)$this$applicationEngineEnvironment, (String)"$receiver");
                    Logger logger = this.$appLog;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"appLog");
                    $this$applicationEngineEnvironment.setLog(logger);
                    ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                    URL uRL = this.$jar;
                    if (uRL != null) {
                        URL uRL2 = uRL;
                        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = applicationEngineEnvironmentBuilder;
                        boolean bl = false;
                        boolean bl2 = false;
                        URL it = uRL2;
                        boolean bl3 = false;
                        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{this.$jar}, ApplicationEnvironment.class.getClassLoader());
                        applicationEngineEnvironmentBuilder = applicationEngineEnvironmentBuilder2;
                        classLoader = uRLClassLoader;
                    } else {
                        ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
                        classLoader = classLoader2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
                    }
                    applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
                    Config config = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
                    $this$applicationEngineEnvironment.setConfig((ApplicationConfig)new HoconApplicationConfig(config));
                    $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                    ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef((Object)"***", (String)"Content hidden");
                    if (this.$combinedConfig.hasPath("ktor")) {
                        $this$applicationEngineEnvironment.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                    } else {
                        $this$applicationEngineEnvironment.getLog().trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
                    }
                    if ((string7 = (String)this.$argsMap.get("-host")) == null) {
                        Config config2 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"combinedConfig");
                        string7 = string6 = HoconApplicationConfigKt.tryGetString((Config)config2, (String)this.$hostConfigPath);
                    }
                    if (string7 == null) {
                        string6 = host = "0.0.0.0";
                    }
                    if ((string5 = (String)this.$argsMap.get("-port")) == null) {
                        Config config3 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"combinedConfig");
                        string5 = port = HoconApplicationConfigKt.tryGetString((Config)config3, (String)this.$hostPortPath);
                    }
                    if ((string4 = (String)this.$argsMap.get("-sslPort")) == null) {
                        Config config4 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config4, (String)"combinedConfig");
                        string4 = sslPort = HoconApplicationConfigKt.tryGetString((Config)config4, (String)this.$hostSslPortPath);
                    }
                    if ((string3 = (String)this.$argsMap.get("-sslKeyStore")) == null) {
                        Config config5 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config5, (String)"combinedConfig");
                        string3 = HoconApplicationConfigKt.tryGetString((Config)config5, (String)this.$hostSslKeyStore);
                    }
                    String sslKeyStorePath = string3;
                    Config config6 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config6, (String)"combinedConfig");
                    String string8 = HoconApplicationConfigKt.tryGetString((Config)config6, (String)this.$hostSslKeyStorePassword);
                    if (string8 != null) {
                        String string9 = string8;
                        boolean bl = false;
                        String string10 = string9;
                        if (string10 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)string10)).toString();
                    } else {
                        string2 = null;
                    }
                    String sslKeyStorePassword = string2;
                    Config config7 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config7, (String)"combinedConfig");
                    String string11 = HoconApplicationConfigKt.tryGetString((Config)config7, (String)this.$hostSslPrivateKeyPassword);
                    if (string11 != null) {
                        String string12 = string11;
                        boolean bl = false;
                        String string13 = string12;
                        if (string13 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string13)).toString();
                    } else {
                        string = null;
                    }
                    String sslPrivateKeyPassword = string;
                    Config config8 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config8, (String)"combinedConfig");
                    String string14 = HoconApplicationConfigKt.tryGetString((Config)config8, (String)this.$hostSslKeyAlias);
                    if (string14 == null) {
                        string14 = sslKeyAlias = "mykey";
                    }
                    if (port != null) {
                        ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                        boolean $i$f$connector = false;
                        EngineConnectorBuilder engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
                        object2 = $this$connector$iv.getConnectors();
                        boolean bl = false;
                        boolean bl4 = false;
                        EngineConnectorBuilder $this$connector = engineConnectorBuilder;
                        boolean bl5 = false;
                        $this$connector.setHost(host);
                        String string15 = port;
                        object = $this$connector;
                        boolean bl6 = false;
                        int n = Integer.parseInt(string15);
                        ((EngineConnectorBuilder)object).setPort(n);
                        $this$connector = engineConnectorBuilder;
                        object2.add((EngineConnectorConfig)$this$connector);
                    }
                    if (sslPort != null) {
                        void $this$sslConnector$iv;
                        void keyStorePassword$iv;
                        void keyStore$iv;
                        boolean bl;
                        Object object3;
                        Object object4;
                        if (sslKeyStorePath == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                        }
                        if (sslKeyStorePassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                        }
                        if (sslPrivateKeyPassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                        }
                        File $i$f$connector = new File(sslKeyStorePath);
                        boolean bl7 = false;
                        boolean bl8 = false;
                        File file322 = $i$f$connector;
                        boolean bl9 = false;
                        File keyStoreFile = file322.exists() || file322.isAbsolute() ? file322 : new File(".", sslKeyStorePath).getAbsoluteFile();
                        Object object5 = KeyStore.getInstance("JKS");
                        bl8 = false;
                        boolean file322 = false;
                        KeyStore $this$apply = object5;
                        boolean bl10 = false;
                        Object object6 = new FileInputStream(keyStoreFile);
                        boolean bl11 = false;
                        object = null;
                        try {
                            FileInputStream it = (FileInputStream)object6;
                            boolean bl12 = false;
                            String string16 = sslKeyStorePassword;
                            object4 = it;
                            object3 = $this$apply;
                            bl = false;
                            char[] cArray = string16.toCharArray();
                            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            char[] cArray2 = cArray;
                            ((KeyStore)object3).load((InputStream)object4, cArray2);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object6, (Throwable)object);
                        }
                        object6 = sslPrivateKeyPassword;
                        String string17 = sslKeyAlias;
                        KeyStore keyStore = $this$apply;
                        bl11 = false;
                        char[] cArray = ((String)object6).toCharArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                        char[] cArray3 = cArray;
                        boolean bl13 = keyStore.getKey(string17, cArray3) == null;
                        bl11 = false;
                        boolean bl14 = false;
                        KeyStore keyStore2 = object5;
                        object5 = $this$applicationEngineEnvironment;
                        KeyStore keyStore3 = keyStore2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore3, (String)"keyStore");
                        object2 = keyStore3;
                        Function0 file322 = (Function0)new Function0<char[]>(sslKeyStorePassword){
                            final /* synthetic */ String $sslKeyStorePassword;

                            @NotNull
                            public final char[] invoke() {
                                String string = this.$sslKeyStorePassword;
                                boolean bl = false;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslKeyStorePassword = string;
                                super(0);
                            }
                        };
                        Function0 privateKeyPassword$iv = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
                            final /* synthetic */ String $sslPrivateKeyPassword;

                            @NotNull
                            public final char[] invoke() {
                                String string = this.$sslPrivateKeyPassword;
                                boolean bl = false;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslPrivateKeyPassword = string;
                                super(0);
                            }
                        };
                        boolean $i$f$sslConnector = false;
                        EngineSSLConnectorBuilder engineSSLConnectorBuilder = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
                        List<EngineConnectorConfig> list = $this$sslConnector$iv.getConnectors();
                        bl14 = false;
                        boolean bl15 = false;
                        EngineSSLConnectorBuilder $this$sslConnector = engineSSLConnectorBuilder;
                        boolean bl16 = false;
                        $this$sslConnector.setHost(host);
                        object4 = sslPort;
                        object3 = $this$sslConnector;
                        bl = false;
                        int n = Integer.parseInt((String)object4);
                        ((EngineConnectorBuilder)object3).setPort(n);
                        $this$sslConnector.setKeyStorePath(keyStoreFile);
                        EngineSSLConnectorBuilder engineSSLConnectorBuilder2 = engineSSLConnectorBuilder;
                        list.add(engineSSLConnectorBuilder2);
                    }
                    if (port == null && sslPort == null) {
                        throw (Throwable)new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                    }
                    Object object7 = (String)this.$argsMap.get("-watch");
                    if (object7 == null || (object7 = StringsKt.split$default((CharSequence)((CharSequence)object7), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) == null) {
                        Config config9 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config9, (String)"combinedConfig");
                        object7 = HoconApplicationConfigKt.tryGetStringList((Config)config9, (String)this.$hostWatchPaths);
                    }
                    if (object7 == null) break block29;
                    Object object8 = object7;
                    boolean bl = false;
                    boolean bl17 = false;
                    Object it = object8;
                    boolean bl18 = false;
                    $this$applicationEngineEnvironment.setWatchPaths((List<String>)it);
                }
            }
            {
                this.$appLog = logger;
                this.$jar = uRL;
                this.$combinedConfig = config;
                this.$rootPath = string;
                this.$argsMap = map;
                this.$hostConfigPath = string2;
                this.$hostPortPath = string3;
                this.$hostSslPortPath = string4;
                this.$hostSslKeyStore = string5;
                this.$hostSslKeyStorePassword = string6;
                this.$hostSslPrivateKeyPassword = string7;
                this.$hostSslKeyAlias = string8;
                this.$hostWatchPaths = string9;
                super(1);
            }
        }));
        return environment2;
    }

    private static final Pair<String, String> splitPair(@NotNull String $this$splitPair, char ch) {
        Pair pair;
        int n = StringsKt.indexOf$default((CharSequence)$this$splitPair, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        boolean bl2 = false;
        int idx = n;
        boolean bl3 = false;
        switch (idx) {
            case -1: {
                pair = null;
                break;
            }
            default: {
                pair = new Pair((Object)StringsKt.take((String)$this$splitPair, (int)idx), (Object)StringsKt.drop((String)$this$splitPair, (int)(idx + 1)));
            }
        }
        return pair;
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        block2: {
            Object object;
            Object object2;
            int it;
            boolean bl;
            int n;
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)$this$loadCommonConfiguration, (String)"$this$loadCommonConfiguration");
            Intrinsics.checkParameterIsNotNull((Object)deploymentConfig, (String)"deploymentConfig");
            Object object3 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object3 != null && (object3 = object3.getString()) != null) {
                Object object4 = object3;
                bl2 = false;
                n = Integer.parseInt((String)object4);
                bl2 = false;
                bl = false;
                it = n;
                boolean bl3 = false;
                $this$loadCommonConfiguration.setCallGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object2 = object2.getString()) != null) {
                Object object5 = object2;
                bl2 = false;
                n = Integer.parseInt((String)object5);
                bl2 = false;
                bl = false;
                it = n;
                boolean bl4 = false;
                $this$loadCommonConfiguration.setConnectionGroupSize(it);
            }
            if ((object = deploymentConfig.propertyOrNull("workerGroupSize")) == null || (object = object.getString()) == null) break block2;
            Object object6 = object;
            bl2 = false;
            int n2 = Integer.parseInt((String)object6);
            bl2 = false;
            bl = false;
            it = n2;
            boolean bl5 = false;
            $this$loadCommonConfiguration.setWorkerGroupSize(it);
        }
    }
}

