/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.io.ByteReadChannel;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lio/ktor/client/engine/apache/ApacheHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "call", "Lio/ktor/client/call/HttpClientCall;", "requestTime", "Lio/ktor/util/date/GMTDate;", "engineResponse", "Lorg/apache/http/HttpResponse;", "content", "Lkotlinx/coroutines/io/ByteReadChannel;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/client/call/HttpClientCall;Lio/ktor/util/date/GMTDate;Lorg/apache/http/HttpResponse;Lkotlinx/coroutines/io/ByteReadChannel;Lkotlin/coroutines/CoroutineContext;)V", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/io/ByteReadChannel;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Lio/ktor/util/date/GMTDate;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "ktor-client-apache"})
public final class ApacheHttpResponse
implements HttpResponse {
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final Headers headers;
    @NotNull
    private final GMTDate responseTime;
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final GMTDate requestTime;
    private final org.apache.http.HttpResponse engineResponse;
    @NotNull
    private final ByteReadChannel content;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public GMTDate getResponseTime() {
        return this.responseTime;
    }

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public GMTDate getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public ApacheHttpResponse(@NotNull HttpClientCall call, @NotNull GMTDate requestTime, @NotNull org.apache.http.HttpResponse engineResponse, @NotNull ByteReadChannel content, @NotNull CoroutineContext coroutineContext) {
        HttpProtocolVersion httpProtocolVersion;
        StatusLine statusLine;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull((Object)engineResponse, (String)"engineResponse");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        this.call = call;
        this.requestTime = requestTime;
        this.engineResponse = engineResponse;
        this.content = content;
        this.coroutineContext = coroutineContext;
        this.responseTime = DateJvmKt.GMTDate$default(null, (int)1, null);
        StatusLine statusLine2 = statusLine = this.engineResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"statusLine");
        int n = statusLine2.getStatusCode();
        String string = statusLine.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"statusLine.reasonPhrase");
        this.status = new HttpStatusCode(n, string);
        ProtocolVersion protocolVersion = this.engineResponse.getProtocolVersion();
        ApacheHttpResponse apacheHttpResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        ProtocolVersion $this$with = protocolVersion;
        boolean bl3 = false;
        String string2 = $this$with.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"protocol");
        apacheHttpResponse.version = httpProtocolVersion = HttpProtocolVersion.Companion.fromValue(string2, $this$with.getMajor(), $this$with.getMinor());
        protocolVersion = Headers.Companion;
        apacheHttpResponse = this;
        boolean $i$f$build = false;
        HeadersBuilder headersBuilder = new HeadersBuilder(0, 1, null);
        boolean bl4 = false;
        boolean bl5 = false;
        HeadersBuilder $this$build = headersBuilder;
        boolean bl6 = false;
        Header[] headerArray = this.engineResponse.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"engineResponse.allHeaders");
        Header[] $this$forEach$iv = headerArray;
        boolean $i$f$forEach = false;
        Header[] headerArray2 = $this$forEach$iv;
        int n2 = headerArray2.length;
        for (int i = 0; i < n2; ++i) {
            Header element$iv;
            Header headerLine = element$iv = headerArray2[i];
            boolean bl7 = false;
            Header header = headerLine;
            Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"headerLine");
            String string3 = header.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"headerLine.name");
            String string4 = headerLine.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"headerLine.value");
            $this$build.append(string3, string4);
        }
        httpProtocolVersion = headersBuilder.build();
        apacheHttpResponse.headers = httpProtocolVersion;
    }

    @NotNull
    public Job getExecutionContext() {
        return HttpResponse.DefaultImpls.getExecutionContext((HttpResponse)this);
    }

    public void close() {
        HttpResponse.DefaultImpls.close((HttpResponse)this);
    }
}

