/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.engine.apache.InterestControllerHolder;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u001e\u0010\u0018\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/ktor/client/engine/apache/ReactorLoopDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "interestController", "", "queueSize", "<init>", "(Lio/ktor/client/engine/apache/InterestControllerHolder;I)V", "Lkotlin/coroutines/CoroutineContext;", "context", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "block", "", "dispatch", "(Lkotlin/coroutines/CoroutineContext;Ljava/lang/Runnable;)V", "processLoop", "()V", "", "hasTasks", "()Z", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "I", "Ljava/util/concurrent/ArrayBlockingQueue;", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "ktor-client-apache"})
@SourceDebugExtension(value={"SMAP\nReactorLoopDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorLoopDispatcher.kt\nio/ktor/client/engine/apache/ReactorLoopDispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class ReactorLoopDispatcher
extends CoroutineDispatcher {
    @NotNull
    private final InterestControllerHolder interestController;
    private final int queueSize;
    @NotNull
    private final ArrayBlockingQueue<Runnable> queue;

    public ReactorLoopDispatcher(@NotNull InterestControllerHolder interestController, int queueSize) {
        Intrinsics.checkNotNullParameter((Object)interestController, (String)"interestController");
        this.interestController = interestController;
        this.queueSize = queueSize;
        this.queue = new ArrayBlockingQueue(this.queueSize);
    }

    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Job job = (Job)context.get((CoroutineContext.Key)Job.Key);
        boolean bl = job != null ? job.isCancelled() : false;
        if (bl) {
            block.run();
        } else {
            if (!this.queue.add(block)) {
                boolean bl2 = false;
                String string = "Dispatcher queue of size " + this.queueSize + " is full: " + this.queue;
                throw new IllegalStateException(string.toString());
            }
            this.interestController.resumeInputIfPossible();
        }
    }

    public final void processLoop() {
        while (true) {
            Runnable runnable = this.queue.poll();
            if (runnable == null) break;
            runnable.run();
        }
    }

    public final boolean hasTasks() {
        return !((Collection)this.queue).isEmpty();
    }
}

