/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.middleware;

import io.ethers.core.Result;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.BlockWithHashes;
import io.ethers.core.types.BlockWithTransactions;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CreateAccessList;
import io.ethers.core.types.FeeHistory;
import io.ethers.core.types.Hash;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.RPCTransaction;
import io.ethers.core.types.StateOverride;
import io.ethers.core.types.SyncStatus;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.core.types.transaction.TransactionSigned;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.CallFailedError;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007H&J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\"\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\"\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\"\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\"\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\"\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\"\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J*\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J*\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J*\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0003H&J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H&J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000eH\u0016J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0003H\u0016J$\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0016J,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016J8\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J8\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J8\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H&J^\u0010'\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020*0)0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\"\u001a\u00020\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0(2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0016J^\u0010'\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020*0)0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010!\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0(2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0016J^\u0010'\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020*0)0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0(2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H&J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H&J$\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0007H&J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0007H&J\u0014\u00103\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0007H&J$\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u000208H\u0016J$\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0016J$\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00109\u001a\u00020:H\u0016J2\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u0002082\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0(H&J2\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0(H\u0016J2\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00106\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0(H&J\u0014\u0010<\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\b0\u0007H&J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0003H&J$\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J$\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J$\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0003H&J$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\"\u0010C\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH&J\"\u0010D\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH&J(\u0010F\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0(0\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010!\u001a\u00020\u000eH\u0016J(\u0010F\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0(0\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\"\u001a\u00020\u0003H\u0016J(\u0010F\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0(0\u0013\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010I\u001a\u00020JH\u0016J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010I\u001a\u00020\u001cH\u0016J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010I\u001a\u00020KH&J\u001c\u0010L\u001a\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001f\u001a\u00020 H&J\"\u0010N\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010!\u001a\u00020\u000eH\u0016J\"\u0010N\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\"\u001a\u00020\u0003H\u0016J\"\u0010N\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010N\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0(\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010P\u001a\u00020QH&J\"\u0010R\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0S\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010P\u001a\u00020QH&J\u001a\u0010T\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0S\u0012\u0004\u0012\u00020\b0\u0007H&J\u001a\u0010U\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0S\u0012\u0004\u0012\u00020\b0\u0007H&J\u001a\u0010V\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0S\u0012\u0004\u0012\u00020\b0\u0007H&J\u001c\u0010W\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\b0X2\u0006\u0010P\u001a\u00020QH&J\u0014\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0XH&J\u0014\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\b0XH&J\u0014\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0XH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\\\u00c0\u0006\u0001"}, d2={"Lio/ethers/providers/middleware/EthApi;", "", "chainId", "", "getChainId", "()J", "getBlockNumber", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "getBalance", "Ljava/math/BigInteger;", "address", "Lio/ethers/core/types/Address;", "hash", "Lio/ethers/core/types/Hash;", "number", "blockId", "Lio/ethers/core/types/BlockId;", "getBlockHeader", "Ljava/util/Optional;", "Lio/ethers/core/types/BlockWithHashes;", "getBlockWithHashes", "getBlockWithTransactions", "Lio/ethers/core/types/BlockWithTransactions;", "getUncleBlockHeader", "index", "getUncleBlocksCount", "getCode", "Lio/ethers/core/types/Bytes;", "getStorage", "key", "call", "Lio/ethers/core/types/IntoCallRequest;", "blockHash", "blockNumber", "stateOverride", "Lio/ethers/core/types/StateOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "callMany", "", "Lio/ethers/core/Result;", "Lio/ethers/providers/types/CallFailedError;", "calls", "transactionIndex", "", "estimateGas", "createAccessList", "Lio/ethers/core/types/CreateAccessList;", "getGasPrice", "getBlobBaseFee", "getMaxPriorityFeePerGas", "getFeeHistory", "Lio/ethers/core/types/FeeHistory;", "blockCount", "lastBlockName", "Lio/ethers/core/types/BlockId$Name;", "lastBlockNumber", "Lio/ethers/core/types/BlockId$Number;", "rewardPercentiles", "isNodeSyncing", "Lio/ethers/core/types/SyncStatus;", "getBlockTransactionCount", "getTransactionByBlockAndIndex", "Lio/ethers/core/types/RPCTransaction;", "getRawTransactionByBlockAndIndex", "getTransactionCount", "getTransactionByHash", "getTransactionReceipt", "Lio/ethers/core/types/TransactionReceipt;", "getBlockReceipts", "sendRawTransaction", "Lio/ethers/providers/types/PendingTransaction;", "signedTransaction", "Lio/ethers/core/types/transaction/TransactionSigned;", "", "fillTransaction", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "getLogs", "Lio/ethers/core/types/Log;", "filter", "Lio/ethers/core/types/LogFilter;", "watchLogs", "Lio/ethers/providers/types/FilterPoller;", "watchNewBlockHashes", "watchNewPendingTransactionHashes", "watchNewPendingTransactions", "subscribeLogs", "Lio/ethers/providers/types/RpcSubscribe;", "subscribeNewHeads", "subscribeNewPendingTransactions", "subscribeNewPendingTransactionHashes", "ethers-providers"})
public interface EthApi {
    public long getChainId();

    @NotNull
    public RpcRequest<Long, RpcError> getBlockNumber();

    @NotNull
    default public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, @NotNull Hash hash) {
        return this.getBalance(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, long number) {
        return this.getBalance(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockHeader(@NotNull Hash hash) {
        return this.getBlockHeader((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockHeader(long number) {
        return this.getBlockHeader((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockHeader(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockWithHashes(@NotNull Hash hash) {
        return this.getBlockWithHashes((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockWithHashes(long number) {
        return this.getBlockWithHashes((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockWithHashes(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<Optional<BlockWithTransactions>, RpcError> getBlockWithTransactions(@NotNull Hash hash) {
        return this.getBlockWithTransactions((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Optional<BlockWithTransactions>, RpcError> getBlockWithTransactions(long number) {
        return this.getBlockWithTransactions((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Optional<BlockWithTransactions>, RpcError> getBlockWithTransactions(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getUncleBlockHeader(@NotNull Hash hash, long index) {
        return this.getUncleBlockHeader((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    default public RpcRequest<Optional<BlockWithHashes>, RpcError> getUncleBlockHeader(long number, long index) {
        return this.getUncleBlockHeader((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getUncleBlockHeader(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull Hash hash) {
        return this.getUncleBlocksCount((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getUncleBlocksCount(long number) {
        return this.getUncleBlocksCount((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, @NotNull Hash hash) {
        return this.getCode(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, long number) {
        return this.getCode(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> getCode(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, @NotNull Hash hash) {
        return this.getStorage(address, key, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, long number) {
        return this.getStorage(address, key, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Hash, RpcError> getStorage(@NotNull Address var1, @NotNull Hash var2, @NotNull BlockId var3);

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull Hash blockHash) {
        return this.call(call, (BlockId)new BlockId.Hash(blockHash), null, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, long blockNumber) {
        return this.call(call, (BlockId)new BlockId.Number(blockNumber), null, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull BlockId blockId) {
        return this.call(call, blockId, null, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull Hash blockHash, @NotNull StateOverride stateOverride) {
        return this.call(call, (BlockId)new BlockId.Hash(blockHash), stateOverride, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, long blockNumber, @NotNull StateOverride stateOverride) {
        return this.call(call, (BlockId)new BlockId.Number(blockNumber), stateOverride, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull BlockId blockId, @NotNull StateOverride stateOverride) {
        return this.call(call, blockId, stateOverride, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull Hash blockHash, @NotNull BlockOverride blockOverride) {
        return this.call(call, (BlockId)new BlockId.Hash(blockHash), null, blockOverride);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, long blockNumber, @NotNull BlockOverride blockOverride) {
        return this.call(call, (BlockId)new BlockId.Number(blockNumber), null, blockOverride);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull BlockId blockId, @NotNull BlockOverride blockOverride) {
        return this.call(call, blockId, null, blockOverride);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull Hash blockHash, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.call(call, (BlockId)new BlockId.Hash(blockHash), stateOverride, blockOverride);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, long blockNumber, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.call(call, (BlockId)new BlockId.Number(blockNumber), stateOverride, blockOverride);
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest var1, @NotNull BlockId var2, @Nullable StateOverride var3, @Nullable BlockOverride var4);

    @NotNull
    default public RpcRequest<List<Result<Bytes, CallFailedError>>, RpcError> callMany(long blockNumber, @NotNull List<? extends IntoCallRequest> calls, int transactionIndex, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.callMany((BlockId)new BlockId.Number(blockNumber), calls, transactionIndex, stateOverride, blockOverride);
    }

    public static /* synthetic */ RpcRequest callMany$default(EthApi ethApi, long l, List list, int n, StateOverride stateOverride, BlockOverride blockOverride, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callMany");
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            stateOverride = null;
        }
        if ((n2 & 0x10) != 0) {
            blockOverride = null;
        }
        return ethApi.callMany(l, (List<? extends IntoCallRequest>)list, n, stateOverride, blockOverride);
    }

    @NotNull
    default public RpcRequest<List<Result<Bytes, CallFailedError>>, RpcError> callMany(@NotNull Hash blockHash, @NotNull List<? extends IntoCallRequest> calls, int transactionIndex, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.callMany((BlockId)new BlockId.Hash(blockHash), calls, transactionIndex, stateOverride, blockOverride);
    }

    public static /* synthetic */ RpcRequest callMany$default(EthApi ethApi, Hash hash, List list, int n, StateOverride stateOverride, BlockOverride blockOverride, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callMany");
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            stateOverride = null;
        }
        if ((n2 & 0x10) != 0) {
            blockOverride = null;
        }
        return ethApi.callMany(hash, (List<? extends IntoCallRequest>)list, n, stateOverride, blockOverride);
    }

    @NotNull
    public RpcRequest<List<Result<Bytes, CallFailedError>>, RpcError> callMany(@NotNull BlockId var1, @NotNull List<? extends IntoCallRequest> var2, int var3, @Nullable StateOverride var4, @Nullable BlockOverride var5);

    public static /* synthetic */ RpcRequest callMany$default(EthApi ethApi, BlockId blockId, List list, int n, StateOverride stateOverride, BlockOverride blockOverride, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callMany");
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            stateOverride = null;
        }
        if ((n2 & 0x10) != 0) {
            blockOverride = null;
        }
        return ethApi.callMany(blockId, (List<? extends IntoCallRequest>)list, n, stateOverride, blockOverride);
    }

    @NotNull
    default public RpcRequest<Long, RpcError> estimateGas(@NotNull IntoCallRequest call, @NotNull Hash hash) {
        return this.estimateGas(call, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> estimateGas(@NotNull IntoCallRequest call, long number) {
        return this.estimateGas(call, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Long, RpcError> estimateGas(@NotNull IntoCallRequest var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<CreateAccessList, RpcError> createAccessList(@NotNull IntoCallRequest call, @NotNull Hash hash) {
        return this.createAccessList(call, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<CreateAccessList, RpcError> createAccessList(@NotNull IntoCallRequest call, long number) {
        return this.createAccessList(call, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<CreateAccessList, RpcError> createAccessList(@NotNull IntoCallRequest var1, @NotNull BlockId var2);

    @NotNull
    public RpcRequest<BigInteger, RpcError> getGasPrice();

    @NotNull
    public RpcRequest<BigInteger, RpcError> getBlobBaseFee();

    @NotNull
    public RpcRequest<BigInteger, RpcError> getMaxPriorityFeePerGas();

    @NotNull
    default public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, @NotNull BlockId.Name lastBlockName) {
        return this.getFeeHistory(blockCount, lastBlockName, (List<? extends BigInteger>)CollectionsKt.emptyList());
    }

    @NotNull
    default public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, long lastBlockNumber) {
        return this.getFeeHistory(blockCount, lastBlockNumber, (List<? extends BigInteger>)CollectionsKt.emptyList());
    }

    @NotNull
    default public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, @NotNull BlockId.Number lastBlockNumber) {
        return this.getFeeHistory(blockCount, lastBlockNumber, (List<? extends BigInteger>)CollectionsKt.emptyList());
    }

    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long var1, @NotNull BlockId.Name var3, @NotNull List<? extends BigInteger> var4);

    @NotNull
    default public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, long lastBlockNumber, @NotNull List<? extends BigInteger> rewardPercentiles) {
        return this.getFeeHistory(blockCount, new BlockId.Number(lastBlockNumber), rewardPercentiles);
    }

    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long var1, @NotNull BlockId.Number var3, @NotNull List<? extends BigInteger> var4);

    @NotNull
    public RpcRequest<SyncStatus, RpcError> isNodeSyncing();

    @NotNull
    default public RpcRequest<Long, RpcError> getBlockTransactionCount(long number) {
        return this.getBlockTransactionCount((BlockId)new BlockId.Number(number));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull Hash hash) {
        return this.getBlockTransactionCount((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(long number, long index) {
        return this.getTransactionByBlockAndIndex((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    default public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull Hash hash, long index) {
        return this.getTransactionByBlockAndIndex((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(long number, long index) {
        return this.getRawTransactionByBlockAndIndex((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull Hash hash, long index) {
        return this.getRawTransactionByBlockAndIndex((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, long number) {
        return this.getTransactionCount(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, @NotNull Hash hash) {
        return this.getTransactionCount(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    public RpcRequest<Optional<RPCTransaction>, RpcError> getTransactionByHash(@NotNull Hash var1);

    @NotNull
    public RpcRequest<Optional<TransactionReceipt>, RpcError> getTransactionReceipt(@NotNull Hash var1);

    @NotNull
    default public RpcRequest<Optional<List<TransactionReceipt>>, RpcError> getBlockReceipts(@NotNull Hash blockHash) {
        return this.getBlockReceipts((BlockId)new BlockId.Hash(blockHash));
    }

    @NotNull
    default public RpcRequest<Optional<List<TransactionReceipt>>, RpcError> getBlockReceipts(long blockNumber) {
        return this.getBlockReceipts((BlockId)new BlockId.Number(blockNumber));
    }

    @NotNull
    public RpcRequest<Optional<List<TransactionReceipt>>, RpcError> getBlockReceipts(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull TransactionSigned signedTransaction) {
        return this.sendRawTransaction(signedTransaction.toRlp());
    }

    @NotNull
    default public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull Bytes signedTransaction) {
        return this.sendRawTransaction(signedTransaction.asByteArray());
    }

    @NotNull
    public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull byte[] var1);

    @NotNull
    public RpcRequest<TransactionUnsigned, RpcError> fillTransaction(@NotNull IntoCallRequest var1);

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(@NotNull Hash blockHash) {
        return this.getLogs((BlockId)new BlockId.Hash(blockHash));
    }

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(long blockNumber) {
        return this.getLogs((BlockId)new BlockId.Number(blockNumber));
    }

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(@NotNull BlockId blockId) {
        LogFilter logFilter;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            logFilter = new LogFilter().atBlock(blockId);
        } else if (blockId2 instanceof BlockId.Name) {
            logFilter = new LogFilter().blockRange((BlockId.Name)blockId, (BlockId.Name)blockId);
        } else if (blockId2 instanceof BlockId.Number) {
            logFilter = new LogFilter().blockRange((BlockId.Number)blockId, (BlockId.Number)blockId);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LogFilter filter = logFilter;
        return this.getLogs(filter);
    }

    @NotNull
    public RpcRequest<List<Log>, RpcError> getLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcRequest<FilterPoller<Log>, RpcError> watchLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewBlockHashes();

    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewPendingTransactionHashes();

    @NotNull
    public RpcRequest<FilterPoller<RPCTransaction>, RpcError> watchNewPendingTransactions();

    @NotNull
    public RpcSubscribe<Log, RpcError> subscribeLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcSubscribe<BlockWithHashes, RpcError> subscribeNewHeads();

    @NotNull
    public RpcSubscribe<RPCTransaction, RpcError> subscribeNewPendingTransactions();

    @NotNull
    public RpcSubscribe<Hash, RpcError> subscribeNewPendingTransactionHashes();
}

