/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto.bip32;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0013\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/ethers/crypto/bip32/HDPath;", "", "indices", "", "", "<init>", "([Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "depth", "getDepth", "()I", "extend", "index", "hardened", "", "indexAtDepth", "equals", "other", "hashCode", "toString", "", "Companion", "ethers-crypto"})
public final class HDPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Integer[] indices;
    private static final int BIP32_HARDENED_OFFSET = Integer.MIN_VALUE;
    @NotNull
    private static final HDPath ETHEREUM = Companion.parse("m/44'/60'/0'/0");

    public HDPath(@NotNull Integer[] indices) {
        this.indices = indices;
    }

    public final int getDepth() {
        return this.indices.length;
    }

    @JvmOverloads
    @NotNull
    public final HDPath extend(int index, boolean hardened) {
        return new HDPath((Integer[])ArraysKt.plus((Object[])this.indices, (Object)(hardened ? index | Integer.MIN_VALUE : index)));
    }

    public static /* synthetic */ HDPath extend$default(HDPath hDPath, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return hDPath.extend(n, bl);
    }

    public final int indexAtDepth(int depth) {
        return this.indices[depth];
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.crypto.bip32.HDPath");
        HDPath cfr_ignored_0 = (HDPath)other;
        return Arrays.equals((Object[])this.indices, (Object[])((HDPath)other).indices);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.indices);
        return result;
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default((Object[])this.indices, (CharSequence)"/", (CharSequence)"m/", null, (int)0, null, HDPath::toString$lambda$0, (int)28, null);
    }

    @JvmOverloads
    @NotNull
    public final HDPath extend(int index) {
        return HDPath.extend$default(this, index, false, 2, null);
    }

    private static final CharSequence toString$lambda$0(int it) {
        return Companion.isHardened(it) ? (CharSequence)((it & Integer.MAX_VALUE) + "'") : (CharSequence)String.valueOf(it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/ethers/crypto/bip32/HDPath$Companion;", "", "<init>", "()V", "BIP32_HARDENED_OFFSET", "", "ETHEREUM", "Lio/ethers/crypto/bip32/HDPath;", "getETHEREUM", "()Lio/ethers/crypto/bip32/HDPath;", "parse", "path", "", "isHardened", "", "index", "ethers-crypto"})
    @SourceDebugExtension(value={"SMAP\nHDPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HDPath.kt\nio/ethers/crypto/bip32/HDPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n37#3:101\n36#3,3:102\n*S KotlinDebug\n*F\n+ 1 HDPath.kt\nio/ethers/crypto/bip32/HDPath$Companion\n*L\n80#1:97\n80#1:98,3\n88#1:101\n88#1:102,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HDPath getETHEREUM() {
            return ETHEREUM;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HDPath parse(@NotNull String path) {
            void $this$mapTo$iv$iv;
            if (((CharSequence)path).length() == 0 || path.charAt(0) != 'm') {
                throw new IllegalArgumentException("Invalid derivation path: " + path);
            }
            if (Intrinsics.areEqual((Object)path, (Object)"m")) {
                return new HDPath(new Integer[0]);
            }
            String[] stringArray = new String[]{"/"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)path, (CharSequence)"m"), (CharSequence)"/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null) ? Integer.parseInt(StringsKt.dropLast((String)it, (int)1)) | Integer.MIN_VALUE : Integer.parseInt((String)it));
            }
            List indices = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = indices;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new HDPath(thisCollection$iv.toArray(new Integer[0]));
        }

        public final boolean isHardened(int index) {
            return (index & Integer.MIN_VALUE) != 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

