/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.AbiContract;
import io.ethers.abi.call.ContractDeploy;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Hash;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingInclusion;
import io.ethers.providers.types.PendingTransaction;
import java.time.Duration;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\f\u0010\rJ2\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lio/ethers/abi/call/PendingContractDeploy;", "T", "Lio/ethers/abi/AbiContract;", "Lio/ethers/providers/types/PendingInclusion;", "Lio/ethers/abi/call/ContractDeploy;", "provider", "Lio/ethers/providers/middleware/Middleware;", "result", "Lio/ethers/providers/types/PendingTransaction;", "constructor", "Ljava/util/function/BiFunction;", "Lio/ethers/core/types/Address;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/providers/types/PendingTransaction;Ljava/util/function/BiFunction;)V", "hash", "Lio/ethers/core/types/Hash;", "getHash", "()Lio/ethers/core/types/Hash;", "awaitInclusion", "Lio/ethers/core/Result;", "Lio/ethers/providers/types/PendingInclusion$Error;", "retries", "", "interval", "Ljava/time/Duration;", "confirmations", "toString", "", "ethers-abi"})
public final class PendingContractDeploy<T extends AbiContract>
implements PendingInclusion<ContractDeploy<T>> {
    @NotNull
    private final Middleware provider;
    @NotNull
    private final PendingTransaction result;
    @NotNull
    private final BiFunction<Middleware, Address, T> constructor;

    public PendingContractDeploy(@NotNull Middleware provider, @NotNull PendingTransaction result, @NotNull BiFunction<Middleware, Address, T> constructor) {
        this.provider = provider;
        this.result = result;
        this.constructor = constructor;
    }

    @NotNull
    public final Hash getHash() {
        return this.result.getHash();
    }

    @NotNull
    public Result<ContractDeploy<T>, PendingInclusion.Error> awaitInclusion(int retries, @NotNull Duration interval, int confirmations) {
        return this.result.awaitInclusion(retries, interval, confirmations).andThen(arg_0 -> PendingContractDeploy.awaitInclusion$lambda$0(this, arg_0));
    }

    @NotNull
    public String toString() {
        return "PendingContractDeploy(hash=" + this.getHash() + ")";
    }

    private static final Result awaitInclusion$lambda$0(PendingContractDeploy this$0, TransactionReceipt it) {
        Result result;
        if (!it.isSuccessful() || it.getContractAddress() == null) {
            result = ResultKt.success(new ContractDeploy<Object>(null, it));
        } else {
            BiFunction<Middleware, Address, Middleware> biFunction = this$0.constructor;
            Middleware middleware = this$0.provider;
            Address address = it.getContractAddress();
            Intrinsics.checkNotNull((Object)address);
            result = ResultKt.success(new ContractDeploy<AbiContract>((AbiContract)biFunction.apply(middleware, address), it));
        }
        return result;
    }
}

