/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiCodec;
import io.ethers.abi.AbiType;
import io.ethers.core.types.Bytes;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u0013\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001c\u001a\u00020\u00102\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003J\u0013\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0012\b\u0002\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lio/ethers/abi/AbiFunction;", "", "name", "", "inputs", "", "Lio/ethers/abi/AbiType;", "outputs", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getInputs", "()Ljava/util/List;", "getOutputs", "selector", "Lio/ethers/core/types/Bytes;", "getSelector", "()Lio/ethers/core/types/Bytes;", "encodeCall", "args", "", "([Ljava/lang/Object;)Lio/ethers/core/types/Bytes;", "decodeCall", "data", "(Lio/ethers/core/types/Bytes;)[Ljava/lang/Object;", "encodeArgs", "decodeArgs", "encodeResponse", "decodeResponse", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "ethers-abi"})
public final class AbiFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<AbiType<?>> inputs;
    @NotNull
    private final List<AbiType<?>> outputs;
    @NotNull
    private final Bytes selector;

    public AbiFunction(@NotNull String name, @NotNull List<? extends AbiType<?>> inputs, @NotNull List<? extends AbiType<?>> outputs) {
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
        this.selector = new Bytes(ArraysKt.copyOfRange((byte[])AbiType.Companion.computeSignatureHash(this.name, this.inputs), (int)0, (int)4));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<AbiType<?>> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<AbiType<?>> getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final Bytes getSelector() {
        return this.selector;
    }

    @NotNull
    public final Bytes encodeCall(@NotNull Object[] args) {
        return new Bytes(AbiCodec.encodeWithPrefix(this.selector, this.inputs, args));
    }

    @NotNull
    public final Object[] decodeCall(@NotNull Bytes data) {
        return AbiCodec.decodeWithPrefix(this.selector.getSize(), this.inputs, data.asByteArray());
    }

    @NotNull
    public final Bytes encodeArgs(@NotNull Object[] args) {
        return new Bytes(AbiCodec.encode(this.inputs, args));
    }

    @NotNull
    public final Object[] decodeArgs(@NotNull Bytes data) {
        return AbiCodec.decode(this.inputs, data.asByteArray());
    }

    @NotNull
    public final Bytes encodeResponse(@NotNull Object[] data) {
        return new Bytes(AbiCodec.encode(this.outputs, data));
    }

    @NotNull
    public final Object[] decodeResponse(@NotNull Bytes data) {
        return AbiCodec.decode(this.outputs, data.asByteArray());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<AbiType<?>> component2() {
        return this.inputs;
    }

    @NotNull
    public final List<AbiType<?>> component3() {
        return this.outputs;
    }

    @NotNull
    public final AbiFunction copy(@NotNull String name, @NotNull List<? extends AbiType<?>> inputs, @NotNull List<? extends AbiType<?>> outputs) {
        return new AbiFunction(name, inputs, outputs);
    }

    public static /* synthetic */ AbiFunction copy$default(AbiFunction abiFunction, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = abiFunction.name;
        }
        if ((n & 2) != 0) {
            list = abiFunction.inputs;
        }
        if ((n & 4) != 0) {
            list2 = abiFunction.outputs;
        }
        return abiFunction.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "AbiFunction(name=" + this.name + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.outputs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbiFunction)) {
            return false;
        }
        AbiFunction abiFunction = (AbiFunction)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)abiFunction.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, abiFunction.inputs)) {
            return false;
        }
        return Intrinsics.areEqual(this.outputs, abiFunction.outputs);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lio/ethers/abi/AbiFunction$Companion;", "", "<init>", "()V", "parseSignature", "Lio/ethers/abi/AbiFunction;", "signature", "", "cleanArgumentNames", "ParseState", "ethers-abi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AbiFunction parseSignature(@NotNull String signature) {
            CharSequence i2;
            String cleanSignature = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)signature, (String)"function", (String)"", (boolean)false, (int)4, null))).toString();
            ParseState state = ParseState.NAME;
            int startIndex = 0;
            int nestingLevel = 0;
            String name = null;
            String inputsRaw = null;
            String outputsRaw = null;
            int n = ((CharSequence)cleanSignature).length();
            block5: for (int i2 = 0; i2 < n; ++i2) {
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1: {
                        if (cleanSignature.charAt(i2) != '(') continue block5;
                        Intrinsics.checkNotNullExpressionValue((Object)cleanSignature.substring(startIndex, i2), (String)"substring(...)");
                        startIndex = i2 + 1;
                        ++nestingLevel;
                        state = ParseState.INPUTS;
                        continue block5;
                    }
                    case 2: {
                        if (cleanSignature.charAt(i2) == '(') {
                            ++nestingLevel;
                            continue block5;
                        }
                        if (cleanSignature.charAt(i2) != ')' || --nestingLevel != 0) continue block5;
                        String string = cleanSignature.substring(startIndex, i2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        inputsRaw = this.cleanArgumentNames(string);
                        startIndex = i2 + 1;
                        state = ParseState.OUTPUTS;
                        continue block5;
                    }
                    case 3: {
                        if (nestingLevel == 0 && cleanSignature.charAt(i2) != '(') continue block5;
                        if (nestingLevel == 0 && cleanSignature.charAt(i2) == '(') {
                            startIndex = i2 + 1;
                            ++nestingLevel;
                            continue block5;
                        }
                        if (nestingLevel > 0 && cleanSignature.charAt(i2) == '(') {
                            ++nestingLevel;
                            continue block5;
                        }
                        if (cleanSignature.charAt(i2) != ')' || --nestingLevel != 0) continue block5;
                        String string = cleanSignature.substring(startIndex, i2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        outputsRaw = this.cleanArgumentNames(string);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if ((i2 = (CharSequence)name) == null || StringsKt.isBlank((CharSequence)i2)) {
                throw new IllegalArgumentException("Invalid signature, function has no name: " + signature);
            }
            CharSequence charSequence = inputsRaw;
            List<AbiType<?>> inputs = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? CollectionsKt.emptyList() : AbiType.Companion.parseSignature(inputsRaw);
            CharSequence charSequence2 = outputsRaw;
            List<AbiType<?>> outputs = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? CollectionsKt.emptyList() : AbiType.Companion.parseSignature(outputsRaw);
            return new AbiFunction(name, inputs, outputs);
        }

        private final String cleanArgumentNames(String signature) {
            char[] cArray = new char[]{','};
            return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)signature, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)",", null, null, (int)0, null, Companion::cleanArgumentNames$lambda$0, (int)30, null);
        }

        private static final CharSequence cleanArgumentNames$lambda$0(String it) {
            CharSequence charSequence;
            String cleaned = ((Object)StringsKt.trim((CharSequence)it)).toString();
            if (StringsKt.startsWith$default((CharSequence)cleaned, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)cleaned, (char)')', (boolean)false, (int)2, null)) {
                String string = cleaned.substring(1, cleaned.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                charSequence = "(" + Companion.cleanArgumentNames(string) + ")";
            } else {
                char[] cArray = new char[]{' '};
                charSequence = (CharSequence)CollectionsKt.first((List)StringsKt.split$default((CharSequence)cleaned, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
            return charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ethers/abi/AbiFunction$Companion$ParseState;", "", "<init>", "(Ljava/lang/String;I)V", "NAME", "INPUTS", "OUTPUTS", "ethers-abi"})
        private static final class ParseState
        extends Enum<ParseState> {
            public static final /* enum */ ParseState NAME = new ParseState();
            public static final /* enum */ ParseState INPUTS = new ParseState();
            public static final /* enum */ ParseState OUTPUTS = new ParseState();
            private static final /* synthetic */ ParseState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ParseState[] values() {
                return (ParseState[])$VALUES.clone();
            }

            public static ParseState valueOf(String value) {
                return Enum.valueOf(ParseState.class, value);
            }

            @NotNull
            public static EnumEntries<ParseState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = parseStateArray = new ParseState[]{ParseState.NAME, ParseState.INPUTS, ParseState.OUTPUTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParseState.values().length];
                try {
                    nArray[ParseState.NAME.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.INPUTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.OUTPUTS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

