package com.sksamuel.kotest.engine.extensions.test

import io.kotest.common.ExperimentalKotest
import io.kotest.core.project.ProjectContext
import io.kotest.core.config.ProjectConfiguration
import io.kotest.core.spec.IsolationMode
import io.kotest.core.spec.style.BehaviorSpec
import io.kotest.core.spec.style.DescribeSpec
import io.kotest.core.spec.style.ExpectSpec
import io.kotest.core.spec.style.FeatureSpec
import io.kotest.core.spec.style.FreeSpec
import io.kotest.core.spec.style.FunSpec
import io.kotest.core.spec.style.ShouldSpec
import io.kotest.core.spec.style.StringSpec
import io.kotest.core.spec.style.WordSpec
import io.kotest.core.test.TestCase
import io.kotest.core.test.TestResult
import io.kotest.engine.concurrency.NoopCoroutineDispatcherFactory
import io.kotest.engine.extensions.ExtensionException
import io.kotest.engine.interceptors.EngineContext
import io.kotest.engine.listener.AbstractTestEngineListener
import io.kotest.engine.spec.SpecExecutor
import io.kotest.matchers.throwable.shouldHaveMessage
import io.kotest.matchers.types.shouldBeInstanceOf

private class BehaviorSpecWithAfterTestError : BehaviorSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   given("given") {
      When("when") {
         then("then") {
         }
      }
   }
})

private class FunSpecWithAfterTestError : FunSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   test("fun spec") {}
})

private class StringSpecWithAfterTestError : StringSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   "string test"{}
})

private class ShouldSpecWithAfterTestError : ShouldSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   should("foo") {}
})

private class DescribeSpecWithAfterTestError : DescribeSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
})

private class FeatureSpecWithAfterTestError : FeatureSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   feature("feature") {
      scenario("scenario") { }
   }
})

private class ExpectSpecWithAfterTestError : ExpectSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
})

private class FreeSpecWithAfterTestError : FreeSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   "test" {}
})

private class WordSpecWithAfterTestError : WordSpec({
   isolationMode = IsolationMode.InstancePerTest
   afterTest {
      error("boom")
   }
   "this test" should {
      "be alive" {}
   }
})

@ExperimentalKotest
class AfterTestExceptionTest : WordSpec({

   var error: Throwable? = null

   val listener = object : AbstractTestEngineListener() {
      override suspend fun testFinished(testCase: TestCase, result: TestResult) {
         if (result is TestResult.Error)
            error = result.cause
      }
   }

   "an exception in before test" should {
      "fail the test for behavior spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(BehaviorSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for feature spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(FeatureSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for word spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(WordSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for should spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(ShouldSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for string spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(StringSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for describe spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(DescribeSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for free spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(FreeSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for fun spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(FunSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
      "fail the test for expect spec" {
         val executor = SpecExecutor(listener, NoopCoroutineDispatcherFactory, EngineContext(ProjectConfiguration()))
         executor.execute(ExpectSpecWithAfterTestError::class)
         error.shouldBeInstanceOf<ExtensionException.AfterTestException>()
         error!!.cause!!.shouldHaveMessage("boom")
      }
   }
})
