/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.JSONArray;
import io.kjson.JSONObject;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointerException;
import io.kjson.pointer.JSONReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.pipeline.AbstractIntPipeline;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.StringAcceptor;
import net.pwall.pipeline.codec.CodePoint_UTF8;
import net.pwall.pipeline.codec.UTF8_CodePoint;
import net.pwall.pipeline.uri.URIDecoder;
import net.pwall.pipeline.uri.URIEncoder;
import net.pwall.util.IntOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086\u0004J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0086\u0004J\b\u0010!\u001a\u00020\u0003H\u0016J\u0006\u0010\"\u001a\u00020\u0003R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lio/kjson/pointer/JSONPointer;", "", "pointer", "", "(Ljava/lang/String;)V", "tokens", "", "([Ljava/lang/String;)V", "current", "getCurrent", "()Ljava/lang/String;", "getTokens", "()[Ljava/lang/String;", "[Ljava/lang/String;", "child", "index", "", "string", "equals", "", "other", "existsIn", "json", "Lio/kjson/JSONValue;", "find", "base", "hashCode", "locateChild", "value", "target", "parent", "ref", "Lio/kjson/pointer/JSONReference;", "toString", "toURIFragment", "Companion", "EscapePipeline", "SchemaURIEncoder", "kjson-pointer"})
public final class JSONPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] tokens;
    @NotNull
    private static final JSONPointer root;
    @NotNull
    private static final String emptyString = "";

    public JSONPointer(@NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.tokens = tokens;
    }

    @NotNull
    public final String[] getTokens() {
        return this.tokens;
    }

    public JSONPointer(@NotNull String pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this(Companion.parseString(pointer));
    }

    @Nullable
    public final JSONValue find(@Nullable JSONValue base) {
        return Companion.find(this.tokens, base);
    }

    public final boolean existsIn(@Nullable JSONValue json) {
        return Companion.existsIn(this.tokens, json);
    }

    @NotNull
    public final JSONPointer parent() {
        JSONPointer jSONPointer;
        int len = this.tokens.length;
        switch (len) {
            case 0: {
                throw new JSONPointerException("Can't get parent of root JSON Pointer");
            }
            case 1: {
                jSONPointer = root;
                break;
            }
            default: {
                int n = 0;
                int n2 = len - 1;
                String[] stringArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    stringArray[n3] = this.tokens[n3];
                }
                String[] stringArray2 = stringArray;
                jSONPointer = new JSONPointer(stringArray2);
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final JSONPointer child(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int len = this.tokens.length;
        int n = len + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 < len ? this.tokens[n2] : string;
        }
        String[] stringArray2 = stringArray;
        return new JSONPointer(stringArray2);
    }

    @NotNull
    public final JSONPointer child(int index2) {
        if (index2 < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        return this.child(String.valueOf(index2));
    }

    @Nullable
    public final String getCurrent() {
        return this.tokens.length == 0 ? null : this.tokens[this.tokens.length - 1];
    }

    @NotNull
    public final String toURIFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        EscapePipeline pipeline = new EscapePipeline((IntAcceptor)new CodePoint_UTF8((IntAcceptor)new SchemaURIEncoder((IntAcceptor)new StringAcceptor(sb))));
        for (String token : this.tokens) {
            sb.append('/');
            pipeline.accept(token);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Nullable
    public final JSONPointer locateChild(@Nullable JSONValue value, @Nullable JSONValue target) {
        block4: {
            block3: {
                if (value == target) {
                    return this;
                }
                if (!(value instanceof JSONObject)) break block3;
                for (String key : ((JSONObject)value).keySet()) {
                    JSONPointer jSONPointer = this.child(key).locateChild((JSONValue)((JSONObject)value).get((Object)key), target);
                    if (jSONPointer == null) continue;
                    JSONPointer it = jSONPointer;
                    boolean bl = false;
                    return it;
                }
                break block4;
            }
            if (!(value instanceof JSONArray)) break block4;
            int n = 0;
            int n2 = ((JSONArray)value).size();
            while (n < n2) {
                int i = n++;
                JSONPointer jSONPointer = this.child(i).locateChild(((JSONArray)value).get(i), target);
                if (jSONPointer == null) continue;
                JSONPointer it = jSONPointer;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    @NotNull
    public final JSONReference ref(@Nullable JSONValue base) {
        return Companion.existsIn(this.tokens, base) ? new JSONReference(base, this.tokens, true, Companion.find(this.tokens, base)) : new JSONReference(base, this.tokens, false, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONPointer && Arrays.equals(this.tokens, ((JSONPointer)other).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    @NotNull
    public String toString() {
        return Companion.toString(this.tokens, this.tokens.length);
    }

    static {
        boolean $i$f$emptyArray = false;
        root = new JSONPointer(new String[0]);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/kjson/pointer/JSONPointer$SchemaURIEncoder;", "T", "Lnet/pwall/pipeline/AbstractIntPipeline;", "next", "Lnet/pwall/pipeline/IntAcceptor;", "(Lnet/pwall/pipeline/IntAcceptor;)V", "acceptInt", "", "value", "", "kjson-pointer"})
    public static final class SchemaURIEncoder<T>
    extends AbstractIntPipeline<T> {
        public SchemaURIEncoder(@NotNull IntAcceptor<T> next) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            super(next);
        }

        public void acceptInt(int value) {
            if (URIEncoder.isUnreservedURI((int)value) || value == 36) {
                this.emit(value);
            } else {
                this.emit(37);
                IntOutput.output2Hex((int)value, arg_0 -> ((SchemaURIEncoder)this).emit(arg_0));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/kjson/pointer/JSONPointer$EscapePipeline;", "T", "Lnet/pwall/pipeline/AbstractIntPipeline;", "next", "Lnet/pwall/pipeline/IntAcceptor;", "(Lnet/pwall/pipeline/IntAcceptor;)V", "acceptInt", "", "value", "", "kjson-pointer"})
    public static final class EscapePipeline<T>
    extends AbstractIntPipeline<T> {
        public EscapePipeline(@NotNull IntAcceptor<T> next) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            super(next);
        }

        public void acceptInt(int value) {
            int n = value;
            if (n == 126) {
                this.emit(126);
                this.emit(48);
            } else if (n == 47) {
                this.emit(126);
                this.emit(49);
            } else {
                this.emit(value);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J#\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J#\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J%\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0004J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010$\u001a\u00020\n\u00a2\u0006\u0002\u0010%J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lio/kjson/pointer/JSONPointer$Companion;", "", "()V", "emptyString", "", "root", "Lio/kjson/pointer/JSONPointer;", "getRoot", "()Lio/kjson/pointer/JSONPointer;", "checkIndex", "", "token", "lazyMessage", "Lkotlin/Function0;", "checkNumber", "", "error", "", "tokens", "", "tokenIndex", "([Ljava/lang/String;I)Ljava/lang/Void;", "escape", "existsIn", "base", "Lio/kjson/JSONValue;", "([Ljava/lang/String;Lio/kjson/JSONValue;)Z", "string", "find", "([Ljava/lang/String;Lio/kjson/JSONValue;)Lio/kjson/JSONValue;", "pointer", "fromURIFragment", "fragment", "parseString", "(Ljava/lang/String;)[Ljava/lang/String;", "toStr1", "n", "([Ljava/lang/String;I)Ljava/lang/String;", "toString", "unescape", "kjson-pointer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONPointer getRoot() {
            return root;
        }

        @Nullable
        public final JSONValue find(@NotNull String pointer, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return this.find(this.parseString(pointer), base);
        }

        @Nullable
        public final JSONValue find(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue result = base;
            int n = 0;
            int n2 = tokens.length;
            while (n < n2) {
                JSONValue jSONValue;
                int i = n++;
                String token = tokens[i];
                JSONValue jSONValue2 = result;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)result).containsKey((Object)token)) {
                        this.error(tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
                } else if (jSONValue2 instanceof JSONArray) {
                    if (Intrinsics.areEqual((Object)token, (Object)"-")) {
                        throw new JSONPointerException(Intrinsics.stringPlus((String)"Can't dereference end-of-array JSON Pointer ", (Object)this.toStr1(tokens, i)));
                    }
                    int index2 = this.checkIndex(token, (Function0<String>)((Function0)new Function0<String>(tokens, i){
                        final /* synthetic */ String[] $tokens;
                        final /* synthetic */ int $i;
                        {
                            this.$tokens = $tokens;
                            this.$i = $i;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)"Illegal array index in JSON Pointer ", (Object)io.kjson.pointer.JSONPointer$Companion.access$toStr1(JSONPointer.Companion, this.$tokens, this.$i));
                        }
                    }));
                    if (index2 < 0 || index2 >= ((JSONArray)result).size()) {
                        throw new JSONPointerException(Intrinsics.stringPlus((String)"Array index out of range in JSON Pointer ", (Object)this.toStr1(tokens, i)));
                    }
                    jSONValue = ((JSONArray)result).get(index2);
                } else {
                    this.error(tokens, i + 1);
                    throw new KotlinNothingValueException();
                }
                result = jSONValue;
            }
            return result;
        }

        public final boolean existsIn(@NotNull String string, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return this.existsIn(this.parseString(string), base);
        }

        public final boolean existsIn(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue jSONValue = base;
            if (jSONValue == null) {
                return false;
            }
            JSONValue current = jSONValue;
            for (String token : tokens) {
                JSONValue jSONValue2 = current;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)current).containsKey((Object)token)) {
                        return false;
                    }
                    current = (JSONValue)((JSONObject)current).get((Object)token);
                    continue;
                }
                if (jSONValue2 instanceof JSONArray) {
                    if (!this.checkNumber(token)) {
                        return false;
                    }
                    int index2 = Integer.parseInt(token);
                    if (index2 < 0 || index2 >= ((JSONArray)current).size()) {
                        return false;
                    }
                    current = ((JSONArray)current).get(index2);
                    continue;
                }
                return false;
            }
            return true;
        }

        private final int checkIndex(String token, Function0<String> lazyMessage) {
            if (!this.checkNumber(token)) {
                throw new JSONPointerException((String)lazyMessage.invoke());
            }
            return Integer.parseInt(token);
        }

        private final boolean checkNumber(String token) {
            int len = token.length();
            if (len < 1 || len > 8) {
                return false;
            }
            char ch = token.charAt(0);
            if (ch == '0') {
                return len == 1;
            }
            int i = 1;
            while ('0' <= ch ? ch < ':' : false) {
                if (i >= len) {
                    return true;
                }
                int n = i;
                i = n + 1;
                ch = token.charAt(n);
            }
            return false;
        }

        private final Void error(String[] tokens, int tokenIndex) {
            throw new JSONPointerException(Intrinsics.stringPlus((String)"Can't resolve JSON Pointer ", (Object)this.toString(tokens, tokenIndex)));
        }

        private final String toStr1(String[] tokens, int n) {
            return this.toString(tokens, n + 1);
        }

        @NotNull
        public final String toString(@NotNull String[] tokens, int n) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (n == 0) {
                return JSONPointer.emptyString;
            }
            StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                int i = n2++;
                $this$toString_u24lambda_u2d0.append('/');
                $this$toString_u24lambda_u2d0.append(Companion.escape(tokens[i]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026\n            }.toString()");
            return string;
        }

        @NotNull
        public final String escape(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            int len = token.length();
            int i = 0;
            char ch = '\u0000';
            while (true) {
                if (i >= len) {
                    return token;
                }
                ch = token.charAt(i);
                if (ch == '~' || ch == '/') break;
                int n = i;
                i = n + 1;
            }
            StringBuilder sb = new StringBuilder(len + 8);
            sb.append(token, 0, i);
            while (true) {
                char c;
                if ((c = ch) == '~') {
                    sb.append("~0");
                } else if (c == '/') {
                    sb.append("~1");
                } else {
                    sb.append(ch);
                }
                if (++i >= len) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return string;
                }
                ch = token.charAt(i);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String[] parseString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (((CharSequence)string).length() == 0) {
                boolean $i$f$emptyArray = false;
                return new String[0];
            }
            if (string.charAt(0) != '/') {
                throw new JSONPointerException(Intrinsics.stringPlus((String)"Illegal JSON Pointer ", (Object)string));
            }
            Object object = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            char[] $i$f$emptyArray = new char[]{'/'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])$i$f$emptyArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.unescape((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return stringArray;
        }

        private final String unescape(String token) {
            int len = token.length();
            int i = 0;
            while (true) {
                if (i >= len) {
                    return token;
                }
                if (token.charAt(i) == '~') break;
                int n = i;
                i = n + 1;
            }
            StringBuilder sb = new StringBuilder(len);
            sb.append(token, 0, i);
            block1: while (true) {
                if (++i >= len) {
                    throw new JSONPointerException(Intrinsics.stringPlus((String)"Illegal token in JSON Pointer ", (Object)token));
                }
                char c = token.charAt(i);
                if (c == '0') {
                    sb.append('~');
                } else if (c == '1') {
                    sb.append('/');
                } else {
                    throw new JSONPointerException(Intrinsics.stringPlus((String)"Illegal token in JSON Pointer ", (Object)token));
                }
                while (true) {
                    if (++i >= len) {
                        String string = sb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                        return string;
                    }
                    char ch = token.charAt(i);
                    if (ch == '~') continue block1;
                    sb.append(ch);
                }
                break;
            }
        }

        @NotNull
        public final JSONPointer fromURIFragment(@NotNull String fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            if (((CharSequence)fragment).length() == 0 || fragment.charAt(0) != '#') {
                throw new JSONPointerException(Intrinsics.stringPlus((String)"Illegal URI fragment ", (Object)fragment));
            }
            URIDecoder pipeline = new URIDecoder((IntAcceptor)new UTF8_CodePoint((IntAcceptor)new StringAcceptor()));
            try {
                int n = 1;
                int n2 = fragment.length();
                while (n < n2) {
                    int i = n++;
                    pipeline.accept((int)fragment.charAt(i));
                }
                pipeline.close();
            }
            catch (Exception e) {
                throw new JSONPointerException(Intrinsics.stringPlus((String)"Illegal URI fragment ", (Object)fragment));
            }
            Object object = pipeline.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pipeline.result");
            return new JSONPointer((String)object);
        }

        public static final /* synthetic */ String access$toStr1(Companion $this, String[] tokens, int n) {
            return $this.toStr1(tokens, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

