/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.pointer.JSONPointer;
import io.kjson.pointer.JSONPointerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.pwall.text.CharMapResult;
import net.pwall.text.MapResult;
import net.pwall.text.StringMapper;
import net.pwall.text.URIStringMapper;
import net.pwall.text.UTF8StringMapper;
import net.pwall.util.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0013\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\fJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u0006\u0010\u001d\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\b\u0010\"\u001a\u00020\u0003H\u0016J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\fJ\u0006\u0010$\u001a\u00020\u0003J\u0011\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0013J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lio/kjson/pointer/JSONPointer;", "", "pointer", "", "(Ljava/lang/String;)V", "tokens", "", "([Ljava/lang/String;)V", "current", "getCurrent", "()Ljava/lang/String;", "depth", "", "getDepth", "()I", "isRoot", "", "()Z", "getTokens$kjson_pointer_core", "()[Ljava/lang/String;", "[Ljava/lang/String;", "child", "childPointer", "index", "string", "equals", "other", "getToken", "hashCode", "parent", "plus", "throwPointerException", "", "text", "toString", "numTokens", "toURIFragment", "tokensAsArray", "tokensAsList", "", "truncate", "n", "withParent", "Companion", "kjson-pointer-core"})
@SourceDebugExtension(value={"SMAP\nJSONPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,313:1\n26#2:314\n26#2:315\n*S KotlinDebug\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer\n*L\n70#1:314\n200#1:315\n*E\n"})
public final class JSONPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] tokens;
    @NotNull
    private static final JSONPointer root;
    @NotNull
    private static final String emptyString = "";
    @NotNull
    private static final CharMapResult mapJSONPointerTilde;
    @NotNull
    private static final CharMapResult mapJSONPointerSlash;

    public JSONPointer(@NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.tokens = tokens;
    }

    @NotNull
    public final String[] getTokens$kjson_pointer_core() {
        return this.tokens;
    }

    public JSONPointer(@NotNull String pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this(Companion.parseString(pointer));
    }

    public final int getDepth() {
        return this.tokens.length;
    }

    @Nullable
    public final String getCurrent() {
        return (String)ArraysKt.lastOrNull((Object[])this.tokens);
    }

    public final boolean isRoot() {
        return this.tokens.length == 0;
    }

    @NotNull
    public final String[] tokensAsArray() {
        String[] stringArray;
        if (this.tokens.length == 0) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = Arrays.copyOf(this.tokens, this.tokens.length);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"copyOf(...)");
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @NotNull
    public final List<String> tokensAsList() {
        ImmutableList immutableList = ImmutableList.listOf((Object[])this.tokens);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"listOf(...)");
        return (List)immutableList;
    }

    @NotNull
    public final JSONPointer parent() {
        JSONPointer jSONPointer;
        int len = this.tokens.length;
        switch (len) {
            case 0: {
                Companion.throwRootParentError();
                throw new KotlinNothingValueException();
            }
            case 1: {
                jSONPointer = root;
                break;
            }
            default: {
                Object[] objectArray = this.tokens;
                int n = 0;
                int n2 = len - 1;
                JSONPointer jSONPointer2 = new JSONPointer((String[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2));
                jSONPointer = jSONPointer2;
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final JSONPointer child(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new JSONPointer((String[])ArraysKt.plus((Object[])this.tokens, (Object)string));
    }

    @NotNull
    public final JSONPointer child(int index) {
        if (index < 0) {
            this.throwPointerException("JSON Pointer index " + index + " must not be negative");
            throw new KotlinNothingValueException();
        }
        return this.child(String.valueOf(index));
    }

    @NotNull
    public final JSONPointer child(@NotNull JSONPointer childPointer) {
        Intrinsics.checkNotNullParameter((Object)childPointer, (String)"childPointer");
        if (this.isRoot()) {
            return childPointer;
        }
        if (childPointer.isRoot()) {
            return this;
        }
        return new JSONPointer((String[])ArraysKt.plus((Object[])this.tokens, (Object[])childPointer.tokens));
    }

    @NotNull
    public final JSONPointer withParent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = this.tokens.length + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 == 0 ? string : this.tokens[n2 - 1];
        }
        String[] stringArray2 = stringArray;
        return new JSONPointer(stringArray2);
    }

    @NotNull
    public final JSONPointer withParent(int index) {
        if (index < 0) {
            this.throwPointerException("JSON Pointer index " + index + " must not be negative");
            throw new KotlinNothingValueException();
        }
        return this.withParent(String.valueOf(index));
    }

    @NotNull
    public final JSONPointer withParent(@NotNull JSONPointer parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (this.isRoot()) {
            return parent;
        }
        if (parent.isRoot()) {
            return this;
        }
        return new JSONPointer((String[])ArraysKt.plus((Object[])parent.tokens, (Object[])this.tokens));
    }

    @NotNull
    public final JSONPointer plus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.child(string);
    }

    @NotNull
    public final JSONPointer plus(int index) {
        return this.child(index);
    }

    @NotNull
    public final JSONPointer plus(@NotNull JSONPointer childPointer) {
        Intrinsics.checkNotNullParameter((Object)childPointer, (String)"childPointer");
        return this.child(childPointer);
    }

    @NotNull
    public final JSONPointer truncate(int n) {
        JSONPointer jSONPointer;
        int n2 = n;
        if (n2 == 0) {
            jSONPointer = root;
        } else if (n2 == this.getDepth()) {
            jSONPointer = this;
        } else {
            boolean bl = 1 <= n2 ? n2 < this.getDepth() : false;
            if (bl) {
                Object[] objectArray = this.tokens;
                int n3 = 0;
                JSONPointer jSONPointer2 = new JSONPointer((String[])ArraysKt.copyOfRange((Object[])objectArray, (int)n3, (int)n));
                jSONPointer = jSONPointer2;
            } else {
                this.throwPointerException("Illegal truncate (" + n + ')');
                throw new KotlinNothingValueException();
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final String toURIFragment() {
        StringBuilder stringBuilder;
        StringBuilder $this$toURIFragment_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String token : this.tokens) {
            $this$toURIFragment_u24lambda_u240.append('/');
            $this$toURIFragment_u24lambda_u240.append(URIStringMapper.INSTANCE.encodeURI(UTF8StringMapper.INSTANCE.encodeUTF8(Companion.encodeJSONPointerToken(token))));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getToken(int index) {
        return this.tokens[index];
    }

    @NotNull
    public final Void throwPointerException(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new JSONPointerException(text, this);
    }

    @NotNull
    public final String toString(int numTokens) {
        return Companion.toString(this.tokens, numTokens);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONPointer && Arrays.equals(this.tokens, ((JSONPointer)other).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    @NotNull
    public String toString() {
        return Companion.toString(this.tokens, this.tokens.length);
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerTilde$cp() {
        return mapJSONPointerTilde;
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerSlash$cp() {
        return mapJSONPointerSlash;
    }

    static {
        boolean $i$f$emptyArray = false;
        root = new JSONPointer(new String[0]);
        mapJSONPointerTilde = new CharMapResult(2, '~');
        mapJSONPointerSlash = new CharMapResult(2, '/');
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\r\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004J\u001f\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ!\u0010\u001c\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\n\u0010 \u001a\u00020\u0004*\u00020\u0004J\n\u0010!\u001a\u00020\u0004*\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lio/kjson/pointer/JSONPointer$Companion;", "", "()V", "emptyString", "", "getEmptyString$annotations", "mapJSONPointerSlash", "Lnet/pwall/text/CharMapResult;", "mapJSONPointerTilde", "root", "Lio/kjson/pointer/JSONPointer;", "getRoot", "()Lio/kjson/pointer/JSONPointer;", "from", "array", "", "([Ljava/lang/String;)Lio/kjson/pointer/JSONPointer;", "list", "", "fromURIFragment", "fragment", "of", "tokens", "parseString", "string", "(Ljava/lang/String;)[Ljava/lang/String;", "throwRootParentError", "", "toString", "n", "", "([Ljava/lang/String;I)Ljava/lang/String;", "decodeJSONPointerToken", "encodeJSONPointerToken", "kjson-pointer-core"})
    @SourceDebugExtension(value={"SMAP\nJSONPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n37#2,2:314\n37#2,2:321\n26#3:316\n1549#4:317\n1620#4,3:318\n*S KotlinDebug\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n*L\n220#1:314,2\n252#1:321,2\n241#1:316\n244#1:317\n244#1:318,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONPointer getRoot() {
            return root;
        }

        private static /* synthetic */ void getEmptyString$annotations() {
        }

        @NotNull
        public final JSONPointer of(String ... tokens) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (tokens.length == 0) {
                jSONPointer = this.getRoot();
            } else {
                String[] stringArray = Arrays.copyOf(tokens, tokens.length);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                jSONPointer = new JSONPointer(stringArray);
            }
            return jSONPointer;
        }

        @NotNull
        public final JSONPointer from(@NotNull String[] array) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (array.length == 0) {
                jSONPointer = this.getRoot();
            } else {
                String[] stringArray = Arrays.copyOf(array, array.length);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                jSONPointer = new JSONPointer(stringArray);
            }
            return jSONPointer;
        }

        @NotNull
        public final JSONPointer from(@NotNull List<String> list) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (list.isEmpty()) {
                jSONPointer = this.getRoot();
            } else {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                JSONPointer jSONPointer2 = new JSONPointer(thisCollection$iv.toArray(new String[0]));
                jSONPointer = jSONPointer2;
            }
            return jSONPointer;
        }

        @NotNull
        public final String toString(@NotNull String[] tokens, int n) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (n == 0) {
                return JSONPointer.emptyString;
            }
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                $this$toString_u24lambda_u240.append('/');
                $this$toString_u24lambda_u240.append(Companion.encodeJSONPointerToken(tokens[i]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String[] parseString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (((CharSequence)string).length() == 0) {
                boolean $i$f$emptyArray = false;
                return new String[0];
            }
            if (string.charAt(0) != '/') {
                throw new JSONPointerException("Illegal JSON Pointer - \"" + string + '\"', null, 2, null);
            }
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            char[] $i$f$emptyArray = new char[]{'/'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (char[])$i$f$emptyArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    void it;
                    string3 = Companion.decodeJSONPointerToken((String)it);
                }
                catch (JSONPointerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JSONPointerException("Illegal token in JSON Pointer - \"" + string + '\"', null, 2, null).withCause(e);
                }
                collection.add(string3);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        @NotNull
        public final JSONPointer fromURIFragment(@NotNull String fragment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            try {
                string = UTF8StringMapper.INSTANCE.decodeUTF8(URIStringMapper.INSTANCE.decodeURI(fragment));
            }
            catch (Exception e) {
                throw new JSONPointerException("Illegal URI fragment - \"" + fragment + '\"', null, 2, null).withCause(e);
            }
            String pointer = string;
            return new JSONPointer(pointer);
        }

        @NotNull
        public final String encodeJSONPointerToken(@NotNull String $this$encodeJSONPointerToken) {
            Intrinsics.checkNotNullParameter((Object)$this$encodeJSONPointerToken, (String)"<this>");
            return StringMapper.INSTANCE.mapCharacters($this$encodeJSONPointerToken, (Function1)encodeJSONPointerToken.1.INSTANCE);
        }

        @NotNull
        public final String decodeJSONPointerToken(@NotNull String $this$decodeJSONPointerToken) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeJSONPointerToken, (String)"<this>");
            return StringMapper.INSTANCE.mapSubstrings($this$decodeJSONPointerToken, (Function1)new Function1<Integer, MapResult>($this$decodeJSONPointerToken){
                final /* synthetic */ String $this_decodeJSONPointerToken;
                {
                    this.$this_decodeJSONPointerToken = $receiver;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final MapResult invoke(int index) {
                    try {
                        CharMapResult charMapResult;
                        if (this.$this_decodeJSONPointerToken.charAt(index) == '~') {
                            StringMapper.checkLength$default((StringMapper)StringMapper.INSTANCE, (String)this.$this_decodeJSONPointerToken, (int)index, (int)2, null, (int)8, null);
                            char c = this.$this_decodeJSONPointerToken.charAt(index + 1);
                            if (c == '0') {
                                charMapResult = JSONPointer.access$getMapJSONPointerTilde$cp();
                                return (MapResult)charMapResult;
                            } else {
                                if (c != '1') throw new IllegalArgumentException("Invalid escape sequence in \"" + this.$this_decodeJSONPointerToken + '\"');
                                charMapResult = JSONPointer.access$getMapJSONPointerSlash$cp();
                            }
                            return (MapResult)charMapResult;
                        } else {
                            charMapResult = null;
                        }
                        return (MapResult)charMapResult;
                    }
                    catch (Exception e) {
                        throw new JSONPointerException("Illegal token in JSON Pointer - \"" + this.$this_decodeJSONPointerToken + '\"', null, 2, null).withCause(e);
                    }
                }
            });
        }

        @NotNull
        public final Void throwRootParentError() {
            throw new JSONPointerException("Can't get parent of root JSON Pointer", this.getRoot());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

