/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.ParseException;
import io.kjson.parser.ParseOptions;
import io.kjson.parser.ParserConstants;
import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lio/kjson/parser/Parser;", "", "()V", "duplicateKeyError", "", "key", "", "pointer", "parse", "Lio/kjson/JSONValue;", "json", "options", "Lio/kjson/parser/ParseOptions;", "tm", "Lnet/pwall/text/TextMatcher;", "depth", "", "parseLines", "Lio/kjson/JSONArray;", "jsonLines", "parseString", "matchIdentifier", "", "kjson-core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String json, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(json);
        tm.match('\ufeff');
        JSONValue result = this.parse(tm, options, "", 0);
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (!tm.isAtEnd()) {
            throw new ParseException("Excess characters following JSON", null, 2, null);
        }
        return result;
    }

    public static /* synthetic */ JSONValue parse$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parse(string, parseOptions);
    }

    @NotNull
    public final JSONArray parseLines(@NotNull String jsonLines, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)jsonLines, (String)"jsonLines");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(jsonLines);
        tm.match('\ufeff');
        return JSONArray.Companion.build((Function1<? super JSONArray.Builder, Unit>)((Function1)new Function1<JSONArray.Builder, Unit>(tm, options){
            final /* synthetic */ TextMatcher $tm;
            final /* synthetic */ ParseOptions $options;
            {
                this.$tm = $tm;
                this.$options = $options;
                super(1);
            }

            public final void invoke(@NotNull JSONArray.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                this.$tm.skip(JSONFunctions::isSpaceCharacter);
                int counter = 0;
                while (!this.$tm.isAtEnd()) {
                    $this$build.add(Parser.access$parse(Parser.INSTANCE, this.$tm, this.$options, "" + '/' + counter++, 0));
                    this.$tm.skip(JSONFunctions::isSpaceCharacter);
                }
            }
        }));
    }

    public static /* synthetic */ JSONArray parseLines$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parseLines(string, parseOptions);
    }

    private final JSONValue parse(TextMatcher tm, ParseOptions options, String pointer, int depth) {
        block36: {
            JSONObject.Builder builder;
            block37: {
                block34: {
                    if (depth > options.getMaximumNestingDepth()) {
                        throw new ParseException("Maximum nesting depth exceeded", null, 2, null);
                    }
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (!tm.match('{')) break block36;
                    builder = new JSONObject.Builder(0, null, 3, null);
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (tm.match('}')) break block37;
                    do {
                        block39: {
                            JSONValue value;
                            String key;
                            block38: {
                                String string;
                                if (tm.match('\"')) {
                                    string = this.parseString(tm, pointer);
                                } else if (options.getObjectKeyUnquoted() && this.matchIdentifier(tm)) {
                                    string = tm.getResult();
                                } else {
                                    throw new ParseException("Illegal key in JSON object", pointer);
                                }
                                key = string;
                                tm.skip(JSONFunctions::isSpaceCharacter);
                                if (!tm.match(':')) {
                                    throw new ParseException("Missing colon in JSON object", pointer);
                                }
                                value = this.parse(tm, options, pointer + '/' + key, depth + 1);
                                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                                if (!builder.containsKey(key)) break block38;
                                switch (WhenMappings.$EnumSwitchMapping$0[options.getObjectKeyDuplicate().ordinal()]) {
                                    case 1: {
                                        this.duplicateKeyError(key, pointer);
                                        throw new KotlinNothingValueException();
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 3: {
                                        builder.remove(key);
                                        builder.add(key, value);
                                        break;
                                    }
                                    case 4: {
                                        if (!Intrinsics.areEqual((Object)value, (Object)builder.get(key))) {
                                            this.duplicateKeyError(key, pointer);
                                            throw new KotlinNothingValueException();
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block39;
                            }
                            builder.add(key, value);
                        }
                        tm.skip(JSONFunctions::isSpaceCharacter);
                        if (!tm.match(',')) break block34;
                        tm.skip(JSONFunctions::isSpaceCharacter);
                    } while (!options.getObjectTrailingComma() || !tm.match('}'));
                    tm.revert();
                }
                if (!tm.match('}')) {
                    throw new ParseException("Missing closing brace in JSON object", pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('[')) {
            JSONArray.Builder builder = new JSONArray.Builder(0, null, 3, null);
            tm.skip(JSONFunctions::isSpaceCharacter);
            if (!tm.match(']')) {
                block35: {
                    do {
                        builder.add(this.parse(tm, options, pointer + '/' + builder.getSize(), depth + 1));
                        tm.skip(JSONFunctions::isSpaceCharacter);
                        if (!tm.match(',')) break block35;
                        tm.skip(JSONFunctions::isSpaceCharacter);
                    } while (!options.getArrayTrailingComma() || !tm.match(']'));
                    tm.revert();
                }
                if (!tm.match(']')) {
                    throw new ParseException("Missing closing bracket in JSON array", pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('\"')) {
            return new JSONString(this.parseString(tm, pointer));
        }
        if (tm.match((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (tm.match((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (tm.match((CharSequence)"null")) {
            return null;
        }
        int numberStart = tm.getIndex();
        boolean negative = tm.match('-');
        if (tm.matchDec()) {
            int integerLength = tm.getResultLength();
            if (integerLength > 1 && tm.getResultChar() == '0') {
                throw new ParseException("Illegal JSON number", pointer);
            }
            boolean floating = false;
            if (tm.match('.')) {
                floating = true;
                if (!tm.matchDec()) {
                    throw new ParseException("Illegal JSON number", pointer);
                }
            }
            if (tm.match(Parser::parse$lambda$0)) {
                floating = true;
                tm.match(Parser::parse$lambda$1);
                if (!tm.matchDec()) {
                    throw new ParseException("Illegal JSON number", pointer);
                }
            }
            if (!floating) {
                if (integerLength < 10) {
                    return JSONInt.Companion.of(tm.getResultInt(negative));
                }
                try {
                    long result = tm.getResultLong(negative);
                    if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
                        return JSONInt.Companion.of((int)result);
                    }
                    return JSONLong.Companion.of(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string = tm.getString(numberStart, tm.getIndex());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.getString(numberStart, tm.index)");
            String string2 = string;
            return JSONDecimal.Companion.of(new BigDecimal(string2));
        }
        throw new ParseException("Illegal JSON syntax", pointer);
    }

    private final String parseString(TextMatcher tm, String pointer) {
        String string;
        try {
            String string2 = JSONFunctions.parseString((TextMatcher)tm);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            JSONFuncti\u2026parseString(tm)\n        }");
            string = string2;
        }
        catch (IllegalArgumentException iae) {
            String string3 = iae.getMessage();
            if (string3 == null) {
                string3 = "Error parsing JSON string";
            }
            throw new ParseException(string3, pointer);
        }
        return string;
    }

    private final Void duplicateKeyError(String key, String pointer) {
        throw new ParseException("Duplicate key in JSON object \"" + key + '\"', pointer);
    }

    private final boolean matchIdentifier(TextMatcher $this$matchIdentifier) {
        return $this$matchIdentifier.match(Parser::matchIdentifier$lambda$2) && $this$matchIdentifier.matchContinue(Parser::matchIdentifier$lambda$3);
    }

    private static final boolean parse$lambda$0(char it) {
        return it == 'e' || it == 'E';
    }

    private static final boolean parse$lambda$1(char it) {
        return it == '-' || it == '+';
    }

    private static final boolean matchIdentifier$lambda$2(char it) {
        return ParserConstants.INSTANCE.getIdentifierStartSet().contains(Character.valueOf(it));
    }

    private static final boolean matchIdentifier$lambda$3(char it) {
        return ParserConstants.INSTANCE.getIdentifierContinuationSet().contains(Character.valueOf(it));
    }

    public static final /* synthetic */ JSONValue access$parse(Parser $this, TextMatcher tm, ParseOptions options, String pointer, int depth) {
        return $this.parse(tm, options, pointer, depth);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParseOptions.DuplicateKeyOption.values().length];
            try {
                nArray[ParseOptions.DuplicateKeyOption.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParseOptions.DuplicateKeyOption.TAKE_FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParseOptions.DuplicateKeyOption.TAKE_LAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParseOptions.DuplicateKeyOption.CHECK_IDENTICAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

