/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.ParseException;
import io.kjson.parser.ParseOptions;
import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/kjson/parser/Parser;", "", "()V", "BOM", "", "DUPLICATE_KEY", "", "EXCESS_CHARS", "ILLEGAL_KEY", "ILLEGAL_NUMBER", "ILLEGAL_SYNTAX", "MAX_INTEGER_DIGITS_LENGTH", "", "MISSING_CLOSING_BRACE", "MISSING_CLOSING_BRACKET", "MISSING_COLON", "defaultOptions", "Lio/kjson/parser/ParseOptions;", "rootPointer", "duplicateKeyError", "", "key", "pointer", "parse", "Lio/kjson/JSONValue;", "json", "options", "tm", "Lnet/pwall/text/TextMatcher;", "parseString", "matchIdentifier", "", "kjson-core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();
    @NotNull
    public static final String rootPointer = "";
    private static final int MAX_INTEGER_DIGITS_LENGTH = 10;
    private static final char BOM = '\ufeff';
    @NotNull
    public static final String EXCESS_CHARS = "Excess characters following JSON";
    @NotNull
    public static final String ILLEGAL_NUMBER = "Illegal JSON number";
    @NotNull
    public static final String ILLEGAL_SYNTAX = "Illegal JSON syntax";
    @NotNull
    public static final String ILLEGAL_KEY = "Illegal key in JSON object";
    @NotNull
    public static final String DUPLICATE_KEY = "Duplicate key in JSON object";
    @NotNull
    public static final String MISSING_COLON = "Missing colon in JSON object";
    @NotNull
    public static final String MISSING_CLOSING_BRACE = "Missing closing brace in JSON object";
    @NotNull
    public static final String MISSING_CLOSING_BRACKET = "Missing closing bracket in JSON array";
    @NotNull
    private static final ParseOptions defaultOptions = new ParseOptions(null, false, false, false, 15, null);

    private Parser() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String json, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(json);
        tm.match('\ufeff');
        JSONValue result = this.parse(tm, options, rootPointer);
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (!tm.isAtEnd()) {
            throw new ParseException(EXCESS_CHARS, null, 2, null);
        }
        return result;
    }

    public static /* synthetic */ JSONValue parse$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = defaultOptions;
        }
        return parser.parse(string, parseOptions);
    }

    private final JSONValue parse(TextMatcher tm, ParseOptions options, String pointer) {
        block35: {
            JSONObject.Builder builder;
            block36: {
                block33: {
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (!tm.match('{')) break block35;
                    builder = new JSONObject.Builder(0, null, 3, null);
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (tm.match('}')) break block36;
                    do {
                        block38: {
                            JSONValue value;
                            String key;
                            block37: {
                                String string;
                                if (tm.match('\"')) {
                                    string = this.parseString(tm, pointer);
                                } else if (options.getObjectKeyUnquoted() && this.matchIdentifier(tm)) {
                                    string = tm.getResult();
                                } else {
                                    throw new ParseException(ILLEGAL_KEY, pointer);
                                }
                                key = string;
                                tm.skip(JSONFunctions::isSpaceCharacter);
                                if (!tm.match(':')) {
                                    throw new ParseException(MISSING_COLON, pointer);
                                }
                                value = this.parse(tm, options, pointer + '/' + key);
                                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                                if (!builder.containsKey(key)) break block37;
                                switch (WhenMappings.$EnumSwitchMapping$0[options.getObjectKeyDuplicate().ordinal()]) {
                                    case 1: {
                                        this.duplicateKeyError(key, pointer);
                                        throw new KotlinNothingValueException();
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 3: {
                                        builder.remove(key);
                                        builder.add(key, value);
                                        break;
                                    }
                                    case 4: {
                                        if (!Intrinsics.areEqual((Object)value, (Object)builder.get(key))) {
                                            this.duplicateKeyError(key, pointer);
                                            throw new KotlinNothingValueException();
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block38;
                            }
                            builder.add(key, value);
                        }
                        tm.skip(JSONFunctions::isSpaceCharacter);
                        if (!tm.match(',')) break block33;
                        tm.skip(JSONFunctions::isSpaceCharacter);
                    } while (!options.getObjectTrailingComma() || !tm.match('}'));
                    tm.revert();
                }
                if (!tm.match('}')) {
                    throw new ParseException(MISSING_CLOSING_BRACE, pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('[')) {
            JSONArray.Builder builder = new JSONArray.Builder(0, null, 3, null);
            tm.skip(JSONFunctions::isSpaceCharacter);
            if (!tm.match(']')) {
                block34: {
                    do {
                        builder.add(this.parse(tm, options, pointer + '/' + builder.getSize()));
                        tm.skip(JSONFunctions::isSpaceCharacter);
                        if (!tm.match(',')) break block34;
                        tm.skip(JSONFunctions::isSpaceCharacter);
                    } while (!options.getArrayTrailingComma() || !tm.match(']'));
                    tm.revert();
                }
                if (!tm.match(']')) {
                    throw new ParseException(MISSING_CLOSING_BRACKET, pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('\"')) {
            return new JSONString(this.parseString(tm, pointer));
        }
        if (tm.match((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (tm.match((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (tm.match((CharSequence)"null")) {
            return null;
        }
        int numberStart = tm.getIndex();
        boolean negative = tm.match('-');
        if (tm.matchDec(0, 1)) {
            int integerLength = tm.getResultLength();
            if (integerLength > 1 && tm.getResultChar() == '0') {
                throw new ParseException(ILLEGAL_NUMBER, pointer);
            }
            boolean floating = false;
            if (tm.match('.')) {
                floating = true;
                if (!tm.matchDec(0, 1)) {
                    throw new ParseException(ILLEGAL_NUMBER, pointer);
                }
            }
            if (tm.match('e') || tm.match('E')) {
                floating = true;
                tm.matchAny("-+");
                if (!tm.matchDec(0, 1)) {
                    throw new ParseException(ILLEGAL_NUMBER, pointer);
                }
            }
            if (!floating) {
                if (integerLength < 10) {
                    return JSONInt.Companion.of(tm.getResultInt(negative));
                }
                try {
                    long result = tm.getResultLong(negative);
                    if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
                        return JSONInt.Companion.of((int)result);
                    }
                    return JSONLong.Companion.of(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return JSONDecimal.Companion.of(new BigDecimal(tm.getString(numberStart, tm.getIndex())));
        }
        throw new ParseException(ILLEGAL_SYNTAX, pointer);
    }

    private final String parseString(TextMatcher tm, String pointer) {
        String string;
        try {
            string = JSONFunctions.parseString((TextMatcher)tm);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            JSONFuncti\u2026parseString(tm)\n        }");
        }
        catch (IllegalArgumentException iae) {
            String string2 = iae.getMessage();
            if (string2 == null) {
                string2 = "Error parsing JSON string";
            }
            throw new ParseException(string2, pointer);
        }
        return string;
    }

    private final Void duplicateKeyError(String key, String pointer) {
        throw new ParseException("Duplicate key in JSON object \"" + key + '\"', pointer);
    }

    private final boolean matchIdentifier(TextMatcher $this$matchIdentifier) {
        int identifierStart = $this$matchIdentifier.getIndex();
        if (!$this$matchIdentifier.match(Parser::matchIdentifier$lambda-0)) {
            return false;
        }
        $this$matchIdentifier.skip(Parser::matchIdentifier$lambda-1);
        $this$matchIdentifier.setStart(identifierStart);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchIdentifier$lambda-0(int it) {
        boolean bl;
        boolean bl2;
        int n = 65;
        if (it <= 90) {
            if (n <= it) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        n = 97;
        if (it <= 122) {
            if (n <= it) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (it != 95) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchIdentifier$lambda-1(int it) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n = 65;
        if (it <= 90) {
            if (n <= it) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        n = 97;
        if (it <= 122) {
            if (n <= it) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        n = 48;
        if (it <= 57) {
            if (n <= it) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (it != 95) return false;
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParseOptions.DuplicateKeyOption.values().length];
            nArray[ParseOptions.DuplicateKeyOption.ERROR.ordinal()] = 1;
            nArray[ParseOptions.DuplicateKeyOption.TAKE_FIRST.ordinal()] = 2;
            nArray[ParseOptions.DuplicateKeyOption.TAKE_LAST.ordinal()] = 3;
            nArray[ParseOptions.DuplicateKeyOption.CHECK_IDENTICAL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

