/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.parser;

import io.jstuff.json.JSONFunctions;
import io.jstuff.text.TextMatcher;
import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONException;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.ParseException;
import io.kjson.parser.ParseOptions;
import io.kjson.parser.ParserConstants;
import io.kjson.util.BuilderException;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\u000eH\u0002\u00a8\u0006\u001a"}, d2={"Lio/kjson/parser/Parser;", "", "<init>", "()V", "parse", "Lio/kjson/JSONValue;", "json", "", "options", "Lio/kjson/parser/ParseOptions;", "parseLines", "Lio/kjson/JSONArray;", "jsonLines", "tm", "Lio/jstuff/text/TextMatcher;", "depth", "", "parseObject", "Lio/kjson/JSONObject;", "parseArray", "parseString", "parseNumber", "Lio/kjson/JSONNumber;", "skipExponent", "", "matchIdentifier", "kjson-core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String json, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(json);
        tm.match('\ufeff');
        JSONValue result = this.parse(tm, options, 0);
        options.getSkipSpaces().invoke((Object)tm);
        if (!tm.isAtEnd()) {
            throw new ParseException("Excess characters following JSON", null, 2, null);
        }
        return result;
    }

    public static /* synthetic */ JSONValue parse$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parse(string, parseOptions);
    }

    @NotNull
    public final JSONArray parseLines(@NotNull String jsonLines, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)jsonLines, (String)"jsonLines");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextMatcher tm = new TextMatcher(jsonLines);
        tm.match('\ufeff');
        return JSONArray.Companion.build((Function1<? super JSONArray.Builder, Unit>)((Function1)arg_0 -> Parser.parseLines$lambda$0(options, tm, arg_0)));
    }

    public static /* synthetic */ JSONArray parseLines$default(Parser parser, String string, ParseOptions parseOptions, int n, Object object) {
        if ((n & 2) != 0) {
            parseOptions = ParseOptions.Companion.getDEFAULT();
        }
        return parser.parseLines(string, parseOptions);
    }

    private final JSONValue parse(TextMatcher tm, ParseOptions options, int depth) {
        if (depth > options.getMaximumNestingDepth()) {
            throw new JSONException("Maximum nesting depth exceeded", null, 2, null);
        }
        options.getSkipSpaces().invoke((Object)tm);
        if (tm.match('{')) {
            return this.parseObject(tm, options, depth);
        }
        if (tm.match('[')) {
            return this.parseArray(tm, options, depth);
        }
        if (tm.match('\"')) {
            return JSONString.box-impl(JSONString.constructor-impl(this.parseString(tm)));
        }
        if (tm.match((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (tm.match((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (tm.match((CharSequence)"null")) {
            return null;
        }
        JSONNumber jSONNumber = this.parseNumber(tm);
        if (jSONNumber == null) {
            throw new ParseException("Illegal JSON syntax", null, 2, null);
        }
        return jSONNumber;
    }

    private final JSONObject parseObject(TextMatcher tm, ParseOptions options, int depth) {
        return JSONObject.Companion.build$default(JSONObject.Companion, 0, options.getObjectKeyDuplicate(), arg_0 -> Parser.parseObject$lambda$1(options, tm, depth, arg_0), 1, null);
    }

    private final JSONArray parseArray(TextMatcher tm, ParseOptions options, int depth) {
        return JSONArray.Companion.build((Function1<? super JSONArray.Builder, Unit>)((Function1)arg_0 -> Parser.parseArray$lambda$2(options, tm, depth, arg_0)));
    }

    private final String parseString(TextMatcher tm) {
        String string;
        try {
            string = JSONFunctions.parseString((TextMatcher)tm);
        }
        catch (IllegalArgumentException iae) {
            String string2 = iae.getMessage();
            if (string2 == null) {
                string2 = "Error parsing JSON string";
            }
            throw new ParseException(string2, null, 2, null);
        }
        return string;
    }

    private final JSONNumber parseNumber(TextMatcher tm) {
        int numberStart = tm.getIndex();
        boolean negative = tm.match('-');
        if (tm.matchDec()) {
            int integerLength = tm.getResultLength();
            if (integerLength > 1 && tm.getResultChar() == '0') {
                throw new ParseException("Illegal JSON number", null, 2, null);
            }
            if (tm.match('.')) {
                if (!tm.matchDec()) {
                    throw new ParseException("Illegal JSON number", null, 2, null);
                }
                this.skipExponent(tm);
            } else if (!this.skipExponent(tm)) {
                if (integerLength < 10) {
                    return JSONInt.Companion.of(tm.getResultInt(negative));
                }
                try {
                    long result = tm.getResultLong(negative);
                    return result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE ? (JSONNumber)JSONInt.Companion.of((int)result) : (JSONNumber)JSONLong.Companion.of(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string = tm.getString(numberStart, tm.getIndex());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string;
            return JSONDecimal.Companion.of(new BigDecimal(string2));
        }
        return null;
    }

    private final boolean skipExponent(TextMatcher tm) {
        boolean bl;
        if (tm.match(Parser::skipExponent$lambda$3)) {
            tm.match(Parser::skipExponent$lambda$4);
            if (!tm.matchDec()) {
                throw new ParseException("Illegal JSON number", null, 2, null);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean matchIdentifier(TextMatcher $this$matchIdentifier) {
        return $this$matchIdentifier.match(Parser::matchIdentifier$lambda$5) && $this$matchIdentifier.matchContinue(Parser::matchIdentifier$lambda$6);
    }

    private static final Unit parseLines$lambda$0(ParseOptions $options, TextMatcher $tm, JSONArray.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $options.getSkipSpaces().invoke((Object)$tm);
        int counter = 0;
        while (!$tm.isAtEnd()) {
            try {
                JSONValue value = INSTANCE.parse($tm, $options, 0);
                $this$build.add(value);
                ++counter;
                $options.getSkipSpaces().invoke((Object)$tm);
            }
            catch (ParseException pe) {
                throw pe.nested("" + '/' + counter);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit parseObject$lambda$1(ParseOptions $options, TextMatcher $tm, int $depth, JSONObject.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $options.getSkipSpaces().invoke((Object)$tm);
        if (!$tm.match('}')) {
            block13: {
                do {
                    String string;
                    if ($tm.match('\"')) {
                        string = INSTANCE.parseString($tm);
                    } else if ($options.getObjectKeyUnquoted() && INSTANCE.matchIdentifier($tm)) {
                        string = $tm.getResult();
                    } else {
                        throw new ParseException("Illegal key in JSON object", null, 2, null);
                    }
                    String key = string;
                    try {
                        $options.getSkipSpaces().invoke((Object)$tm);
                        if (!$tm.match(':')) {
                            throw new ParseException("Missing colon in JSON object", null, 2, null);
                        }
                        JSONValue value = INSTANCE.parse($tm, $options, $depth + 1);
                        try {
                            Intrinsics.checkNotNull((Object)key);
                            $this$build.add(key, value);
                        }
                        catch (BuilderException e) {
                            throw new ParseException(e.getText(), null, 2, null);
                        }
                        $options.getSkipSpaces().invoke((Object)$tm);
                        if ($tm.match(',')) {
                            $options.getSkipSpaces().invoke((Object)$tm);
                            continue;
                        }
                        break block13;
                    }
                    catch (ParseException pe) {
                        throw pe.nested('/' + key);
                    }
                } while (!$options.getObjectTrailingComma() || !$tm.match('}'));
                return Unit.INSTANCE;
            }
            if (!$tm.match('}')) {
                throw new ParseException("Missing closing brace in JSON object", null, 2, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit parseArray$lambda$2(ParseOptions $options, TextMatcher $tm, int $depth, JSONArray.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $options.getSkipSpaces().invoke((Object)$tm);
        if (!$tm.match(']')) {
            block6: {
                do {
                    try {
                        JSONValue value = INSTANCE.parse($tm, $options, $depth + 1);
                        $this$build.add(value);
                        $options.getSkipSpaces().invoke((Object)$tm);
                        if ($tm.match(',')) {
                            $options.getSkipSpaces().invoke((Object)$tm);
                            continue;
                        }
                        break block6;
                    }
                    catch (ParseException pe) {
                        throw pe.nested("" + '/' + $this$build.getSize());
                    }
                } while (!$options.getArrayTrailingComma() || !$tm.match(']'));
                return Unit.INSTANCE;
            }
            if (!$tm.match(']')) {
                throw new ParseException("Missing closing bracket in JSON array", null, 2, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean skipExponent$lambda$3(char it) {
        return it == 'e' || it == 'E';
    }

    private static final boolean skipExponent$lambda$4(char it) {
        return it == '-' || it == '+';
    }

    private static final boolean matchIdentifier$lambda$5(char it) {
        return ParserConstants.INSTANCE.getIdentifierStartSet().contains(Character.valueOf(it));
    }

    private static final boolean matchIdentifier$lambda$6(char it) {
        return ParserConstants.INSTANCE.getIdentifierContinuationSet().contains(Character.valueOf(it));
    }
}

