/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import io.karatelabs.debug.DapServer;
import java.time.Instant;

public class Main {
    public static void main(String[] args) {
        String ts = System.getProperty("KARATE_TS");
        if (ts == null || ts.isBlank()) {
            ts = System.getenv("KARATE_TS");
        }
        boolean failed = false;
        if (ts == null || ts.isBlank()) {
            failed = true;
        }
        if (!failed) {
            Instant now = Instant.now();
            Instant ideTime = Instant.parse(ts);
            System.out.println("KARATE_TS=" + ts + ", ide:" + ideTime + ", now:" + now);
            if (!ideTime.isBefore(now) || !now.isBefore(ideTime.plusSeconds(10L))) {
                failed = true;
            }
        }
        if (failed) {
            String message = "error: IDE debug requires paid upgrade of the Karate Labs plugin / extension";
            System.out.println(message);
            System.exit(1);
        } else {
            int port = 0;
            if (args.length > 0) {
                try {
                    port = Integer.parseInt(args[0]);
                }
                catch (Exception ideTime) {
                    // empty catch block
                }
            }
            DapServer server = new DapServer(port);
            server.waitSync();
        }
    }
}

