/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import io.karatelabs.debug.DapDecoder;
import io.karatelabs.debug.DapEncoder;
import io.karatelabs.debug.DapServerHandler;
import java.net.InetSocketAddress;
import karate.io.netty.bootstrap.ServerBootstrap;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.channel.nio.NioEventLoopGroup;
import karate.io.netty.channel.socket.nio.NioServerSocketChannel;
import karate.io.netty.handler.logging.LogLevel;
import karate.io.netty.handler.logging.LoggingHandler;

public class DapServer {
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Channel channel;
    private final int port;

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        System.out.println("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        System.out.println("stop: shutdown complete");
    }

    public DapServer(int requestedPort) {
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(this.getClass().getName(), LogLevel.TRACE))).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new DapDecoder());
                    p.addLast(new DapEncoder());
                    p.addLast(new DapServerHandler(DapServer.this));
                }
            });
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.port = isa.getPort();
            System.out.println("debug server started on port: " + this.port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

