/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import io.karatelabs.debug.DapMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.handler.codec.MessageToMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapEncoder
extends MessageToMessageEncoder<DapMessage> {
    private static final Logger logger = LoggerFactory.getLogger(DapEncoder.class);
    private static final byte[] CONTENT_LENGTH_COLON = "Content-Length: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CRLFCRLF = "\r\n\r\n".getBytes(StandardCharsets.UTF_8);

    @Override
    protected void encode(ChannelHandlerContext ctx, DapMessage dm, List<Object> out) throws Exception {
        String msg = dm.toJson();
        if (logger.isTraceEnabled()) {
            logger.trace("<< {}", (Object)msg);
        }
        ByteBuf buf = ctx.alloc().buffer();
        byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
        buf.writeBytes(CONTENT_LENGTH_COLON);
        buf.writeCharSequence("" + bytes.length, StandardCharsets.UTF_8);
        buf.writeBytes(CRLFCRLF);
        buf.writeBytes(bytes);
        out.add(buf);
    }
}

