/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk;

import akka.Done;
import akka.actor.ActorSystem;
import com.google.protobuf.Descriptors;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kalix.javasdk.KalixRunner;
import kalix.javasdk.action.ActionProvider;
import kalix.javasdk.eventsourcedentity.EventSourcedEntity;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityOptions;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityProvider;
import kalix.javasdk.impl.ActionFactory;
import kalix.javasdk.impl.AnySupport;
import kalix.javasdk.impl.EventSourcedEntityFactory;
import kalix.javasdk.impl.ReplicatedEntityFactory;
import kalix.javasdk.impl.Service;
import kalix.javasdk.impl.ValueEntityFactory;
import kalix.javasdk.impl.ViewFactory;
import kalix.javasdk.impl.action.ActionService;
import kalix.javasdk.impl.action.ResolvedActionFactory;
import kalix.javasdk.impl.eventsourcedentity.EventSourcedEntityService;
import kalix.javasdk.impl.eventsourcedentity.ResolvedEventSourcedEntityFactory;
import kalix.javasdk.impl.replicatedentity.ReplicatedEntityService;
import kalix.javasdk.impl.replicatedentity.ResolvedReplicatedEntityFactory;
import kalix.javasdk.impl.valueentity.ResolvedValueEntityFactory;
import kalix.javasdk.impl.valueentity.ValueEntityService;
import kalix.javasdk.impl.view.ViewService;
import kalix.javasdk.replicatedentity.ReplicatedEntity;
import kalix.javasdk.replicatedentity.ReplicatedEntityOptions;
import kalix.javasdk.replicatedentity.ReplicatedEntityProvider;
import kalix.javasdk.valueentity.ValueEntity;
import kalix.javasdk.valueentity.ValueEntityOptions;
import kalix.javasdk.valueentity.ValueEntityProvider;
import kalix.javasdk.view.ViewProvider;
import kalix.replicatedentity.ReplicatedData;

public final class Kalix {
    private final Map<String, Function<ActorSystem, Service>> services = new HashMap<String, Function<ActorSystem, Service>>();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private String typeUrlPrefix = AnySupport.DefaultTypeUrlPrefix();
    private AnySupport.Prefer prefer = AnySupport.PREFER_JAVA();
    private final LowLevelRegistration lowLevel = new LowLevelRegistration();

    public Kalix withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Kalix withTypeUrlPrefix(String string) {
        this.typeUrlPrefix = string;
        return this;
    }

    public Kalix preferJavaProtobufs() {
        this.prefer = AnySupport.PREFER_JAVA();
        return this;
    }

    public Kalix preferScalaProtobufs() {
        this.prefer = AnySupport.PREFER_SCALA();
        return this;
    }

    public <D extends ReplicatedData, E extends ReplicatedEntity<D>> Kalix register(ReplicatedEntityProvider<D, E> replicatedEntityProvider) {
        return this.lowLevel.registerReplicatedEntity(replicatedEntityProvider::newRouter, replicatedEntityProvider.serviceDescriptor(), replicatedEntityProvider.entityType(), replicatedEntityProvider.options(), replicatedEntityProvider.additionalDescriptors());
    }

    public <S, E extends ValueEntity<S>> Kalix register(ValueEntityProvider<S, E> valueEntityProvider) {
        return this.lowLevel.registerValueEntity(valueEntityProvider::newRouter, valueEntityProvider.serviceDescriptor(), valueEntityProvider.entityType(), valueEntityProvider.options(), valueEntityProvider.additionalDescriptors());
    }

    public <S, E extends EventSourcedEntity<S>> Kalix register(EventSourcedEntityProvider<S, E> eventSourcedEntityProvider) {
        return this.lowLevel.registerEventSourcedEntity(eventSourcedEntityProvider::newRouter, eventSourcedEntityProvider.serviceDescriptor(), eventSourcedEntityProvider.entityType(), eventSourcedEntityProvider.options(), eventSourcedEntityProvider.additionalDescriptors());
    }

    public Kalix register(ViewProvider viewProvider) {
        return this.lowLevel.registerView(viewProvider::newRouter, viewProvider.serviceDescriptor(), viewProvider.viewId(), viewProvider.additionalDescriptors());
    }

    public Kalix register(ActionProvider actionProvider) {
        return this.lowLevel.registerAction(actionProvider::newRouter, actionProvider.serviceDescriptor(), actionProvider.additionalDescriptors());
    }

    public CompletionStage<Done> start() {
        return this.createRunner().run();
    }

    public CompletionStage<Done> start(Config config) {
        return this.createRunner(config).run();
    }

    public KalixRunner createRunner() {
        return new KalixRunner(this.services);
    }

    public KalixRunner createRunner(Config config) {
        return new KalixRunner(this.services, config);
    }

    private AnySupport newAnySupport(Descriptors.FileDescriptor[] fileDescriptorArray) {
        return new AnySupport(fileDescriptorArray, this.classLoader, this.typeUrlPrefix, this.prefer);
    }

    private class LowLevelRegistration {
        private LowLevelRegistration() {
        }

        public Kalix registerEventSourcedEntity(EventSourcedEntityFactory eventSourcedEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, EventSourcedEntityOptions eventSourcedEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
            AnySupport anySupport = Kalix.this.newAnySupport(fileDescriptorArray);
            ResolvedEventSourcedEntityFactory resolvedEventSourcedEntityFactory = new ResolvedEventSourcedEntityFactory(eventSourcedEntityFactory, anySupport.resolveServiceDescriptor(serviceDescriptor));
            Kalix.this.services.put(serviceDescriptor.getFullName(), actorSystem -> new EventSourcedEntityService(resolvedEventSourcedEntityFactory, serviceDescriptor, fileDescriptorArray, anySupport, string, eventSourcedEntityOptions.snapshotEvery(), eventSourcedEntityOptions));
            return Kalix.this;
        }

        public Kalix registerAction(ActionFactory actionFactory, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.FileDescriptor ... fileDescriptorArray) {
            AnySupport anySupport = Kalix.this.newAnySupport(fileDescriptorArray);
            ResolvedActionFactory resolvedActionFactory = new ResolvedActionFactory(actionFactory, anySupport.resolveServiceDescriptor(serviceDescriptor));
            ActionService actionService = new ActionService(resolvedActionFactory, serviceDescriptor, fileDescriptorArray, anySupport);
            Kalix.this.services.put(serviceDescriptor.getFullName(), actorSystem -> actionService);
            return Kalix.this;
        }

        public Kalix registerValueEntity(ValueEntityFactory valueEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, ValueEntityOptions valueEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
            AnySupport anySupport = Kalix.this.newAnySupport(fileDescriptorArray);
            ResolvedValueEntityFactory resolvedValueEntityFactory = new ResolvedValueEntityFactory(valueEntityFactory, anySupport.resolveServiceDescriptor(serviceDescriptor));
            Kalix.this.services.put(serviceDescriptor.getFullName(), actorSystem -> new ValueEntityService(resolvedValueEntityFactory, serviceDescriptor, fileDescriptorArray, anySupport, string, valueEntityOptions));
            return Kalix.this;
        }

        public Kalix registerReplicatedEntity(ReplicatedEntityFactory replicatedEntityFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, ReplicatedEntityOptions replicatedEntityOptions, Descriptors.FileDescriptor ... fileDescriptorArray) {
            AnySupport anySupport = Kalix.this.newAnySupport(fileDescriptorArray);
            ResolvedReplicatedEntityFactory resolvedReplicatedEntityFactory = new ResolvedReplicatedEntityFactory(replicatedEntityFactory, anySupport.resolveServiceDescriptor(serviceDescriptor));
            Kalix.this.services.put(serviceDescriptor.getFullName(), actorSystem -> new ReplicatedEntityService(resolvedReplicatedEntityFactory, serviceDescriptor, fileDescriptorArray, anySupport, string, replicatedEntityOptions));
            return Kalix.this;
        }

        private Kalix registerView(ViewFactory viewFactory, Descriptors.ServiceDescriptor serviceDescriptor, String string, Descriptors.FileDescriptor ... fileDescriptorArray) {
            AnySupport anySupport = Kalix.this.newAnySupport(fileDescriptorArray);
            ViewService viewService = new ViewService(Optional.ofNullable(viewFactory), serviceDescriptor, fileDescriptorArray, anySupport, string);
            Kalix.this.services.put(serviceDescriptor.getFullName(), actorSystem -> viewService);
            return Kalix.this;
        }
    }
}

