/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kalix.javasdk.JsonSupport;

public interface JwtClaims {
    public Iterable<String> allClaimNames();

    public Map<String, String> asMap();

    default public boolean hasClaims() {
        return this.allClaimNames().iterator().hasNext();
    }

    default public Optional<String> issuer() {
        return this.getString("iss");
    }

    default public Optional<String> subject() {
        return this.getString("sub");
    }

    default public Optional<String> audience() {
        return this.getString("aud");
    }

    default public Optional<Instant> expirationTime() {
        return this.getNumericDate("exp");
    }

    default public Optional<Instant> notBefore() {
        return this.getNumericDate("nbf");
    }

    default public Optional<Instant> issuedAt() {
        return this.getNumericDate("iat");
    }

    default public Optional<String> jwtId() {
        return this.getString("jti");
    }

    public Optional<String> getString(String var1);

    default public Optional<Integer> getInteger(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<Long> getLong(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<Double> getDouble(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<Boolean> getBoolean(String string2) {
        return this.getString(string2).flatMap(string -> {
            if (string.equalsIgnoreCase("true")) {
                return Optional.of(Boolean.TRUE);
            }
            if (string.equalsIgnoreCase("false")) {
                return Optional.of(Boolean.FALSE);
            }
            return Optional.empty();
        });
    }

    default public Optional<Instant> getNumericDate(String string) {
        return this.getLong(string).map(Instant::ofEpochSecond);
    }

    default public Optional<JsonNode> getObject(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of(JsonSupport.getObjectMapper().readTree(string));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<String>> getStringList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, String.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<Integer>> getIntegerList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Integer.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<Long>> getLongList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Long.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<Double>> getDoubleList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Double.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<Boolean>> getBooleanList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Boolean.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }

    default public Optional<List<Instant>> getNumericDateList(String string) {
        return this.getLongList(string).map(list -> list.stream().map(Instant::ofEpochSecond).collect(Collectors.toList()));
    }

    default public Optional<List<JsonNode>> getObjectList(String string2) {
        return this.getString(string2).flatMap(string -> {
            try {
                return Optional.of((List)JsonSupport.getObjectMapper().readValue(string, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, JsonNode.class)));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return Optional.empty();
            }
        });
    }
}

