/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.util.Optional;
import kalix.javasdk.impl.ByteStringEncoding;

public final class JsonSupport {
    public static final String KALIX_JSON = "json.kalix.io/";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    private JsonSupport() {
    }

    public static <T> Any encodeJson(T t) {
        return JsonSupport.encodeJson(t, t.getClass().getName());
    }

    public static <T> Any encodeJson(T t, String string) {
        try {
            ByteString byteString = UnsafeByteOperations.unsafeWrap((byte[])objectMapper.writerFor(t.getClass()).writeValueAsBytes(t));
            ByteString byteString2 = ByteStringEncoding.encodePrimitiveBytes(byteString);
            return Any.newBuilder().setTypeUrl(KALIX_JSON + string).setValue(byteString2).build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Could not encode [" + t.getClass().getName() + "] as JSON", jsonProcessingException);
        }
    }

    public static <T> T decodeJson(Class<T> clazz, Any any) {
        if (!any.getTypeUrl().startsWith(KALIX_JSON)) {
            throw new IllegalArgumentException("Protobuf bytes with type url [" + any.getTypeUrl() + "] cannot be decoded as JSON, must start with [json.kalix.io/]");
        }
        try {
            ByteString byteString = ByteStringEncoding.decodePrimitiveBytes(any.getValue());
            return (T)objectMapper.readerFor(clazz).readValue(byteString.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("JSON with type url [" + any.getTypeUrl() + "] could not be decoded into a [" + clazz.getName() + "]", iOException);
        }
    }

    public static <T> Optional<T> decodeJson(Class<T> clazz, String string, Any any) {
        if (any.getTypeUrl().endsWith(string)) {
            return Optional.of(JsonSupport.decodeJson(clazz, any));
        }
        return Optional.empty();
    }

    static {
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES));
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
    }
}

