/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import kalix.javasdk.Kalix;
import kalix.javasdk.testkit.KalixTestKit;
import kalix.javasdk.testkit.junit.jupiter.KalixDescriptor;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;

class KalixTestKitExtension
implements BeforeAllCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KalixTestKitExtension.class});
    private static final String TESTKIT = "testkit";

    KalixTestKitExtension() {
    }

    public void beforeAll(ExtensionContext extensionContext) {
        Class clazz = extensionContext.getRequiredTestClass();
        Kalix kalix = KalixTestKitExtension.findKalixDescriptor(clazz);
        KalixTestKit kalixTestKit = new KalixTestKit(kalix).start();
        extensionContext.getStore(NAMESPACE).put((Object)TESTKIT, (Object)new StoredTestkit(kalixTestKit));
    }

    private static Kalix findKalixDescriptor(Class<?> clazz) {
        return ReflectionUtils.findFields(clazz, KalixTestKitExtension::isKalixDescriptor, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().findFirst().map(KalixTestKitExtension::getKalixDescriptor).orElseThrow(() -> new ExtensionConfigurationException("No field annotated with @KalixDescriptor found for @KalixTest"));
    }

    private static boolean isKalixDescriptor(Field field) {
        if (AnnotationSupport.isAnnotated((AnnotatedElement)field, KalixDescriptor.class)) {
            if (Kalix.class.isAssignableFrom(field.getType())) {
                return true;
            }
            throw new ExtensionConfigurationException(String.format("Field [%s] annotated with @KalixDescriptor is not a Kalix", field.getName()));
        }
        return false;
    }

    private static Kalix getKalixDescriptor(Field field) {
        return (Kalix)ReflectionUtils.tryToReadFieldValue((Field)field).getOrThrow(exception -> new ExtensionConfigurationException("Cannot access Kalix defined in field " + field.getName(), (Throwable)exception));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> clazz = parameterContext.getParameter().getType();
        return clazz == KalixTestKit.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> clazz = parameterContext.getParameter().getType();
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        KalixTestKit kalixTestKit = ((StoredTestkit)store.get((Object)TESTKIT, StoredTestkit.class)).getTestkit();
        if (clazz == KalixTestKit.class) {
            return kalixTestKit;
        }
        throw new ParameterResolutionException("Unexpected parameter type " + clazz);
    }

    private static class StoredTestkit
    implements ExtensionContext.Store.CloseableResource {
        private final KalixTestKit testkit;

        private StoredTestkit(KalixTestKit kalixTestKit) {
            this.testkit = kalixTestKit;
        }

        public KalixTestKit getTestkit() {
            return this.testkit;
        }

        public void close() {
            this.testkit.stop();
        }
    }
}

