/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit;

import kalix.javasdk.testkit.BuildInfo;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KalixProxyContainer
extends GenericContainer<KalixProxyContainer> {
    public static final String DEFAULT_PROXY_IMAGE = BuildInfo.proxyImage();
    public static final String DEFAULT_PROXY_VERSION = BuildInfo.proxyVersion();
    public static final DockerImageName DEFAULT_PROXY_IMAGE_NAME = DockerImageName.parse((String)DEFAULT_PROXY_IMAGE).withTag(DEFAULT_PROXY_VERSION);
    public static final int DEFAULT_PROXY_PORT = 9000;
    public static final int DEFAULT_USER_FUNCTION_PORT = 8080;
    public static final int DEFAULT_GOOGLE_PUBSUB_PORT = 8085;
    private final int userFunctionPort;
    private final int googlePubSubPort;

    public KalixProxyContainer() {
        this(8080);
    }

    public KalixProxyContainer(int n) {
        this(DEFAULT_PROXY_IMAGE_NAME, n, 8085);
    }

    public KalixProxyContainer(int n, int n2) {
        this(DEFAULT_PROXY_IMAGE_NAME, n, n2);
    }

    public KalixProxyContainer(DockerImageName dockerImageName, int n, int n2) {
        super(dockerImageName);
        this.userFunctionPort = n;
        this.googlePubSubPort = n2;
        this.withExposedPorts(new Integer[]{9000});
        this.withEnv("USER_FUNCTION_HOST", "host.testcontainers.internal");
        this.withEnv("USER_FUNCTION_PORT", String.valueOf(n));
        this.withEnv("HTTP_PORT", String.valueOf(9000));
        this.withEnv("EVENTING_SUPPORT", "google-pubsub-emulator");
        this.withEnv("PUBSUB_EMULATOR_HOST", "host.testcontainers.internal");
        this.withEnv("PUBSUB_EMULATOR_PORT", String.valueOf(n2));
        if ("false".equals(System.getenv("VERSION_CHECK_ON_STARTUP"))) {
            this.withEnv("VERSION_CHECK_ON_STARTUP", "false");
        }
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*gRPC proxy started.*", (int)1));
    }

    public void start() {
        Testcontainers.exposeHostPorts((int[])new int[]{this.userFunctionPort});
        Testcontainers.exposeHostPorts((int[])new int[]{this.googlePubSubPort});
        super.start();
    }

    public int getProxyPort() {
        return this.getMappedPort(9000);
    }
}

