/*
 * Decompiled with CFR 0.152.
 */
package kalix.codegen.java;

import java.io.Serializable;
import kalix.codegen.File$;
import kalix.codegen.Format$;
import kalix.codegen.GeneratedFiles;
import kalix.codegen.GeneratedFiles$;
import kalix.codegen.Imports;
import kalix.codegen.ModelBuilder;
import kalix.codegen.PackageNaming;
import kalix.codegen.SourceGeneratorUtils$;
import kalix.codegen.java.JavaGeneratorUtils$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class ValueEntityTestKitGenerator$ {
    public static ValueEntityTestKitGenerator$ MODULE$;

    static {
        new ValueEntityTestKitGenerator$();
    }

    public GeneratedFiles generate(ModelBuilder.ValueEntity entity, ModelBuilder.EntityService service) {
        PackageNaming pkg = entity.messageType().parent();
        String className = entity.messageType().name();
        return GeneratedFiles$.MODULE$.Empty().addManagedTest(File$.MODULE$.java(pkg, new StringBuilder(7).append(className).append("TestKit").toString(), this.generateSourceCode(service, entity, pkg.javaPackage()))).addUnmanagedTest(File$.MODULE$.java(pkg, new StringBuilder(4).append(className).append("Test").toString(), this.generateTestSources(service, entity, pkg.javaPackage())));
    }

    public String generateSourceCode(ModelBuilder.EntityService service, ModelBuilder.ValueEntity entity, String packageName) {
        Imports imports = SourceGeneratorUtils$.MODULE$.generateImports((Iterable)SourceGeneratorUtils$.MODULE$.allRelevantMessageTypes(service, (ModelBuilder.Entity)entity), packageName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.google.protobuf.Empty", "kalix.javasdk.Metadata", "java.util.Optional", "kalix.javasdk.valueentity.ValueEntity", "kalix.javasdk.impl.effect.SecondaryEffectImpl", "kalix.javasdk.impl.effect.MessageReplyImpl", "kalix.javasdk.impl.valueentity.ValueEntityEffectImpl", "kalix.javasdk.testkit.ValueEntityResult", "kalix.javasdk.testkit.impl.ValueEntityResultImpl", "kalix.javasdk.valueentity.ValueEntityContext", "kalix.javasdk.testkit.impl.TestKitValueEntityContext", "kalix.javasdk.testkit.impl.TestKitValueEntityCommandContext", "java.util.function.Function"})), SourceGeneratorUtils$.MODULE$.generateImports$default$4());
        String entityClassName = entity.messageType().name();
        String stateClassName = entity.state().messageType().fullName();
        String testkitClassName = new StringBuilder(7).append(entityClassName).append("TestKit").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1995).append("package ").append(entity.messageType().parent().javaPackage()).append(";\n       |\n       |").append(JavaGeneratorUtils$.MODULE$.writeImports(imports)).append("\n       |\n       |").append(SourceGeneratorUtils$.MODULE$.managedComment()).append("\n       |\n       |/**\n       | * TestKit for unit testing ").append(entityClassName).append("\n       | */\n       |public final class ").append(testkitClassName).append(" {\n       |\n       |  private ").append(stateClassName).append(" state;\n       |  private ").append(entityClassName).append(" entity;\n       |  private String entityId;\n       |\n       |  /**\n       |   * Create a testkit instance of ").append(entityClassName).append("\n       |   * @param entityFactory A function that creates a ").append(entityClassName).append(" based on the given ValueEntityContext,\n       |   *                      a default entity id is used.\n       |   */\n       |  public static ").append(testkitClassName).append(" of(Function<ValueEntityContext, ").append(entityClassName).append("> entityFactory) {\n       |    return of(\"testkit-entity-id\", entityFactory);\n       |  }\n       |\n       |  /**\n       |   * Create a testkit instance of ").append(entityClassName).append(" with a specific entity id.\n       |   */\n       |  public static ").append(testkitClassName).append(" of(String entityId, Function<ValueEntityContext, ").append(entityClassName).append("> entityFactory) {\n       |    return new ").append(testkitClassName).append("(entityFactory.apply(new TestKitValueEntityContext(entityId)), entityId);\n       |  }\n       |\n       |  /** Construction is done through the static ").append(testkitClassName).append(".of-methods */\n       |  private ").append(testkitClassName).append("(").append(entityClassName).append(" entity, String entityId) {\n       |    this.entityId = entityId;\n       |    this.state = entity.emptyState();\n       |    this.entity = entity;\n       |  }\n       |\n       |  private ").append(testkitClassName).append("(").append(entityClassName).append(" entity, String entityId, ").append(stateClassName).append(" state) {\n       |    this.entityId = entityId;\n       |    this.state = state;\n       |    this.entity = entity;\n       |  }\n       |\n       |  /**\n       |   * @return The current state of the ").append(entityClassName).append(" under test\n       |   */\n       |  public ").append(stateClassName).append(" getState() {\n       |    return state;\n       |  }\n       |\n       |  private <Reply> ValueEntityResult<Reply> interpretEffects(ValueEntity.Effect<Reply> effect) {\n       |    @SuppressWarnings(\"unchecked\")\n       |    ValueEntityResultImpl<Reply> result = new ValueEntityResultImpl<>(effect);\n       |    if (result.stateWasUpdated()) {\n       |      this.state = (").append(stateClassName).append(") result.getUpdatedState();\n       |    }\n       |    return result;\n       |  }\n       |\n       |  ").append(Format$.MODULE$.indent(this.generateServices(service), 2)).append("\n       |\n       |  ").append(Format$.MODULE$.indent(this.generateServicesDefault(service), 2)).append("\n       |}\n       |").toString())).stripMargin();
    }

    public String generateServices(ModelBuilder.EntityService service) {
        return ((TraversableOnce)service.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            String output = ValueEntityTestKitGenerator$.selectOutput$1(command);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(280).append("|public ValueEntityResult<").append(output).append("> ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(").append(command.inputType().fullName()).append(" ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.inputType().name())).append(", Metadata metadata) {\n       |  entity ._internalSetCommandContext(Optional.of(new TestKitValueEntityCommandContext(entityId, metadata)));\n       |  ValueEntity.Effect<").append(output).append("> effect = entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(state, ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.inputType().name())).append(");\n       |  return interpretEffects(effect);\n       |}").toString())).stripMargin();
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n\n");
    }

    public String generateServicesDefault(ModelBuilder.EntityService service) {
        return ((TraversableOnce)service.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            String output = ValueEntityTestKitGenerator$.selectOutput$2(command);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("|public ValueEntityResult<").append(output).append("> ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(").append(command.inputType().fullName()).append(" ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.inputType().name())).append(") {\n       |  entity ._internalSetCommandContext(Optional.of(new TestKitValueEntityCommandContext(entityId, Metadata.EMPTY)));\n       |  ValueEntity.Effect<").append(output).append("> effect = entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(state, ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.inputType().name())).append(");\n       |  return interpretEffects(effect);\n       |}").toString())).stripMargin();
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n\n");
    }

    public String generateTestSources(ModelBuilder.EntityService service, ModelBuilder.ValueEntity entity, String packageName) {
        Imports imports = SourceGeneratorUtils$.MODULE$.generateImports((Iterable)SourceGeneratorUtils$.MODULE$.allRelevantMessageTypes(service, (ModelBuilder.Entity)entity), packageName, (Seq)new .colon.colon((Object)"com.google.protobuf.Empty", (List)new .colon.colon((Object)"kalix.javasdk.valueentity.ValueEntity", (List)new .colon.colon((Object)"kalix.javasdk.testkit.ValueEntityResult", (List)new .colon.colon((Object)"org.junit.Ignore", (List)new .colon.colon((Object)"org.junit.Test", (List)Nil$.MODULE$))))), SourceGeneratorUtils$.MODULE$.generateImports$default$4());
        String entityClassName = entity.messageType().name();
        String testkitClassName = new StringBuilder(7).append(entityClassName).append("TestKit").toString();
        Iterable dummyTestCases = (Iterable)service.commands().map((Function1 & Serializable & scala.Serializable)command -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("|@Test\n          |@Ignore(\"to be implemented\")\n          |public void ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("Test() {\n          |  ").append(testkitClassName).append(" service = ").append(testkitClassName).append(".of(").append(entityClassName).append("::new);\n          |  // ").append(command.inputType().name()).append(" command = ").append(command.inputType().name()).append(".newBuilder()...build();\n          |  // ValueEntityResult<").append(command.outputType().name()).append("> result = service.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(command);\n          |}\n          |\n          |").toString())).stripMargin(), Iterable$.MODULE$.canBuildFrom());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(870).append("package ").append(entity.messageType().parent().javaPackage()).append(";\n       |\n       |").append(JavaGeneratorUtils$.MODULE$.writeImports(imports)).append("\n       |\n       |import static org.junit.Assert.*;\n       |\n       |").append(SourceGeneratorUtils$.MODULE$.unmanagedComment()).append("\n       |\n       |public class ").append(entityClassName).append("Test {\n       |\n       |  @Test\n       |  @Ignore(\"to be implemented\")\n       |  public void exampleTest() {\n       |    ").append(testkitClassName).append(" service = ").append(testkitClassName).append(".of(").append(entityClassName).append("::new);\n       |    // // use the testkit to execute a command\n       |    // // of events emitted, or a final updated state:\n       |    // SomeCommand command = SomeCommand.newBuilder()...build();\n       |    // ValueEntityResult<SomeResponse> result = service.someOperation(command);\n       |    // // verify the reply\n       |    // SomeReply reply = result.getReply();\n       |    // assertEquals(expectedReply, reply);\n       |    // // verify the final state after the command\n       |    // assertEquals(expectedState, service.getState());\n       |  }\n       |\n       |  ").append(Format$.MODULE$.indent(dummyTestCases, 2)).append("\n       |\n       |}\n       |").toString())).stripMargin();
    }

    private static final String selectOutput$1(ModelBuilder.Command command) {
        String string = command.outputType().name();
        String string2 = "Empty";
        return !(string != null ? !string.equals(string2) : string2 != null) ? "Empty" : command.outputType().fullName();
    }

    private static final String selectOutput$2(ModelBuilder.Command command) {
        String string = command.outputType().name();
        String string2 = "Empty";
        return !(string != null ? !string.equals(string2) : string2 != null) ? "Empty" : command.outputType().fullName();
    }

    private ValueEntityTestKitGenerator$() {
        MODULE$ = this;
    }
}

