/*
 * Decompiled with CFR 0.152.
 */
package kalix.codegen.java;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import kalix.codegen.DescriptorSet;
import kalix.codegen.DescriptorSet$;
import kalix.codegen.GeneratedFiles;
import kalix.codegen.GeneratedFiles$;
import kalix.codegen.Log;
import kalix.codegen.ModelBuilder;
import kalix.codegen.ModelBuilder$;
import kalix.codegen.PackageNaming;
import kalix.codegen.PackageNaming$;
import kalix.codegen.SourceGeneratorUtils$;
import kalix.codegen.java.ActionServiceSourceGenerator$;
import kalix.codegen.java.ActionTestKitGenerator$;
import kalix.codegen.java.ComponentsSourceGenerator$;
import kalix.codegen.java.EntityServiceSourceGenerator$;
import kalix.codegen.java.EventSourcedEntityTestKitGenerator$;
import kalix.codegen.java.MainSourceGenerator$;
import kalix.codegen.java.ProtoMessageTypeExtractor$;
import kalix.codegen.java.ValueEntityTestKitGenerator$;
import kalix.codegen.java.ViewServiceSourceGenerator$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SourceGenerator$ {
    public static SourceGenerator$ MODULE$;

    static {
        new SourceGenerator$();
    }

    public Iterable<Path> generate(ModelBuilder.Model model, Path sourceDirectory, Path testSourceDirectory, Path integrationTestSourceDirectory, Path generatedSourceDirectory, Path generatedTestSourceDirectory, String mainClass, Log log) {
        GeneratedFiles files = this.generateFiles(model, mainClass, log);
        return files.write(generatedSourceDirectory, sourceDirectory, generatedTestSourceDirectory, testSourceDirectory, integrationTestSourceDirectory);
    }

    public GeneratedFiles generateFiles(ModelBuilder.Model model, String mainClass, Log log) {
        Tuple2 tuple2 = SourceGeneratorUtils$.MODULE$.disassembleClassName(mainClass);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String mainClassPackageName = (String)tuple2._1();
        String mainClassName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mainClassPackageName, (Object)mainClassName);
        Tuple2 tuple23 = tuple22;
        String mainClassPackageName2 = (String)tuple23._1();
        String mainClassName2 = (String)tuple23._2();
        PackageNaming mainClassPackage = PackageNaming$.MODULE$.noDescriptor(mainClassPackageName2);
        GeneratedFiles componentSources = ComponentsSourceGenerator$.MODULE$.generate(mainClassPackage, (Map<String, ModelBuilder.Service>)model.services());
        GeneratedFiles mainSources = MainSourceGenerator$.MODULE$.generate(model, mainClassPackage, mainClassName2);
        return componentSources.$plus$plus(mainSources).$plus$plus((GeneratedFiles)((TraversableOnce)model.services().values().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GeneratedFiles generatedFiles;
            ModelBuilder.Service service = x0$1;
            if (service instanceof ModelBuilder.EntityService) {
                GeneratedFiles generatedFiles2;
                ModelBuilder.EntityService entityService = (ModelBuilder.EntityService)service;
                ModelBuilder.Entity entity = model.lookupEntity(entityService);
                GeneratedFiles generatedFiles3 = EntityServiceSourceGenerator$.MODULE$.generate(entity, entityService, mainClassPackageName2, mainClassName2);
                ModelBuilder.Entity entity2 = entity;
                if (entity2 instanceof ModelBuilder.EventSourcedEntity) {
                    ModelBuilder.EventSourcedEntity eventSourcedEntity = (ModelBuilder.EventSourcedEntity)entity2;
                    generatedFiles2 = EventSourcedEntityTestKitGenerator$.MODULE$.generate(eventSourcedEntity, entityService);
                } else if (entity2 instanceof ModelBuilder.ValueEntity) {
                    ModelBuilder.ValueEntity valueEntity = (ModelBuilder.ValueEntity)entity2;
                    generatedFiles2 = ValueEntityTestKitGenerator$.MODULE$.generate(valueEntity, entityService);
                } else if (entity2 instanceof ModelBuilder.ReplicatedEntity) {
                    generatedFiles2 = GeneratedFiles$.MODULE$.Empty();
                } else {
                    throw new MatchError((Object)entity2);
                }
                generatedFiles = generatedFiles3.$plus$plus(generatedFiles2);
            } else if (service instanceof ModelBuilder.ViewService) {
                ModelBuilder.ViewService viewService = (ModelBuilder.ViewService)service;
                generatedFiles = ViewServiceSourceGenerator$.MODULE$.generate(viewService);
            } else if (service instanceof ModelBuilder.ActionService) {
                ModelBuilder.ActionService actionService = (ModelBuilder.ActionService)service;
                generatedFiles = ActionServiceSourceGenerator$.MODULE$.generate(actionService, mainClassPackageName2).$plus$plus(ActionTestKitGenerator$.MODULE$.generate(actionService));
            } else {
                generatedFiles = GeneratedFiles$.MODULE$.Empty();
            }
            return generatedFiles;
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3)));
    }

    public Iterable<Path> generate(File protobufDescriptor, Path sourceDirectory, Path testSourceDirectory, Path integrationTestSourceDirectory, Path generatedSourceDirectory, Path generatedTestSourceDirectory, String mainClass, Log log) {
        Iterable iterable;
        Either either = DescriptorSet$.MODULE$.fileDescriptors(protobufDescriptor);
        if (either instanceof Right) {
            Iterable files;
            Right right = (Right)either;
            Either fileDescriptors = (Either)right.value();
            Either either2 = fileDescriptors;
            if (!(either2 instanceof Right)) {
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    DescriptorSet.ReadFailure failure = (DescriptorSet.ReadFailure)left.value();
                    throw new RuntimeException(new StringBuilder(68).append("There was a problem building the file descriptor from its protobuf: ").append(failure).toString());
                }
                throw new MatchError((Object)either2);
            }
            Right right2 = (Right)either2;
            iterable = files = (Iterable)right2.value();
        } else {
            if (either instanceof Left) {
                Left left = (Left)either;
                DescriptorSet.CannotOpen failure = (DescriptorSet.CannotOpen)left.value();
                throw new RuntimeException(new StringBuilder(57).append("There was a problem opening the protobuf descriptor file ").append(failure).toString(), failure.e());
            }
            throw new MatchError((Object)either);
        }
        Iterable iterable2 = iterable;
        Iterable descriptors = iterable2;
        ProtoMessageTypeExtractor$ e = ProtoMessageTypeExtractor$.MODULE$;
        return this.generate(ModelBuilder$.MODULE$.introspectProtobufClasses(descriptors, log, (ModelBuilder.ProtoMessageTypeExtractor)e), sourceDirectory, testSourceDirectory, integrationTestSourceDirectory, generatedSourceDirectory, generatedTestSourceDirectory, mainClass, log);
    }

    private SourceGenerator$() {
        MODULE$ = this;
    }
}

