/*
 * Decompiled with CFR 0.152.
 */
package kalix.codegen.java;

import java.io.Serializable;
import kalix.codegen.File$;
import kalix.codegen.Format$;
import kalix.codegen.GeneratedFiles;
import kalix.codegen.GeneratedFiles$;
import kalix.codegen.Imports;
import kalix.codegen.ModelBuilder;
import kalix.codegen.PackageNaming;
import kalix.codegen.SourceGeneratorUtils$;
import kalix.codegen.java.JavaGeneratorUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class EventSourcedEntityTestKitGenerator$ {
    public static EventSourcedEntityTestKitGenerator$ MODULE$;

    static {
        new EventSourcedEntityTestKitGenerator$();
    }

    public GeneratedFiles generate(ModelBuilder.EventSourcedEntity entity, ModelBuilder.EntityService service) {
        PackageNaming pkg = entity.messageType().parent();
        String className = entity.messageType().name();
        return GeneratedFiles$.MODULE$.Empty().addManagedTest(File$.MODULE$.java(pkg, new StringBuilder(7).append(className).append("TestKit").toString(), this.generateSourceCode(service, entity, pkg.javaPackage(), className))).addUnmanagedTest(File$.MODULE$.java(pkg, new StringBuilder(4).append(className).append("Test").toString(), this.generateTestSources(service, entity)));
    }

    public String generateSourceCode(ModelBuilder.EntityService service, ModelBuilder.EventSourcedEntity entity, String packageName, String className) {
        Imports imports = SourceGeneratorUtils$.MODULE$.generateImports((Iterable)SourceGeneratorUtils$.MODULE$.allRelevantMessageTypes(service, (ModelBuilder.Entity)entity), packageName, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.google.protobuf.Empty", "java.util.ArrayList", "java.util.List", "java.util.NoSuchElementException", "kalix.javasdk.Metadata", "kalix.javasdk.eventsourcedentity.EventSourcedEntity", "kalix.javasdk.eventsourcedentity.EventSourcedEntityContext", "kalix.javasdk.impl.effect.SecondaryEffectImpl", "kalix.javasdk.impl.effect.MessageReplyImpl", "kalix.javasdk.impl.eventsourcedentity.EventSourcedEntityEffectImpl", "kalix.javasdk.testkit.EventSourcedResult", "kalix.javasdk.testkit.impl.TestKitEventSourcedEntityContext", "kalix.javasdk.testkit.impl.EventSourcedResultImpl", "kalix.javasdk.testkit.impl.EventSourcedEntityEffectsRunner", "kalix.javasdk.testkit.impl.TestKitEventSourcedEntityCommandContext", "kalix.javasdk.testkit.impl.TestKitEventSourcedEntityEventContext", "java.util.function.Function", "java.util.Optional"})), SourceGeneratorUtils$.MODULE$.generateImports$default$4());
        String entityClassName = entity.messageType().name();
        String stateClassName = entity.state().messageType().fullName();
        String testkitClassName = new StringBuilder(7).append(entityClassName).append("TestKit").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1654).append("package ").append(entity.messageType().parent().javaPackage()).append(";\n          |\n          |").append(JavaGeneratorUtils$.MODULE$.writeImports(imports)).append("\n          |\n          |").append(SourceGeneratorUtils$.MODULE$.managedComment()).append("\n          |\n          |/**\n          | * TestKit for unit testing ").append(entityClassName).append("\n          | */\n          |public final class ").append(testkitClassName).append(" extends EventSourcedEntityEffectsRunner<").append(stateClassName).append("> {\n          |\n          |  /**\n          |   * Create a testkit instance of ").append(entityClassName).append("\n          |   * @param entityFactory A function that creates a ").append(entityClassName).append(" based on the given EventSourcedEntityContext,\n          |   *                      a default entity id is used.\n          |   */\n          |  public static ").append(testkitClassName).append(" of(Function<EventSourcedEntityContext, ").append(entityClassName).append("> entityFactory) {\n          |    return of(\"testkit-entity-id\", entityFactory);\n          |  }\n          |\n          |  /**\n          |   * Create a testkit instance of ").append(entityClassName).append(" with a specific entity id.\n          |   */\n          |  public static ").append(testkitClassName).append(" of(String entityId, Function<EventSourcedEntityContext, ").append(entityClassName).append("> entityFactory) {\n          |    return new ").append(testkitClassName).append("(entityFactory.apply(new TestKitEventSourcedEntityContext(entityId)));\n          |  }\n          |\n          |  private ").append(entityClassName).append(" entity;\n          |\n          |  /** Construction is done through the static ").append(testkitClassName).append(".of-methods */\n          |  private ").append(testkitClassName).append("(").append(entityClassName).append(" entity) {\n          |     super(entity);\n          |     this.entity = entity;\n          |  }\n          |\n          |  public ").append(stateClassName).append(" handleEvent(").append(stateClassName).append(" state, Object event) {\n          |    try {\n          |      entity._internalSetEventContext(Optional.of(new TestKitEventSourcedEntityEventContext()));\n          |      ").append(Format$.MODULE$.indent(this.generateHandleEvents((Iterable<ModelBuilder.Event>)entity.events()), 6)).append("\n          |    } finally {\n          |      entity._internalSetEventContext(Optional.empty());\n          |    }\n          |  }\n          |\n          |  ").append(Format$.MODULE$.indent(this.generateServices(service), 2)).append("\n          |\n          |  ").append(Format$.MODULE$.indent(this.generateServicesDefault(service), 2)).append("\n          |\n          |}\n          |").toString())).stripMargin();
    }

    public String generateServices(ModelBuilder.EntityService service) {
        Predef$.MODULE$.require(!service.commands().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "empty `commands` not allowed");
        return ((TraversableOnce)service.commands().map((Function1 & Serializable & scala.Serializable)command -> new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("|public EventSourcedResult<").append(EventSourcedEntityTestKitGenerator$.selectOutput$1(command)).append("> ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(").append(command.inputType().fullName()).append(" command, Metadata metadata) {\n            |  return interpretEffects(() -> entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(getState(), command), metadata);\n            |}\n            |").toString())).stripMargin()).append("\n").toString(), Iterable$.MODULE$.canBuildFrom())).mkString("");
    }

    public String generateServicesDefault(ModelBuilder.EntityService service) {
        Predef$.MODULE$.require(!service.commands().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "empty `commands` not allowed");
        return ((TraversableOnce)service.commands().map((Function1 & Serializable & scala.Serializable)command -> new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(162).append("|public EventSourcedResult<").append(EventSourcedEntityTestKitGenerator$.selectOutput$2(command)).append("> ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(").append(command.inputType().fullName()).append(" command) {\n            |  return interpretEffects(() -> entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(getState(), command), Metadata.EMPTY);\n            |}\n            |").toString())).stripMargin()).append("\n").toString(), Iterable$.MODULE$.canBuildFrom())).mkString("");
    }

    public String generateHandleEvents(Iterable<ModelBuilder.Event> events) {
        Predef$.MODULE$.require(events.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "empty `events` not allowed");
        String top = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("|if (event instanceof ").append(((ModelBuilder.Event)events.head()).messageType().fullName()).append(") {\n          |  return entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(((ModelBuilder.Event)events.head()).messageType().name())).append("(state, (").append(((ModelBuilder.Event)events.head()).messageType().fullName()).append(") event);\n          |").toString())).stripMargin();
        Iterable middle = (Iterable)((TraversableLike)events.tail()).map((Function1 & Serializable & scala.Serializable)event -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("|} else if (event instanceof ").append(event.messageType().fullName()).append(") {\n          |  return entity.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(event.messageType().name())).append("(state, (").append(event.messageType().fullName()).append(") event);").toString())).stripMargin(), Iterable$.MODULE$.canBuildFrom());
        String bottom = new StringOps(Predef$.MODULE$.augmentString("\n        |} else {\n        |  throw new NoSuchElementException(\"Unknown event type [\" + event.getClass() + \"]\");\n        |}")).stripMargin();
        return new StringBuilder(0).append(top).append(middle.mkString("\n")).append(bottom).toString();
    }

    public String generateTestSources(ModelBuilder.EntityService service, ModelBuilder.EventSourcedEntity entity) {
        String packageName = entity.messageType().parent().javaPackage();
        Imports imports = SourceGeneratorUtils$.MODULE$.generateImports((Iterable)SourceGeneratorUtils$.MODULE$.allRelevantMessageTypes(service, (ModelBuilder.Entity)entity), packageName, (Seq)new .colon.colon((Object)"com.google.protobuf.Empty", (List)new .colon.colon((Object)"kalix.javasdk.eventsourcedentity.EventSourcedEntity", (List)new .colon.colon((Object)"kalix.javasdk.eventsourcedentity.EventSourcedEntityContext", (List)new .colon.colon((Object)"kalix.javasdk.testkit.EventSourcedResult", (List)new .colon.colon((Object)"org.junit.Ignore", (List)new .colon.colon((Object)"org.junit.Test", (List)Nil$.MODULE$)))))), SourceGeneratorUtils$.MODULE$.generateImports$default$4());
        String entityClassName = entity.messageType().name();
        String testkitClassName = new StringBuilder(7).append(entityClassName).append("TestKit").toString();
        Iterable dummyTestCases = (Iterable)service.commands().map((Function1 & Serializable & scala.Serializable)command -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(268).append("|@Test\n          |@Ignore(\"to be implemented\")\n          |public void ").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("Test() {\n          |  ").append(testkitClassName).append(" service = ").append(testkitClassName).append(".of(").append(entityClassName).append("::new);\n          |  // ").append(command.inputType().name()).append(" command = ").append(command.inputType().name()).append(".newBuilder()...build();\n          |  // EventSourcedResult<").append(command.outputType().name()).append("> result = service.").append(SourceGeneratorUtils$.MODULE$.lowerFirst(command.name())).append("(command);\n          |}\n          |\n          |").toString())).stripMargin(), Iterable$.MODULE$.canBuildFrom());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1040).append("package ").append(packageName).append(";\n      |\n      |").append(JavaGeneratorUtils$.MODULE$.writeImports(imports)).append("\n      |\n      |import static org.junit.Assert.*;\n      |\n      |").append(SourceGeneratorUtils$.MODULE$.unmanagedComment()).append("\n      |\n      |public class ").append(entityClassName).append("Test {\n      |\n      |  @Test\n      |  @Ignore(\"to be implemented\")\n      |  public void exampleTest() {\n      |    ").append(testkitClassName).append(" service = ").append(testkitClassName).append(".of(").append(entityClassName).append("::new);\n      |    // // use the testkit to execute a command\n      |    // // of events emitted, or a final updated state:\n      |    // SomeCommand command = SomeCommand.newBuilder()...build();\n      |    // EventSourcedResult<SomeResponse> result = service.someOperation(command);\n      |    // // verify the emitted events\n      |    // ExpectedEvent actualEvent = result.getNextEventOfType(ExpectedEvent.class);\n      |    // assertEquals(expectedEvent, actualEvent);\n      |    // // verify the final state after applying the events\n      |    // assertEquals(expectedState, service.getState());\n      |    // // verify the reply\n      |    // SomeReply reply = result.getReply();\n      |    // assertEquals(expectedReply, reply);\n      |  }\n      |\n      |  ").append(Format$.MODULE$.indent(dummyTestCases, 2)).append("\n      |\n      |}\n      |").toString())).stripMargin();
    }

    private static final String selectOutput$1(ModelBuilder.Command command) {
        String string = command.outputType().name();
        String string2 = "Empty";
        return !(string != null ? !string.equals(string2) : string2 != null) ? "Empty" : command.outputType().fullName();
    }

    private static final String selectOutput$2(ModelBuilder.Command command) {
        String string = command.outputType().name();
        String string2 = "Empty";
        return !(string != null ? !string.equals(string2) : string2 != null) ? "Empty" : command.outputType().fullName();
    }

    private EventSourcedEntityTestKitGenerator$() {
        MODULE$ = this;
    }
}

