/*
 * Decompiled with CFR 0.152.
 */
package io.justcount;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.justcount.Operation;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.threeten.bp.Duration;

public class PubSubClient {
    private Publisher publisher;
    private Gson gson = new Gson();

    public PubSubClient(String keyFilename) throws IOException {
        this(new Options(keyFilename));
    }

    public PubSubClient(Options options) throws IOException {
        FileReader keyFileReader = new FileReader(options.keyFilename);
        Map retMap = (Map)this.gson.fromJson((Reader)keyFileReader, new TypeToken<HashMap<String, Object>>(){}.getType());
        String project = (String)retMap.get("project_id");
        ProjectTopicName topicName = ProjectTopicName.of((String)project, (String)options.topic);
        Publisher.Builder builder = Publisher.newBuilder((TopicName)topicName);
        final GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(options.keyFilename)).createScoped((Collection)Lists.newArrayList((Object[])new String[]{"https://www.googleapis.com/auth/cloud-platform"}));
        builder.setCredentialsProvider(new CredentialsProvider(){

            public Credentials getCredentials() throws IOException {
                return credentials;
            }
        });
        BatchingSettings.Builder batchingSettingsBuilder = BatchingSettings.newBuilder();
        batchingSettingsBuilder.setIsEnabled(Boolean.valueOf(true));
        if (options.batching.delayThresholdMilliseconds > 0L) {
            batchingSettingsBuilder.setDelayThreshold(Duration.ofMillis((long)options.batching.delayThresholdMilliseconds));
        }
        if (options.batching.elementCountThreshold > 0L) {
            batchingSettingsBuilder.setElementCountThreshold(options.batching.elementCountThreshold);
        }
        if (options.batching.requestByteThreshold > 0L) {
            batchingSettingsBuilder.setRequestByteThreshold(options.batching.requestByteThreshold).build();
        }
        builder.setBatchingSettings(batchingSettingsBuilder.build());
        this.publisher = builder.build();
    }

    public ApiFuture<Void> send(Collection<Operation> operations) {
        ApiFuture messageIdFuture;
        final SettableApiFuture result = SettableApiFuture.create();
        String json = this.gson.toJson((Object)new Operation.Bulk(operations));
        PubsubMessage message = PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)json)).build();
        try {
            messageIdFuture = this.publisher.publish(message);
        }
        catch (IllegalStateException ex) {
            result.setException((Throwable)ex);
            return result;
        }
        ApiFutures.addCallback((ApiFuture)messageIdFuture, (ApiFutureCallback)new ApiFutureCallback<String>(){

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }

            public void onSuccess(String s) {
                result.set(null);
            }
        });
        return result;
    }

    public void close() throws Exception {
        this.publisher.shutdown();
    }

    public static class Options {
        public String keyFilename;
        public String topic = "justcount";
        public Batching batching = new Batching();

        public Options(String keyFilename) {
            this.keyFilename = keyFilename;
        }

        public static class Batching {
            public Long delayThresholdMilliseconds = 0L;
            public Long elementCountThreshold = 0L;
            public Long requestByteThreshold = 0L;
        }
    }
}

