/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.StringMatcher;
import java.util.Objects;

public class WildcardMatcher
implements StringMatcher {
    public static final char defaultSingleMatchChar = '?';
    public static final char defaultMultiMatchChar = '*';
    private final String pattern;
    private final char singleMatchChar;
    private final char multiMatchChar;
    private final int patternLength;

    public WildcardMatcher(String pattern, char singleMatchChar, char multiMatchChar) {
        this.pattern = Objects.requireNonNull(pattern, "Pattern must not be null");
        this.singleMatchChar = singleMatchChar;
        this.multiMatchChar = multiMatchChar;
        this.patternLength = pattern.length();
    }

    public WildcardMatcher(String pattern) {
        this(pattern, '?', '*');
    }

    @Override
    public boolean matches(CharSequence target) {
        Objects.requireNonNull(target, "Target must not be null");
        return this.matches(target, 0, target.length(), 0);
    }

    private boolean matches(CharSequence target, int targetStart, int targetEnd, int patternStart) {
        int targetIndex = targetStart;
        int patternIndex = patternStart;
        while (patternIndex < this.patternLength) {
            char patternChar;
            if ((patternChar = this.pattern.charAt(patternIndex++)) == this.singleMatchChar) {
                char targetChar;
                if (targetIndex >= targetEnd) {
                    return false;
                }
                if (!Character.isHighSurrogate(targetChar = target.charAt(targetIndex++)) || targetIndex >= targetEnd || !Character.isLowSurrogate(target.charAt(targetIndex))) continue;
                ++targetIndex;
                continue;
            }
            if (patternChar == this.multiMatchChar) {
                if (patternIndex == this.patternLength) {
                    return true;
                }
                do {
                    if (targetIndex < targetEnd) continue;
                    return false;
                } while (!this.matches(target, targetIndex++, targetEnd, patternIndex));
                return true;
            }
            if (targetIndex < targetEnd && target.charAt(targetIndex++) == patternChar) continue;
            return false;
        }
        return targetIndex == targetEnd;
    }
}

