/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.BasicFormatter;
import io.jstuff.log.Level;
import io.jstuff.log.LogAppender;
import io.jstuff.log.LogFormatter;
import io.jstuff.log.Logger;
import io.jstuff.log.LoggerException;
import java.io.PrintStream;
import java.time.Instant;
import java.util.function.IntConsumer;

public class PrintStreamAppender<F extends LogFormatter>
implements LogAppender<F>,
IntConsumer {
    public static final PrintStream defaultOutput = System.out;
    private final PrintStream stream;
    private final F formatter;

    public PrintStreamAppender(PrintStream stream, F formatter) {
        this.stream = stream;
        this.formatter = formatter;
    }

    public PrintStreamAppender(F formatter) {
        this(defaultOutput, formatter);
    }

    @Override
    public F getFormatter() {
        return this.formatter;
    }

    @Override
    public synchronized void output(Instant time, Logger logger, Level level, Object message, Throwable throwable) {
        this.formatter.format(time, logger, level, message, throwable, this);
    }

    @Override
    public void accept(int ch) {
        if (ch == 10) {
            this.stream.println();
            if (this.stream.checkError()) {
                throw new LoggerException("Error writing PrintStreamAppender");
            }
        } else {
            this.stream.print((char)ch);
        }
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public static PrintStreamAppender<BasicFormatter> getBasic(PrintStream stream) {
        return new PrintStreamAppender<BasicFormatter>(stream, new BasicFormatter());
    }

    public static PrintStreamAppender<BasicFormatter> getBasic() {
        return new PrintStreamAppender<BasicFormatter>(defaultOutput, new BasicFormatter());
    }
}

