/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogListener;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaLogger
extends AbstractLogger {
    private final Logger javaLogger;

    JavaLogger(String name, Level level, Clock clock) {
        super(name, level, clock);
        this.javaLogger = Logger.getLogger(name);
        this.javaLogger.setLevel(JavaLogger.convertLevel(level));
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.javaLogger.setLevel(JavaLogger.convertLevel(level));
    }

    public boolean isTraceEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.FINER);
    }

    public boolean isDebugEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.SEVERE);
    }

    public boolean isEnabled(Level level) {
        return this.javaLogger.isLoggable(JavaLogger.convertLevel(level));
    }

    @Override
    protected void outputLog(Instant time, Level level, Object message, Throwable throwable) {
        if (LogListener.present()) {
            LogListener.invokeAll(time, this, level, message, throwable);
        }
        StackTraceElement sourceDetails = LoggerFactory.callerInfo();
        java.util.logging.Level julLevel = JavaLogger.convertLevel(level);
        long millis = time.toEpochMilli();
        JavaLogger.outputMultiLine(String.valueOf(message), s -> this.outputLogRecord(julLevel, (String)s, millis, sourceDetails, throwable));
    }

    private void outputLogRecord(java.util.logging.Level julLevel, String message, long millis, StackTraceElement callerInfo, Throwable throwable) {
        LogRecord logRecord = new LogRecord(julLevel, message);
        logRecord.setMillis(millis);
        logRecord.setSourceClassName(callerInfo.getClassName());
        logRecord.setSourceMethodName(callerInfo.getMethodName());
        logRecord.setThrown(throwable);
        this.javaLogger.log(logRecord);
    }

    private static java.util.logging.Level convertLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
        }
        return java.util.logging.Level.SEVERE;
    }
}

