/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLoggerFactory;
import io.jstuff.log.ConsoleLogger;
import io.jstuff.log.Level;
import java.io.PrintStream;
import java.time.Clock;
import java.util.Objects;

public class ConsoleLoggerFactory
extends AbstractLoggerFactory<ConsoleLogger> {
    private static final ConsoleLoggerFactory instance = new ConsoleLoggerFactory();
    private PrintStream output;

    public ConsoleLoggerFactory(Level defaultLevel, Clock defaultClock, PrintStream output) {
        super(defaultLevel, defaultClock);
        this.setOutput(output);
    }

    public ConsoleLoggerFactory(Level defaultLevel, PrintStream output) {
        this(defaultLevel, systemClock, output);
    }

    public ConsoleLoggerFactory(PrintStream output) {
        this(systemDefaultLevel, systemClock, output);
    }

    public ConsoleLoggerFactory(Level defaultLevel) {
        this(defaultLevel, systemClock, ConsoleLogger.defaultOutput);
    }

    public ConsoleLoggerFactory() {
        this(systemDefaultLevel, systemClock, ConsoleLogger.defaultOutput);
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setOutput(PrintStream output) {
        this.output = Objects.requireNonNull(output);
    }

    @Override
    protected ConsoleLogger createLogger(String name, Level level, Clock clock) {
        return new ConsoleLogger(name, level, clock, this.output);
    }

    public static ConsoleLoggerFactory getInstance() {
        return instance;
    }
}

