/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.DynamicLoggerFactory;
import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;

public class Log {
    public static final String defaultLoggerFactoryPropertyName = "net.pwall.log.defaultLoggerFactory";
    public static final String defaultLevelPropertyName = "net.pwall.log.defaultLevel";
    private static LoggerFactory<?> defaultLoggerFactory = null;

    public static synchronized LoggerFactory<?> getDefaultLoggerFactory() {
        if (defaultLoggerFactory == null) {
            String defaultLoggerFactoryProperty;
            String defaultLevelProperty = System.getProperty(defaultLevelPropertyName);
            Level level = Level.INFO;
            Exception levelException = null;
            if (defaultLevelProperty != null) {
                try {
                    level = Level.valueOf((String)defaultLevelProperty);
                }
                catch (Exception e) {
                    levelException = e;
                }
            }
            if ((defaultLoggerFactoryProperty = System.getProperty(defaultLoggerFactoryPropertyName)) != null) {
                try {
                    defaultLoggerFactory = (LoggerFactory)Class.forName(defaultLoggerFactoryProperty).newInstance();
                }
                catch (Exception e) {
                    defaultLoggerFactory = new DynamicLoggerFactory(level);
                    Logger logger = defaultLoggerFactory.getLogger(Log.class);
                    logger.error((Throwable)e, (Object)("Unable to instantiate LoggerFactory - " + defaultLoggerFactoryProperty));
                }
            } else {
                defaultLoggerFactory = new DynamicLoggerFactory(level);
            }
            if (levelException != null) {
                Logger logger = defaultLoggerFactory.getLogger(Log.class);
                logger.error((Throwable)levelException, (Object)("Invalid default Level - " + defaultLevelProperty));
            }
        }
        return defaultLoggerFactory;
    }

    public static void setDefaultLoggerFactory(LoggerFactory<?> loggerFactory) {
        defaultLoggerFactory = loggerFactory;
    }

    public static Logger getLogger() {
        return Log.getDefaultLoggerFactory().getLogger();
    }

    public static Logger getLogger(Level level) {
        return Log.getDefaultLoggerFactory().getLogger(level);
    }

    public static Logger getLogger(Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(clock);
    }

    public static Logger getLogger(Level level, Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(level, clock);
    }

    public static Logger getLogger(String name) {
        return Log.getDefaultLoggerFactory().getLogger(name);
    }

    public static Logger getLogger(String name, Level level) {
        return Log.getDefaultLoggerFactory().getLogger(name, level);
    }

    public static Logger getLogger(String name, Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(name, clock);
    }

    public static Logger getLogger(String name, Level level, Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(name, level, clock);
    }

    public static Logger getLogger(Class<?> javaClass) {
        return Log.getDefaultLoggerFactory().getLogger(javaClass);
    }

    public static Logger getLogger(Class<?> javaClass, Level level) {
        return Log.getDefaultLoggerFactory().getLogger(javaClass, level);
    }

    public static Logger getLogger(Class<?> javaClass, Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(javaClass, clock);
    }

    public static Logger getLogger(Class<?> javaClass, Level level, Clock clock) {
        return Log.getDefaultLoggerFactory().getLogger(javaClass, level, clock);
    }
}

