/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.LogFormatter;
import io.jstuff.util.IntOutput;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.IntConsumer;

public abstract class AbstractFormatter
implements LogFormatter {
    public static final int ANSI_FG_MAGENTA = 35;
    public static final int ANSI_FG_BLUE = 34;
    public static final int ANSI_FG_GREEN = 32;
    public static final int ANSI_FG_YELLOW = 33;
    public static final int ANSI_FG_RED = 31;
    private static final int[] colourCodes = new int[]{35, 34, 32, 33, 31};

    public static void outputTime(int dayMillis, IntConsumer outFunction) {
        int totalSeconds = dayMillis / 1000;
        int millis = dayMillis - totalSeconds * 1000;
        int totalMinutes = totalSeconds / 60;
        int seconds = totalSeconds - totalMinutes * 60;
        int hours = totalMinutes / 60;
        int minutes = totalMinutes - hours * 60;
        IntOutput.output2Digits((int)hours, (IntConsumer)outFunction);
        outFunction.accept(58);
        IntOutput.output2Digits((int)minutes, (IntConsumer)outFunction);
        outFunction.accept(58);
        IntOutput.output2Digits((int)seconds, (IntConsumer)outFunction);
        outFunction.accept(46);
        IntOutput.output3Digits((int)millis, (IntConsumer)outFunction);
    }

    public static void outputLevel(Level level, IntConsumer outFunction) {
        AbstractFormatter.outputText(level.name(), outFunction);
    }

    public static void outputLevelColoured(Level level, IntConsumer outFunction) {
        AbstractFormatter.outputANSIColour(colourCodes[level.ordinal()], outFunction);
        AbstractFormatter.outputText(level.name(), outFunction);
        AbstractFormatter.outputANSIColour(0, outFunction);
    }

    public static void outputLevel5(Level level, IntConsumer outFunction) {
        AbstractFormatter.outputText(level.name(), outFunction);
        if (level == Level.INFO || level == Level.WARN) {
            outFunction.accept(32);
        }
    }

    public static void outputLevel5Coloured(Level level, IntConsumer outFunction) {
        AbstractFormatter.outputANSIColour(colourCodes[level.ordinal()], outFunction);
        AbstractFormatter.outputText(level.name(), outFunction);
        if (level == Level.INFO || level == Level.WARN) {
            outFunction.accept(32);
        }
        AbstractFormatter.outputANSIColour(0, outFunction);
    }

    public static void outputText(CharSequence text, IntConsumer outFunction) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            outFunction.accept(text.charAt(i));
        }
    }

    public static void outputNameWithLimit(int limit, String name, IntConsumer outFunction) {
        int n = name.length();
        if (n <= limit) {
            AbstractFormatter.outputText(name, outFunction);
        } else {
            outFunction.accept(46);
            outFunction.accept(46);
            outFunction.accept(46);
            for (int i = n - limit + 3; i < n; ++i) {
                outFunction.accept(name.charAt(i));
            }
        }
    }

    public static void outputANSIColour(int code, IntConsumer outFunction) {
        outFunction.accept(27);
        outFunction.accept(91);
        if (code > 0) {
            IntOutput.outputPositiveInt((int)code, (IntConsumer)outFunction);
        }
        outFunction.accept(109);
    }

    public static int getDayMillis(long millis, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(millis);
        ZoneOffset offset = zoneId.getRules().getOffset(instant);
        int daySeconds = (int)((instant.getEpochSecond() + (long)offset.getTotalSeconds()) % 86400L);
        return daySeconds * 1000 + (int)(millis % 1000L);
    }
}

