/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.json.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JSONValidation {
    public static Map<String, Predicate<String>> validations = new HashMap<String, Predicate<String>>();
    private static final int[] monthLengths;
    private static final int uuidDash1 = 8;
    private static final int uuidDash2 = 13;
    private static final int uuidDash3 = 18;
    private static final int uuidDash4 = 23;
    private static final int uuidLength = 36;
    private static final String emailSpecialChars = "!#$%&'*+/=?^_`{|}~-";
    private static final String uriTemplateIllegalChars = "\"%'<>\\^`|}";

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int monthLength(int year, int month) {
        try {
            return month == 2 && JSONValidation.isLeapYear(year) ? 29 : monthLengths[month - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Month value incorrect - " + month);
        }
    }

    public static boolean isDateTime(CharSequence string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 19) {
            return false;
        }
        if (!JSONValidation.checkDate(string)) {
            return false;
        }
        char ch = string.charAt(10);
        if (ch != 'T' && ch != 't') {
            return false;
        }
        return JSONValidation.checkTime(string, 11);
    }

    public static boolean isLocalDateTime(CharSequence string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n < 19) {
            return false;
        }
        if (!JSONValidation.checkDate(string)) {
            return false;
        }
        char ch = string.charAt(10);
        if (ch != 'T' && ch != 't') {
            return false;
        }
        return JSONValidation.checkLocalTime(string, 11) == n;
    }

    public static boolean isDate(CharSequence string) {
        if (string == null) {
            return false;
        }
        if (string.length() != 10) {
            return false;
        }
        return JSONValidation.checkDate(string);
    }

    public static boolean isTime(CharSequence string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.checkTime(string, 0);
    }

    public static boolean isLocalTime(CharSequence string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.checkLocalTime(string, 0) == string.length();
    }

    private static boolean checkDate(CharSequence string) {
        char ch;
        int i = 0;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        int year = (ch - 48) * 1000;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        year += (ch - 48) * 100;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        year += (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        year += ch - 48;
        if (string.charAt(i++) != '-') {
            return false;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        int month = (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        month += ch - 48;
        if (string.charAt(i++) != '-') {
            return false;
        }
        if (month == 0 || month > 12) {
            return false;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        int day = (ch - 48) * 10;
        ch = string.charAt(i);
        if (!JSONValidation.isDigit(ch)) {
            return false;
        }
        return (day += ch - 48) > 0 && day <= JSONValidation.monthLength(year, month);
    }

    private static int checkLocalTime(CharSequence string, int start) {
        char ch;
        int n = string.length();
        if (start + 8 > n) {
            return -1;
        }
        int i = start;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        int hour = (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        if ((hour += ch - 48) > 23) {
            return -1;
        }
        if (string.charAt(i++) != ':') {
            return -1;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        int minute = (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        if ((minute += ch - 48) > 59) {
            return -1;
        }
        if (string.charAt(i++) != ':') {
            return -1;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        int second = (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        if ((second += ch - 48) > 59 && (minute != 59 || second != 60)) {
            return -1;
        }
        if (i >= n) {
            return i;
        }
        if ((ch = string.charAt(i++)) != '.') {
            return i - 1;
        }
        if (i >= n) {
            return -1;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return -1;
        }
        do {
            if (i < n) continue;
            return i;
        } while (JSONValidation.isDigit(ch = string.charAt(i++)));
        return i - 1;
    }

    private static boolean checkTime(CharSequence string, int start) {
        char ch;
        int n = string.length();
        int i = JSONValidation.checkLocalTime(string, start);
        if (i < 0 || i >= n) {
            return false;
        }
        if ((ch = string.charAt(i++)) == 'Z' || ch == 'z') {
            return i == n;
        }
        if (ch != '+' && ch != '-') {
            return false;
        }
        if (i + 5 != n) {
            return false;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        int hour = (ch - 48) * 10;
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        if ((hour += ch - 48) > 23) {
            return false;
        }
        if (string.charAt(i++) != ':') {
            return false;
        }
        if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
            return false;
        }
        int minute = (ch - 48) * 10;
        ch = string.charAt(i);
        if (!JSONValidation.isDigit(ch)) {
            return false;
        }
        return (minute += ch - 48) <= 59;
    }

    public static boolean isDuration(CharSequence string) {
        char ch;
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int i = 0;
        if (string.charAt(i++) != 'P') {
            return false;
        }
        int previous = 0;
        while (true) {
            if (i == n) {
                return previous != 0;
            }
            if ((ch = string.charAt(i++)) == 'T') break;
            if (!JSONValidation.isDigit(ch)) {
                return false;
            }
            do {
                if (i != n) continue;
                return false;
            } while (JSONValidation.isDigit(ch = string.charAt(i++)));
            if (previous == 0 && ch == 'W') {
                return i == n;
            }
            if (previous == 0 && ch != 'Y' && ch != 'M' && ch != 'D' || previous == 89 && ch != 'M' || previous == 77 && ch != 'D') {
                return false;
            }
            previous = ch;
        }
        previous = 0;
        while (i != n) {
            if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
                return false;
            }
            do {
                if (i != n) continue;
                return false;
            } while (JSONValidation.isDigit(ch = string.charAt(i++)));
            if (previous == 0 && ch != 'H' && ch != 'M' && ch != 'S' || previous == 72 && ch != 'M' || previous == 77 && ch != 'S') {
                return false;
            }
            previous = ch;
        }
        return previous != 0;
    }

    public static boolean isURI(CharSequence string) {
        if (string == null) {
            return false;
        }
        try {
            URI uri = new URI(string.toString());
            if (uri.getScheme() == null) {
                return false;
            }
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isURIReference(CharSequence string) {
        if (string == null) {
            return false;
        }
        URI baseURI = URI.create("http://pwall.net/schema/schema.json");
        try {
            baseURI.resolve(string.toString());
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isURITemplate(CharSequence string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int i = 0;
        while (i < n) {
            char ch;
            if ((ch = string.charAt(i++)) == '%') {
                if (i + 2 > n || !JSONValidation.isHexDigit(string.charAt(i)) || !JSONValidation.isHexDigit(string.charAt(i + 1))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (ch == '{') {
                if (i >= n) {
                    return false;
                }
                if ((ch = string.charAt(i++)) == '+' || ch == '#' || ch == '.' || ch == '/' || ch == ';' || ch == '?' || ch == '&') {
                    if (i >= n) {
                        return false;
                    }
                    ch = string.charAt(i++);
                }
                while (true) {
                    int varStart = i;
                    while (true) {
                        if (ch == '%') {
                            if (i + 2 > n || !JSONValidation.isHexDigit(string.charAt(i)) || !JSONValidation.isHexDigit(string.charAt(i + 1))) {
                                return false;
                            }
                            i += 2;
                        } else if (!JSONValidation.isValidURITemplateVariableChar(ch)) break;
                        if (i >= n) {
                            return false;
                        }
                        ch = string.charAt(i++);
                    }
                    if (i == varStart) {
                        return false;
                    }
                    if (ch == '.') {
                        if (i >= n) {
                            return false;
                        }
                        ch = string.charAt(i++);
                        continue;
                    }
                    boolean starSeen = false;
                    if (ch == '*') {
                        if (i >= n) {
                            return false;
                        }
                        ch = string.charAt(i++);
                        starSeen = true;
                    }
                    if (ch == ':') {
                        if (i >= n) {
                            return false;
                        }
                        ch = string.charAt(i++);
                        int numberStart = i;
                        while (JSONValidation.isDigit(ch)) {
                            if (i >= n) {
                                return false;
                            }
                            ch = string.charAt(i++);
                        }
                        if (i == numberStart) {
                            return false;
                        }
                    }
                    if (!starSeen && ch == '*') {
                        if (i >= n) {
                            return false;
                        }
                        ch = string.charAt(i++);
                    }
                    if (ch != ',') break;
                    if (i >= n) {
                        return false;
                    }
                    ch = string.charAt(i++);
                }
                if (ch == '}') continue;
                return false;
            }
            if (JSONValidation.isValidURITemplateTextChar(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUUID(CharSequence string) {
        if (string == null || string.length() != 36) {
            return false;
        }
        int i = 0;
        do {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        } while (i < 8);
        if (string.charAt(i++) != '-') {
            return false;
        }
        do {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        } while (i < 13);
        if (string.charAt(i++) != '-') {
            return false;
        }
        do {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        } while (i < 18);
        if (string.charAt(i++) != '-') {
            return false;
        }
        do {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        } while (i < 23);
        if (string.charAt(i++) != '-') {
            return false;
        }
        do {
            if (JSONValidation.isHexDigit(string.charAt(i++))) continue;
            return false;
        } while (i < 36);
        return true;
    }

    public static boolean isHostname(CharSequence string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.isHostname(string, 0);
    }

    private static boolean isHostname(CharSequence string, int i) {
        boolean nextMayBeDashOrDot = false;
        int n = string.length();
        while (i < n) {
            char ch = string.charAt(i++);
            if (nextMayBeDashOrDot) {
                if (ch == '-' || ch == '.') {
                    nextMayBeDashOrDot = false;
                    continue;
                }
                if (JSONValidation.isLetterOrDigit(ch)) continue;
                return false;
            }
            if (!JSONValidation.isLetterOrDigit(ch)) {
                return false;
            }
            nextMayBeDashOrDot = true;
        }
        return nextMayBeDashOrDot;
    }

    public static boolean isEmail(CharSequence string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char ch = string.charAt(0);
        int i = 0;
        if (ch == '\"') {
            block17: {
                while (true) {
                    if (++i >= n) {
                        return false;
                    }
                    ch = string.charAt(i);
                    if (ch == '\"') break block17;
                    if (ch == '\\') {
                        if (++i >= n) {
                            return false;
                        }
                        ch = string.charAt(i);
                        if (JSONValidation.inRange(ch, 1, 9) || ch == '\u000b' || ch == '\f' || JSONValidation.inRange(ch, 14, 127)) continue;
                        return false;
                    }
                    if (!(JSONValidation.inRange(ch, 1, 8) || ch == '\u000b' || ch == '\f' || JSONValidation.inRange(ch, 14, 31) || ch == '!' || JSONValidation.inRange(ch, 35, 91) || JSONValidation.inRange(ch, 93, 127))) break;
                }
                return false;
            }
            if (++i >= n || string.charAt(i) != '@') {
                return false;
            }
        } else {
            boolean nextMayBeDot = false;
            do {
                if (nextMayBeDot) {
                    if (ch == '.') {
                        nextMayBeDot = false;
                    } else if (!JSONValidation.isEmailNameChar(ch)) {
                        return false;
                    }
                } else {
                    if (!JSONValidation.isEmailNameChar(ch)) {
                        return false;
                    }
                    nextMayBeDot = true;
                }
                if (++i < n) continue;
                return false;
            } while ((ch = string.charAt(i)) != '@');
            if (!nextMayBeDot) {
                return false;
            }
        }
        return JSONValidation.isHostname(string, i + 1);
    }

    public static boolean isIPV4(CharSequence string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.isIPV4(string, 0);
    }

    private static boolean isIPV4(CharSequence string, int i) {
        int n;
        block6: {
            n = string.length();
            int j = 0;
            do {
                char ch;
                if (i >= n) {
                    return false;
                }
                if (!JSONValidation.isDigit(ch = string.charAt(i++))) {
                    return false;
                }
                int k = 1;
                int m = ch - 48;
                while (i < n && JSONValidation.isDigit(ch = string.charAt(i))) {
                    if (m == 0) {
                        return false;
                    }
                    ++i;
                    if ((m = m * 10 + ch - 48) > 255) {
                        return false;
                    }
                    if (++k != 3) continue;
                }
                if (++j == 4) break block6;
            } while (i < n && string.charAt(i++) == '.');
            return false;
        }
        return i == n;
    }

    public static boolean isIPV6(CharSequence string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int i = 0;
        int j = 0;
        boolean doubleColonSeen = false;
        if (string.charAt(0) == ':') {
            if (string.charAt(1) != ':') {
                return false;
            }
            if (n == 2) {
                return true;
            }
            doubleColonSeen = true;
            i = 2;
            j = 1;
        }
        while (true) {
            int k = 0;
            while (i < n && JSONValidation.isHexDigit(string.charAt(i))) {
                ++i;
                if (++k != 4) continue;
            }
            if (k == 0) {
                return false;
            }
            if (++j == 8) break;
            if (i >= n) {
                return doubleColonSeen;
            }
            char ch = string.charAt(i);
            if (ch != ':') {
                if ((j == 7 || j < 7 && doubleColonSeen) && ch == '.') {
                    while (string.charAt(--i) != ':') {
                    }
                    return JSONValidation.isIPV4(string, i + 1);
                }
                return false;
            }
            if (doubleColonSeen || ++i >= n || string.charAt(i) != ':') continue;
            if (++i == n) {
                return true;
            }
            doubleColonSeen = true;
            ++j;
        }
        return i == n;
    }

    public static boolean isJSONPointer(CharSequence string) {
        if (string == null) {
            return false;
        }
        return JSONValidation.isJSONPointer(string, 0);
    }

    private static boolean isJSONPointer(CharSequence string, int i) {
        int n = string.length();
        if (i >= n) {
            return true;
        }
        if (string.charAt(i++) != '/') {
            return false;
        }
        while (i < n) {
            if (string.charAt(i++) != '~' || i < n && JSONValidation.inRange(string.charAt(i++), 48, 49)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRelativeJSONPointer(CharSequence string) {
        char ch;
        if (string == null) {
            return false;
        }
        int i = 0;
        int n = string.length();
        if (i == n) {
            return false;
        }
        if ((ch = string.charAt(i++)) == '0') {
            if (i >= n) {
                return true;
            }
            ch = string.charAt(i++);
        } else {
            if (!JSONValidation.isDigit(ch)) {
                return false;
            }
            do {
                if (i < n) continue;
                return true;
            } while (JSONValidation.isDigit(ch = string.charAt(i++)));
        }
        if (ch == '+' || ch == '-') {
            if (i >= n) {
                return false;
            }
            if ((ch = string.charAt(i++)) == '0') {
                if (i >= n) {
                    return true;
                }
                ch = string.charAt(i++);
            } else {
                if (!JSONValidation.isDigit(ch)) {
                    return false;
                }
                do {
                    if (i < n) continue;
                    return true;
                } while (JSONValidation.isDigit(ch = string.charAt(i++)));
            }
        }
        return ch == '#' && i == n || JSONValidation.isJSONPointer(string, i - 1);
    }

    public static boolean isRegex(CharSequence string) {
        if (string == null) {
            return false;
        }
        try {
            Pattern.compile(string.toString());
        }
        catch (PatternSyntaxException ignore) {
            return false;
        }
        return true;
    }

    private static boolean inRange(char ch, int lo, int hi) {
        return ch >= lo && ch <= hi;
    }

    private static boolean isLetterOrDigit(char ch) {
        return JSONValidation.inRange(ch, 97, 122) || JSONValidation.inRange(ch, 65, 90) || JSONValidation.isDigit(ch);
    }

    private static boolean isHexDigit(char ch) {
        return JSONValidation.isDigit(ch) || JSONValidation.inRange(ch, 97, 102) || JSONValidation.inRange(ch, 65, 70);
    }

    private static boolean isDigit(char ch) {
        return JSONValidation.inRange(ch, 48, 57);
    }

    private static boolean isEmailNameChar(char ch) {
        return JSONValidation.isLetterOrDigit(ch) || emailSpecialChars.indexOf(ch) >= 0;
    }

    private static boolean isValidURITemplateTextChar(char ch) {
        return !JSONValidation.inRange(ch, 0, 32) && uriTemplateIllegalChars.indexOf(ch) < 0 && !JSONValidation.inRange(ch, 127, 191);
    }

    private static boolean isValidURITemplateVariableChar(char ch) {
        return JSONValidation.isLetterOrDigit(ch) || ch == '_';
    }

    static {
        validations.put("date-time", JSONValidation::isDateTime);
        validations.put("date", JSONValidation::isDate);
        validations.put("time", JSONValidation::isTime);
        validations.put("duration", JSONValidation::isDuration);
        validations.put("uri", JSONValidation::isURI);
        validations.put("uri-reference", JSONValidation::isURIReference);
        validations.put("uri-template", JSONValidation::isURITemplate);
        validations.put("uuid", JSONValidation::isUUID);
        validations.put("hostname", JSONValidation::isHostname);
        validations.put("email", JSONValidation::isEmail);
        validations.put("ipv4", JSONValidation::isIPV4);
        validations.put("ipv6", JSONValidation::isIPV6);
        validations.put("json-pointer", JSONValidation::isJSONPointer);
        validations.put("relative-json-pointer", JSONValidation::isRelativeJSONPointer);
        validations.put("regex", JSONValidation::isRegex);
        monthLengths = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

