/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.xml.stream;

import io.jenetics.xml.stream.AutoCloseableXMLStreamReader;
import io.jenetics.xml.stream.AutoCloseableXMLStreamWriter;
import io.jenetics.xml.stream.IndentingXMLWriter;
import io.jenetics.xml.stream.XMLReaderProxy;
import io.jenetics.xml.stream.XMLWriterProxy;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

public final class XML {
    private XML() {
    }

    public static AutoCloseableXMLStreamReader reader(InputStream input) throws XMLStreamException {
        Objects.requireNonNull(input);
        XMLInputFactory factory = XMLInputFactory.newFactory();
        return new XMLReaderProxy(factory.createXMLStreamReader(input, "UTF-8"));
    }

    public static AutoCloseableXMLStreamWriter writer(OutputStream output, String indent) throws XMLStreamException {
        Objects.requireNonNull(output);
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        return indent != null ? new IndentingXMLWriter(factory.createXMLStreamWriter(output, "UTF-8"), indent) : new XMLWriterProxy(factory.createXMLStreamWriter(output, "UTF-8"));
    }

    public static AutoCloseableXMLStreamWriter writer(OutputStream output) throws XMLStreamException {
        return XML.writer(output, null);
    }
}

