/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.xml.stream;

import io.jenetics.xml.stream.Reader;
import io.jenetics.xml.stream.ReaderResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ElemReader<T>
extends Reader<T> {
    private final Function<Object[], T> _creator;
    private final List<Reader<?>> _children;
    private final Map<String, Integer> _readerIndexMapping = new HashMap<String, Integer>();
    private final int[] _attrReaderIndexes;
    private final int[] _textReaderIndex;

    ElemReader(String name, Function<Object[], T> creator, List<Reader<?>> children, Reader.Type type) {
        super(name, type);
        this._creator = Objects.requireNonNull(creator);
        this._children = Objects.requireNonNull(children);
        for (int i2 = 0; i2 < this._children.size(); ++i2) {
            this._readerIndexMapping.put(this._children.get(i2).name(), i2);
        }
        this._attrReaderIndexes = IntStream.range(0, this._children.size()).filter(i -> this._children.get(i).type() == Reader.Type.ATTR).toArray();
        this._textReaderIndex = IntStream.range(0, this._children.size()).filter(i -> this._children.get(i).type() == Reader.Type.TEXT).toArray();
        if (this._textReaderIndex.length > 1) {
            throw new IllegalArgumentException("Found more than one TEXT reader.");
        }
    }

    @Override
    public T read(XMLStreamReader xml) throws XMLStreamException {
        xml.require(1, null, this.name());
        List results = this._children.stream().map(ReaderResult::of).collect(Collectors.toList());
        ReaderResult text = this._textReaderIndex.length == 1 ? (ReaderResult)results.get(this._textReaderIndex[0]) : null;
        for (int i : this._attrReaderIndexes) {
            ReaderResult result = (ReaderResult)results.get(i);
            result.put(result.reader().read(xml));
        }
        if (xml.hasNext()) {
            xml.next();
            boolean hasNext = false;
            do {
                switch (xml.getEventType()) {
                    case 1: {
                        ReaderResult result = (ReaderResult)results.get(this._readerIndexMapping.get(xml.getLocalName()));
                        if (result == null) break;
                        result.put(result.reader().read(xml));
                        if (xml.hasNext()) {
                            hasNext = true;
                            xml.next();
                            break;
                        }
                        hasNext = false;
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (text != null) {
                            text.put(text.reader().read(xml));
                        } else {
                            xml.next();
                        }
                        hasNext = true;
                        break;
                    }
                    case 2: {
                        if (!this.name().equals(xml.getLocalName())) break;
                        try {
                            return this._creator.apply(results.stream().map(ReaderResult::value).toArray());
                        }
                        catch (RuntimeException e) {
                            throw new XMLStreamException(e);
                        }
                    }
                }
            } while (hasNext);
        }
        throw new XMLStreamException(String.format("Premature end of file while reading '%s'.", this.name()));
    }
}

