/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.xml.stream;

import io.jenetics.xml.stream.AttrReader;
import io.jenetics.xml.stream.ElemReader;
import io.jenetics.xml.stream.ListReader;
import io.jenetics.xml.stream.TextReader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class Reader<T> {
    private final String _name;
    private final Type _type;

    Reader(String name, Type type) {
        this._name = Objects.requireNonNull(name);
        this._type = Objects.requireNonNull(type);
    }

    public abstract T read(XMLStreamReader var1) throws XMLStreamException;

    public <B> Reader<B> map(final Function<? super T, ? extends B> mapper) {
        Objects.requireNonNull(mapper);
        return new Reader<B>(this._name, this._type){

            @Override
            public B read(XMLStreamReader xml) throws XMLStreamException {
                try {
                    return mapper.apply(Reader.this.read(xml));
                }
                catch (RuntimeException e) {
                    throw new XMLStreamException(e);
                }
            }
        };
    }

    String name() {
        return this._name;
    }

    Type type() {
        return this._type;
    }

    public String toString() {
        return String.format("Reader[%s, %s]", new Object[]{this.name(), this.type()});
    }

    public static Reader<String> attr(String name) {
        return new AttrReader(name);
    }

    public static Reader<String> text() {
        return new TextReader();
    }

    public static <T> Reader<T> elem(Function<Object[], T> generator, String name, Reader<?> ... children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(generator);
        Stream.of((Object[])Objects.requireNonNull(children)).forEach(Objects::requireNonNull);
        return new ElemReader<T>(name, generator, Arrays.asList(children), Type.ELEM);
    }

    public static <T> Reader<T> elem(String name, Reader<? extends T> reader) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(reader);
        return Reader.elem(v -> {
            Object value = ((Object[])v).length > 0 ? v[0] : null;
            return value;
        }, name, reader);
    }

    public static <T> Reader<List<T>> elems(Reader<? extends T> reader) {
        return new ListReader<T>(reader);
    }

    static enum Type {
        ELEM,
        ATTR,
        LIST,
        TEXT;

    }
}

