/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.xml.stream;

import io.jenetics.xml.stream.XMLWriterProxy;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class IndentingXMLWriter
extends XMLWriterProxy {
    private static final String NEW_LINE = System.lineSeparator();
    private final String _indent;
    private State _state;
    private final Deque<State> _states = new LinkedList<State>();
    private int _depth;

    IndentingXMLWriter(XMLStreamWriter writer, String indent) {
        super(writer);
        this._state = State.SEEN_NOTHING;
        this._indent = indent;
        this._depth = 0;
    }

    private void onStartElement() throws XMLStreamException {
        this._states.push(State.SEEN_ELEMENT);
        this._state = State.SEEN_NOTHING;
        if (this._depth > 0) {
            super.writeCharacters(NEW_LINE);
        }
        this.doIndent();
        ++this._depth;
    }

    private void onEndElement() throws XMLStreamException {
        --this._depth;
        if (this._state == State.SEEN_ELEMENT) {
            super.writeCharacters(NEW_LINE);
            this.doIndent();
        }
        this._state = this._states.pop();
    }

    private void onEmptyElement() throws XMLStreamException {
        this._state = State.SEEN_ELEMENT;
        if (this._depth > 0) {
            super.writeCharacters(NEW_LINE);
        }
        this.doIndent();
    }

    private void doIndent() throws XMLStreamException {
        if (this._depth > 0) {
            for (int i = 0; i < this._depth; ++i) {
                super.writeCharacters(this._indent);
            }
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        super.writeCharacters(NEW_LINE);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        super.writeStartDocument(version);
        super.writeCharacters(NEW_LINE);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        super.writeCharacters(NEW_LINE);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this._state = State.SEEN_DATA;
        super.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this._state = State.SEEN_DATA;
        super.writeCharacters(text, start, len);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this._state = State.SEEN_DATA;
        super.writeCData(data);
    }

    private static enum State {
        SEEN_NOTHING,
        SEEN_ELEMENT,
        SEEN_DATA;

    }
}

