/*
 * Decompiled with CFR 0.152.
 */
package org.jenetics.xml.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jenetics.xml.stream.AutoCloseableXMLStreamReader;
import org.jenetics.xml.stream.AutoCloseableXMLStreamWriter;
import org.jenetics.xml.stream.IndentingXMLWriter;
import org.jenetics.xml.stream.XMLReaderProxy;
import org.jenetics.xml.stream.XMLWriterProxy;

public final class XML {
    private XML() {
    }

    public static AutoCloseableXMLStreamReader reader(InputStream input) throws XMLStreamException {
        Objects.requireNonNull(input);
        XMLInputFactory factory = XMLInputFactory.newFactory();
        return new XMLReaderProxy(factory.createXMLStreamReader(input));
    }

    public static AutoCloseableXMLStreamWriter writer(OutputStream output, String indent) throws XMLStreamException {
        Objects.requireNonNull(output);
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        return indent != null ? new IndentingXMLWriter(factory.createXMLStreamWriter(output), indent) : new XMLWriterProxy(factory.createXMLStreamWriter(output));
    }

    public static AutoCloseableXMLStreamWriter writer(OutputStream output) throws XMLStreamException {
        return XML.writer(output, null);
    }
}

