/*
 * Decompiled with CFR 0.152.
 */
package org.jenetics.xml.stream;

import java.util.Objects;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@FunctionalInterface
public interface Writer<T> {
    public void write(XMLStreamWriter var1, T var2) throws XMLStreamException;

    default public <B> Writer<B> map(Function<? super B, ? extends T> mapper) {
        return (xml, data) -> {
            Object value;
            if (data != null && (value = mapper.apply((Object)data)) != null) {
                this.write(xml, value);
            }
        };
    }

    public static <T> Writer<T> attr(String name) {
        Objects.requireNonNull(name);
        return (xml, data) -> {
            if (data != null) {
                xml.writeAttribute(name, data.toString());
            }
        };
    }

    public static <T> Writer<T> attr(String name, Object value) {
        return Writer.attr(name).map(data -> value);
    }

    @SafeVarargs
    public static <T> Writer<T> elem(String name, Writer<? super T> ... children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(children);
        return (xml, data) -> {
            if (data != null) {
                xml.writeStartElement(name);
                for (Writer child : children) {
                    child.write(xml, data);
                }
                xml.writeEndElement();
            }
        };
    }

    public static <T> Writer<T> text() {
        return (xml, data) -> {
            if (data != null) {
                xml.writeCharacters(data.toString());
            }
        };
    }

    public static <T> Writer<Iterable<T>> elems(String name, Writer<? super T> writer) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(writer);
        return (xml, data) -> {
            if (data != null) {
                for (Object value : data) {
                    if (value == null) continue;
                    xml.writeStartElement(name);
                    writer.write(xml, (Object)value);
                    xml.writeEndElement();
                }
            }
        };
    }

    public static <T> Writer<Iterable<T>> elems(Writer<? super T> writer) {
        Objects.requireNonNull(writer);
        return (xml, data) -> {
            if (data != null) {
                for (Object value : data) {
                    if (value == null) continue;
                    writer.write(xml, (Object)value);
                }
            }
        };
    }

    public static <T> Writer<T> doc(Writer<? super T> writer) {
        return (xml, data) -> {
            xml.writeStartDocument("UTF-8", "1.0");
            writer.write(xml, data);
            xml.writeEndDocument();
        };
    }
}

