/*
 * Decompiled with CFR 0.152.
 */
package org.jenetics.xml;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.jenetics.AbstractChromosome;
import org.jenetics.BoundedGene;
import org.jenetics.CharacterGene;
import org.jenetics.Chromosome;
import org.jenetics.EnumGene;
import org.jenetics.Gene;
import org.jenetics.xml.stream.AutoCloseableXMLStreamWriter;
import org.jenetics.xml.stream.Writer;
import org.jenetics.xml.stream.XML;

public final class Writers {
    private Writers() {
    }

    public static <A, G extends Gene<A, G>, C extends Chromosome<G>> void write(OutputStream out, Collection<org.jenetics.Genotype<G>> data, Writer<? super C> chromosomeWriter) throws XMLStreamException {
        Genotypes.write(out, data, chromosomeWriter);
    }

    public static final class Genotypes {
        static final String ROOT_NAME = "genotypes";
        static final String LENGTH_NAME = "length";

        private Genotypes() {
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> Writer<Collection<org.jenetics.Genotype<G>>> writer(Writer<? super C> writer) {
            return Writer.elem(ROOT_NAME, Writer.attr(LENGTH_NAME).map(Collection::size), Writer.elems(Genotype.writer(writer)));
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> void write(OutputStream out, Collection<org.jenetics.Genotype<G>> data, String indent, Writer<? super C> chromosomeWriter) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(chromosomeWriter);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                Genotypes.writer(chromosomeWriter).write(xml, data);
            }
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> void write(OutputStream out, Collection<org.jenetics.Genotype<G>> data, Writer<? super C> chromosomeWriter) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(chromosomeWriter);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out);){
                Genotypes.writer(chromosomeWriter).write(xml, data);
            }
        }
    }

    public static final class Genotype {
        static final String ROOT_NAME = "genotype";
        static final String LENGTH_NAME = "length";
        static final String NGENES_NAME = "ngenes";

        private Genotype() {
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> Writer<org.jenetics.Genotype<G>> writer(Writer<? super C> writer) {
            return Writer.elem(ROOT_NAME, Writer.attr(LENGTH_NAME).map(org.jenetics.Genotype::length), Writer.attr(NGENES_NAME).map(org.jenetics.Genotype::getNumberOfGenes), Writer.elems(writer).map(gt -> (Iterable)Genotype.cast(gt.toSeq())));
        }

        private static <A, B> B cast(A value) {
            return (B)value;
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> void write(OutputStream out, org.jenetics.Genotype<G> data, String indent, Writer<? super C> chromosomeWriter) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(chromosomeWriter);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter writer = XML.writer(out, indent);){
                Genotype.writer(chromosomeWriter).write(writer, data);
            }
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> void write(OutputStream out, org.jenetics.Genotype<G> data, Writer<? super C> chromosomeWriter) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(chromosomeWriter);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out);){
                Genotype.writer(chromosomeWriter).write(xml, data);
            }
        }
    }

    public static final class PermutationChromosome {
        static final String ROOT_NAME = "permutation-chromosome";
        static final String LENGTH_NAME = "length";
        static final String VALID_ALLELES_NAME = "valid-alleles";
        static final String ALLELE_NAME = "allele";
        static final String ORDER_NAME = "order";

        private PermutationChromosome() {
        }

        public static <A> Writer<org.jenetics.PermutationChromosome<A>> writer(Writer<? super A> alleleWriter) {
            return Writer.elem(ROOT_NAME, Writer.attr(LENGTH_NAME).map(AbstractChromosome::length), Writer.elem(VALID_ALLELES_NAME, Writer.attr("type").map(PermutationChromosome::toAlleleTypeName), Writer.elems(ALLELE_NAME, alleleWriter).map(ch -> ch.getValidAlleles())), Writer.elem(ORDER_NAME, Writer.text()).map(ch -> ch.stream().map(g -> Integer.toString(g.getAlleleIndex())).collect(Collectors.joining(" "))));
        }

        private static String toAlleleTypeName(org.jenetics.PermutationChromosome<?> ch) {
            return ((EnumGene)ch.getGene()).getAllele().getClass().getCanonicalName();
        }

        public static <A> Writer<org.jenetics.PermutationChromosome<A>> writer() {
            return PermutationChromosome.writer(Writer.text());
        }

        public static <A> void write(OutputStream out, org.jenetics.PermutationChromosome<A> data, String indent) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter writer = XML.writer(out, indent);){
                PermutationChromosome.writer().write(writer, data);
            }
        }

        public static <A> void write(OutputStream out, org.jenetics.PermutationChromosome<A> data, String indent, Writer<? super A> alleleWriter) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(alleleWriter);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                PermutationChromosome.writer(alleleWriter).write(xml, data);
            }
        }

        public static <A> void write(OutputStream out, org.jenetics.PermutationChromosome<A> data) throws XMLStreamException {
            PermutationChromosome.write(out, data, null, Writer.text());
        }

        public static <A> void write(OutputStream out, org.jenetics.PermutationChromosome<A> data, Writer<? super A> alleleWriter) throws XMLStreamException {
            PermutationChromosome.write(out, data, null, alleleWriter);
        }
    }

    public static final class DoubleChromosome {
        static final String ROOT_NAME = "double-chromosome";

        private DoubleChromosome() {
        }

        public static Writer<Double> alleleWriter() {
            return Writer.text().map(Object::toString);
        }

        public static Writer<org.jenetics.DoubleChromosome> writer(Writer<? super Double> alleleWriter) {
            return BoundedChromosome.writer(ROOT_NAME, alleleWriter);
        }

        public static Writer<org.jenetics.DoubleChromosome> writer() {
            return DoubleChromosome.writer(DoubleChromosome.alleleWriter());
        }

        public Class<org.jenetics.DoubleChromosome> type() {
            return org.jenetics.DoubleChromosome.class;
        }

        public static void write(OutputStream out, org.jenetics.DoubleChromosome data, String indent) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                DoubleChromosome.writer().write(xml, data);
            }
        }

        public static void write(OutputStream out, org.jenetics.DoubleChromosome data) throws XMLStreamException {
            DoubleChromosome.write(out, data, null);
        }
    }

    public static final class LongChromosome {
        static final String ROOT_NAME = "long-chromosome";

        private LongChromosome() {
        }

        public static Writer<Long> alleleWriter() {
            return Writer.text();
        }

        public static Writer<org.jenetics.LongChromosome> writer(Writer<? super Long> alleleWriter) {
            return BoundedChromosome.writer(ROOT_NAME, alleleWriter);
        }

        public static Writer<org.jenetics.LongChromosome> writer() {
            return LongChromosome.writer(LongChromosome.alleleWriter());
        }

        public static void write(OutputStream out, org.jenetics.LongChromosome data, String indent) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                LongChromosome.writer().write(xml, data);
            }
        }

        public static void write(OutputStream out, org.jenetics.LongChromosome data) throws XMLStreamException {
            LongChromosome.write(out, data, null);
        }
    }

    public static final class IntegerChromosome {
        static final String ROOT_NAME = "int-chromosome";

        private IntegerChromosome() {
        }

        public static Writer<Integer> alleleWriter() {
            return Writer.text();
        }

        public static Writer<org.jenetics.IntegerChromosome> writer(Writer<? super Integer> alleleWriter) {
            Objects.requireNonNull(alleleWriter);
            return BoundedChromosome.writer(ROOT_NAME, alleleWriter);
        }

        public static Writer<org.jenetics.IntegerChromosome> writer() {
            return IntegerChromosome.writer(IntegerChromosome.alleleWriter());
        }

        public static void write(OutputStream out, org.jenetics.IntegerChromosome data, String indent) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                IntegerChromosome.writer().write(xml, data);
            }
        }

        public static void write(OutputStream out, org.jenetics.IntegerChromosome data) throws XMLStreamException {
            IntegerChromosome.write(out, data, null);
        }
    }

    public static final class BoundedChromosome {
        static final String LENGTH_NAME = "length";
        static final String MIN_NAME = "min";
        static final String MAX_NAME = "max";
        static final String ALLELE_NAME = "allele";
        static final String ALLELES_NAME = "alleles";

        private BoundedChromosome() {
        }

        public static <A extends Comparable<? super A>, G extends BoundedGene<A, G>, C extends org.jenetics.BoundedChromosome<A, G>> Writer<C> writer(String rootName, Writer<? super A> alleleWriter) {
            Objects.requireNonNull(rootName);
            Objects.requireNonNull(alleleWriter);
            return Writer.elem(rootName, Writer.attr(LENGTH_NAME).map(ch -> ch.length()), Writer.elem(MIN_NAME, alleleWriter.map(ch -> ch.getMin())), Writer.elem(MAX_NAME, alleleWriter.map(ch -> ch.getMax())), Writer.elem(ALLELES_NAME, Writer.elems(ALLELE_NAME, alleleWriter).map(ch -> ch.toSeq().map(Gene::getAllele))));
        }
    }

    public static final class CharacterChromosome {
        static final String ROOT_NAME = "character-chromosome";
        static final String LENGTH_NAME = "length";
        static final String VALID_ALLELES_NAME = "valid-alleles";
        static final String ALLELES_NAME = "alleles";

        private CharacterChromosome() {
        }

        public static Writer<org.jenetics.CharacterChromosome> writer() {
            return Writer.elem(ROOT_NAME, Writer.attr(LENGTH_NAME).map(AbstractChromosome::length), Writer.elem(VALID_ALLELES_NAME, Writer.text().map(ch -> ((CharacterGene)ch.getGene()).getValidCharacters())), Writer.elem(ALLELES_NAME, Writer.text().map(org.jenetics.CharacterChromosome::toString)));
        }

        public static void write(OutputStream out, org.jenetics.CharacterChromosome data, String indent) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out, indent);){
                CharacterChromosome.writer().write(xml, data);
            }
        }

        public static void write(OutputStream out, org.jenetics.CharacterChromosome data) throws XMLStreamException {
            CharacterChromosome.write(out, data, null);
        }
    }

    public static final class BitChromosome {
        static final String ROOT_NAME = "bit-chromosome";
        static final String LENGTH_NAME = "length";
        static final String ONES_PROBABILITY_NAME = "ones-probability";

        private BitChromosome() {
        }

        public static Writer<org.jenetics.BitChromosome> writer() {
            return Writer.elem(ROOT_NAME, Writer.attr(LENGTH_NAME).map(org.jenetics.BitChromosome::length), Writer.attr(ONES_PROBABILITY_NAME).map(ch -> ch.getOneProbability()), Writer.text().map(org.jenetics.BitChromosome::toCanonicalString));
        }

        public static void write(OutputStream out, org.jenetics.BitChromosome data) throws XMLStreamException {
            Objects.requireNonNull(data);
            Objects.requireNonNull(out);
            try (AutoCloseableXMLStreamWriter xml = XML.writer(out);){
                BitChromosome.writer().write(xml, data);
            }
        }
    }
}

