/*
 * Decompiled with CFR 0.152.
 */
package org.jenetics.xml;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.jenetics.BoundedGene;
import org.jenetics.Chromosome;
import org.jenetics.DoubleGene;
import org.jenetics.EnumGene;
import org.jenetics.Gene;
import org.jenetics.IntegerGene;
import org.jenetics.LongGene;
import org.jenetics.util.CharSeq;
import org.jenetics.util.ISeq;
import org.jenetics.util.MSeq;
import org.jenetics.xml.BoundedGeneCreator;
import org.jenetics.xml.stream.AutoCloseableXMLStreamReader;
import org.jenetics.xml.stream.Reader;
import org.jenetics.xml.stream.XML;

public final class Readers {
    private Readers() {
    }

    public static <A, G extends Gene<A, G>, C extends Chromosome<G>> List<org.jenetics.Genotype<G>> read(InputStream in, Reader<? extends C> chromosomeReader) throws XMLStreamException {
        return Genotypes.read(in, chromosomeReader);
    }

    public static final class Genotypes {
        private Genotypes() {
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> Reader<List<org.jenetics.Genotype<G>>> reader(Reader<C> chromosomeReader) {
            return Reader.elem(p -> (List)p[0], "genotypes", Reader.elems(Genotype.reader(chromosomeReader)));
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> List<org.jenetics.Genotype<G>> read(InputStream in, Reader<? extends C> chromosomeReader) throws XMLStreamException {
            Objects.requireNonNull(chromosomeReader);
            Objects.requireNonNull(in);
            try (AutoCloseableXMLStreamReader xml = XML.reader(in);){
                xml.next();
                List<org.jenetics.Genotype<G>> list = Genotypes.reader(chromosomeReader).read(xml);
                return list;
            }
        }
    }

    public static final class Genotype {
        private Genotype() {
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> Reader<org.jenetics.Genotype<G>> reader(Reader<? extends C> chromosomeReader) {
            Objects.requireNonNull(chromosomeReader);
            return Reader.elem(v -> {
                List chromosomes = (List)v[2];
                org.jenetics.Genotype genotype = org.jenetics.Genotype.of((Iterable)chromosomes);
                int length = (Integer)v[0];
                int ngenes = (Integer)v[1];
                if (length != genotype.length()) {
                    throw new IllegalArgumentException(String.format("Expected %d chromosome, but read %d.", length, genotype.length()));
                }
                if (ngenes != genotype.getNumberOfGenes()) {
                    throw new IllegalArgumentException(String.format("Expected %d genes, but read %d.", ngenes, genotype.getNumberOfGenes()));
                }
                return genotype;
            }, "genotype", Reader.attr("length").map(Integer::parseInt), Reader.attr("ngenes").map(Integer::parseInt), Reader.elems(chromosomeReader));
        }

        public static <A, G extends Gene<A, G>, C extends Chromosome<G>> org.jenetics.Genotype<G> read(InputStream in, Reader<? extends C> chromosomeReader) throws XMLStreamException {
            Objects.requireNonNull(chromosomeReader);
            Objects.requireNonNull(in);
            try (AutoCloseableXMLStreamReader xml = XML.reader(in);){
                xml.next();
                org.jenetics.Genotype<G> genotype = Genotype.reader(chromosomeReader).read(xml);
                return genotype;
            }
        }
    }

    public static final class PermutationChromosome {
        private PermutationChromosome() {
        }

        public static <A> Reader<org.jenetics.PermutationChromosome<A>> reader(Reader<? extends A> alleleReader) {
            Objects.requireNonNull(alleleReader);
            return Reader.elem(v -> {
                int length = (Integer)v[0];
                ISeq validAlleles = ISeq.of((Iterable)((List)v[1]));
                int[] order = Stream.of(((String)v[2]).split("\\s")).mapToInt(Integer::parseInt).toArray();
                MSeq alleles = MSeq.ofLength((int)length);
                for (int i = 0; i < length; ++i) {
                    EnumGene gene = EnumGene.of((int)order[i], (ISeq)validAlleles);
                    alleles.set(i, (Object)gene);
                }
                return new org.jenetics.PermutationChromosome(alleles.toISeq());
            }, "permutation-chromosome", Reader.attr("length").map(Integer::parseInt), Reader.elem("valid-alleles", Reader.elems(Reader.elem("allele", alleleReader))), Reader.elem("order", Reader.text()));
        }

        public static <A> org.jenetics.PermutationChromosome<A> read(InputStream in, Reader<? extends A> alleleReader) throws XMLStreamException {
            Objects.requireNonNull(alleleReader);
            Objects.requireNonNull(in);
            try (AutoCloseableXMLStreamReader xml = XML.reader(in);){
                xml.next();
                org.jenetics.PermutationChromosome<? extends A> permutationChromosome = PermutationChromosome.reader(alleleReader).read(xml);
                return permutationChromosome;
            }
        }
    }

    public static final class DoubleChromosome {
        private DoubleChromosome() {
        }

        public static Reader<Double> alleleReader() {
            return Reader.text().map(Double::parseDouble);
        }

        public static Reader<org.jenetics.DoubleChromosome> reader() {
            return BoundedChromosome.reader("double-chromosome", DoubleGene::of, DoubleGene[]::new, org.jenetics.DoubleChromosome::of, DoubleChromosome.alleleReader());
        }

        public static org.jenetics.DoubleChromosome read(InputStream in) throws XMLStreamException {
            try (AutoCloseableXMLStreamReader reader = XML.reader(in);){
                reader.next();
                org.jenetics.DoubleChromosome doubleChromosome = DoubleChromosome.reader().read(reader);
                return doubleChromosome;
            }
        }
    }

    public static final class LongChromosome {
        private LongChromosome() {
        }

        public static Reader<Long> alleleReader() {
            return Reader.text().map(Long::parseLong);
        }

        public static Reader<org.jenetics.LongChromosome> reader() {
            return BoundedChromosome.reader("long-chromosome", LongGene::of, LongGene[]::new, org.jenetics.LongChromosome::of, LongChromosome.alleleReader());
        }

        public static org.jenetics.LongChromosome read(InputStream in) throws XMLStreamException {
            try (AutoCloseableXMLStreamReader reader = XML.reader(in);){
                reader.next();
                org.jenetics.LongChromosome longChromosome = LongChromosome.reader().read(reader);
                return longChromosome;
            }
        }
    }

    public static final class IntegerChromosome {
        private IntegerChromosome() {
        }

        public static Reader<Integer> alleleReader() {
            return Reader.text().map(Integer::parseInt);
        }

        public static Reader<org.jenetics.IntegerChromosome> reader() {
            return BoundedChromosome.reader("int-chromosome", IntegerGene::of, IntegerGene[]::new, org.jenetics.IntegerChromosome::of, IntegerChromosome.alleleReader());
        }

        public static org.jenetics.IntegerChromosome read(InputStream in) throws XMLStreamException {
            try (AutoCloseableXMLStreamReader reader = XML.reader(in);){
                reader.next();
                org.jenetics.IntegerChromosome integerChromosome = IntegerChromosome.reader().read(reader);
                return integerChromosome;
            }
        }
    }

    public static final class BoundedChromosome {
        private BoundedChromosome() {
        }

        public static <A extends Comparable<? super A>, G extends BoundedGene<A, G>, C extends org.jenetics.BoundedChromosome<A, G>> Reader<C> reader(String name, BoundedGeneCreator<A, G> gene, IntFunction<G[]> genes, Function<G[], C> chromosome, Reader<? extends A> alleleReader) {
            return Reader.elem(v -> {
                int length = (Integer)v[0];
                Comparable min = (Comparable)v[1];
                Comparable max = (Comparable)v[2];
                List alleles = (List)v[3];
                if (alleles.size() != length) {
                    throw new IllegalArgumentException(String.format("Expected %d alleles, but got %d,", length, alleles.size()));
                }
                return (org.jenetics.BoundedChromosome)chromosome.apply(alleles.stream().map(value -> (BoundedGene)gene.create(value, min, max)).toArray(genes));
            }, name, Reader.attr("length").map(Integer::parseInt), Reader.elem("min", alleleReader), Reader.elem("max", alleleReader), Reader.elem("alleles", Reader.elems(Reader.elem("allele", alleleReader))));
        }
    }

    public static final class CharacterChromosome {
        private CharacterChromosome() {
        }

        public static Reader<org.jenetics.CharacterChromosome> reader() {
            return Reader.elem(v -> org.jenetics.CharacterChromosome.of((String)((String)v[2]), (CharSeq)((CharSeq)v[1])), "character-chromosome", Reader.attr("length").map(Integer::parseInt), Reader.elem("valid-alleles", Reader.text().map(CharSeq::new)), Reader.elem("alleles", Reader.text()));
        }

        public static org.jenetics.CharacterChromosome read(InputStream in) throws XMLStreamException {
            try (AutoCloseableXMLStreamReader xml = XML.reader(in);){
                xml.next();
                org.jenetics.CharacterChromosome characterChromosome = CharacterChromosome.reader().read(xml);
                return characterChromosome;
            }
        }
    }

    public static final class BitChromosome {
        private BitChromosome() {
        }

        public static Reader<org.jenetics.BitChromosome> reader() {
            return Reader.elem(v -> org.jenetics.BitChromosome.of((CharSequence)((String)v[2]), (int)((Integer)v[0]), (double)((Double)v[1])), "bit-chromosome", Reader.attr("length").map(Integer::parseInt), Reader.attr("ones-probability").map(Double::parseDouble), Reader.text());
        }

        public static org.jenetics.BitChromosome read(InputStream in) throws XMLStreamException {
            try (AutoCloseableXMLStreamReader xml = XML.reader(in);){
                xml.next();
                org.jenetics.BitChromosome bitChromosome = BitChromosome.reader().read(xml);
                return bitChromosome;
            }
        }
    }
}

