/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0015J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0015J\u0016\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000e\u00a8\u0006%"}, d2={"Lio/javalin/community/ssl/TrustConfig;", "", "()V", "certificateMutableList", "", "Ljava/security/cert/Certificate;", "certificates", "", "getCertificates", "()Ljava/util/List;", "keyStore", "Ljava/security/KeyStore;", "getKeyStore", "setKeyStore", "(Ljava/util/List;)V", "keyStoreMutableList", "getKeyStoreMutableList", "setKeyStoreMutableList", "certificateFromClasspath", "", "certificateFile", "", "certificateFromInputStream", "certificateInputStream", "Ljava/io/InputStream;", "certificateFromPath", "certificatePath", "p7bCertificateFromString", "certificateString", "pemFromString", "trustStoreFromClasspath", "trustStoreFile", "trustStorePassword", "trustStoreFromInputStream", "trustStoreInputStream", "trustStoreFromPath", "trustStorePath", "ssl-plugin"})
public final class TrustConfig {
    @NotNull
    private List<Certificate> certificateMutableList = new ArrayList();
    @NotNull
    private final List<Certificate> certificates = this.certificateMutableList;
    @NotNull
    private List<KeyStore> keyStoreMutableList = new ArrayList();
    @NotNull
    private List<? extends KeyStore> keyStore = this.keyStoreMutableList;

    @NotNull
    public final List<Certificate> getCertificates() {
        return this.certificates;
    }

    @NotNull
    public final List<KeyStore> getKeyStoreMutableList() {
        return this.keyStoreMutableList;
    }

    public final void setKeyStoreMutableList(@NotNull List<KeyStore> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.keyStoreMutableList = list;
    }

    @NotNull
    public final List<KeyStore> getKeyStore() {
        return this.keyStore;
    }

    public final void setKeyStore(@NotNull List<? extends KeyStore> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.keyStore = list;
    }

    public final void certificateFromPath(@NotNull String certificatePath) {
        Intrinsics.checkNotNullParameter((Object)certificatePath, (String)"certificatePath");
        Path[] pathArray = new Path[]{Paths.get(certificatePath, new String[0])};
        List list = CertificateUtils.loadCertificate((Path[])pathArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadCertificate(...)");
        this.certificateMutableList.addAll(list);
    }

    public final void certificateFromClasspath(@NotNull String certificateFile) {
        Intrinsics.checkNotNullParameter((Object)certificateFile, (String)"certificateFile");
        String[] stringArray = new String[]{certificateFile};
        List list = CertificateUtils.loadCertificate((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadCertificate(...)");
        this.certificateMutableList.addAll(list);
    }

    public final void certificateFromInputStream(@NotNull InputStream certificateInputStream) {
        Intrinsics.checkNotNullParameter((Object)certificateInputStream, (String)"certificateInputStream");
        InputStream[] inputStreamArray = new InputStream[]{certificateInputStream};
        List list = CertificateUtils.loadCertificate((InputStream[])inputStreamArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadCertificate(...)");
        this.certificateMutableList.addAll(list);
    }

    public final void p7bCertificateFromString(@NotNull String certificateString) {
        Intrinsics.checkNotNullParameter((Object)certificateString, (String)"certificateString");
        List list = CertificateUtils.parseP7bCertificate((String)certificateString);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseP7bCertificate(...)");
        this.certificateMutableList.addAll(list);
    }

    public final void pemFromString(@NotNull String certificateString) {
        Intrinsics.checkNotNullParameter((Object)certificateString, (String)"certificateString");
        List list = CertificateUtils.parsePemCertificate((String)certificateString);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parsePemCertificate(...)");
        this.certificateMutableList.addAll(list);
    }

    public final void trustStoreFromPath(@NotNull String trustStorePath, @NotNull String trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        Path path = Paths.get(trustStorePath, new String[0]);
        char[] cArray = trustStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        KeyStore keyStore = KeyStoreUtils.loadKeyStore((Path)path, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"loadKeyStore(...)");
        this.keyStoreMutableList.add(keyStore);
    }

    public final void trustStoreFromInputStream(@NotNull InputStream trustStoreInputStream, @NotNull String trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStoreInputStream, (String)"trustStoreInputStream");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        char[] cArray = trustStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        KeyStore keyStore = KeyStoreUtils.loadKeyStore((InputStream)trustStoreInputStream, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"loadKeyStore(...)");
        this.keyStoreMutableList.add(keyStore);
    }

    public final void trustStoreFromClasspath(@NotNull String trustStoreFile, @NotNull String trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStoreFile, (String)"trustStoreFile");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        char[] cArray = trustStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        KeyStore keyStore = KeyStoreUtils.loadKeyStore((String)trustStoreFile, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"loadKeyStore(...)");
        this.keyStoreMutableList.add(keyStore);
    }
}

