/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V> {
    protected Map<K, List<V>> map = new HashMap<K, List<V>>();

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsMapping(K key, V value) {
        return this.get(key).contains(value);
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void putAll(ListMap listMap) {
        for (K key : listMap.keySet()) {
            List<V> values = listMap.get(key);
            for (V value : values) {
                this.put(key, value);
            }
        }
    }

    public void putAll(K key, Collection<V> values) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        for (V value : values) {
            if (list.contains(value)) continue;
            list.add(value);
        }
    }

    public Object put(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        return null;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        HashSet<V> values = new HashSet<V>();
        for (List<V> list : this.map.values()) {
            values.addAll(list);
        }
        return values;
    }

    public List<V> remove(K key) {
        List removed = this.map.remove(key);
        if (removed == null) {
            removed = Collections.EMPTY_LIST;
        }
        return removed;
    }

    public void remove(K key, V value) {
        List<V> list = this.map.get(key);
        if (list != null) {
            while (list.contains(value)) {
                list.remove(value);
            }
            if (list.size() == 0) {
                this.remove(key);
            }
        }
    }

    public List<V> get(K key) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }
}

