/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;

public class GzipCompressingInputStream
extends SequenceInputStream {
    public GzipCompressingInputStream(InputStream in) throws IOException {
        this(in, 512);
    }

    public GzipCompressingInputStream(InputStream in, int bufferSize) throws IOException {
        super(new StatefullGzipStreamEnumerator(in, bufferSize));
    }

    protected static class InternalGzipCompressingInputStream
    extends DeflaterInputStream {
        protected final CRC32InputStream crcIn;
        protected static final int TRAILER_SIZE = 8;

        public InternalGzipCompressingInputStream(CRC32InputStream in, int bufferSize) {
            super(in, new Deflater(-1, true), bufferSize);
            this.crcIn = in;
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                try {
                    this.def.end();
                    this.in.close();
                }
                finally {
                    this.in = null;
                }
            }
        }

        public byte[] createTrailer() {
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            return trailer;
        }

        private void writeTrailer(byte[] buf, int offset) {
            this.writeInt((int)this.crcIn.getCrcValue(), buf, offset);
            this.writeInt((int)this.crcIn.getByteCount(), buf, offset + 4);
        }

        private void writeInt(int i, byte[] buf, int offset) {
            this.writeShort(i & 0xFFFF, buf, offset);
            this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
        }

        private void writeShort(int s, byte[] buf, int offset) {
            buf[offset] = (byte)(s & 0xFF);
            buf[offset + 1] = (byte)(s >> 8 & 0xFF);
        }
    }

    protected static class CRC32InputStream
    extends FilterInputStream {
        protected CRC32 crc = new CRC32();
        protected long byteCount;

        public CRC32InputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int val = super.read();
            if (val >= 0) {
                this.crc.update(val);
                ++this.byteCount;
            }
            return val;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((len = super.read(b, off, len)) >= 0) {
                this.crc.update(b, off, len);
                this.byteCount += (long)len;
            }
            return len;
        }

        public long getCrcValue() {
            return this.crc.getValue();
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }

    protected static class StatefullGzipStreamEnumerator
    implements Enumeration<InputStream> {
        protected final InputStream in;
        protected final int bufferSize;
        protected StreamState state;
        static final int GZIP_MAGIC = 35615;
        static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        protected InternalGzipCompressingInputStream contentStream;

        public StatefullGzipStreamEnumerator(InputStream in, int bufferSize) {
            this.in = in;
            this.bufferSize = bufferSize;
            this.state = StreamState.HEADER;
        }

        @Override
        public boolean hasMoreElements() {
            return this.state != null;
        }

        @Override
        public InputStream nextElement() {
            switch (this.state) {
                case HEADER: {
                    this.state = StreamState.CONTENT;
                    return this.createHeaderStream();
                }
                case CONTENT: {
                    this.state = StreamState.TRAILER;
                    return this.createContentStream();
                }
                case TRAILER: {
                    this.state = null;
                    return this.createTrailerStream();
                }
            }
            return null;
        }

        protected InputStream createHeaderStream() {
            return new ByteArrayInputStream(GZIP_HEADER);
        }

        protected InputStream createContentStream() {
            this.contentStream = new InternalGzipCompressingInputStream(new CRC32InputStream(this.in), this.bufferSize);
            return this.contentStream;
        }

        protected InputStream createTrailerStream() {
            return new ByteArrayInputStream(this.contentStream.createTrailer());
        }
    }

    static enum StreamState {
        HEADER,
        CONTENT,
        TRAILER;

    }
}

