/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.Inbox;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.APIModels.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConversationsListAdapter
extends ArrayAdapter<Conversation> {
    private Holder holder;
    private int rowResourceID;
    private static int CONVERSATION_TYPE = 0;
    private static int LOADING_TYPE = 1;

    public ConversationsListAdapter(Context context, int textViewResourceId, List<Conversation> conversationListArray) {
        super(context, textViewResourceId, conversationListArray);
        this.rowResourceID = textViewResourceId;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Holder holder;
        int type = this.getItemViewType(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        if (type == LOADING_TYPE) {
            convertView = inflater.inflate(R.layout.intercomsdk_row_loading, parent, false);
            convertView.setMinimumHeight(parent.getMeasuredHeight());
            return convertView;
        }
        Conversation conversation = (Conversation)this.getItem(position);
        if (convertView == null) {
            holder = new Holder();
            convertView = inflater.inflate(this.rowResourceID, parent, false);
            holder.description = (TextView)convertView.findViewById(R.id.description);
            holder.authorName = (TextView)convertView.findViewById(R.id.name);
            holder.timeLabel = (TextView)convertView.findViewById(R.id.timeLabel);
            holder.avatar = (ImageView)convertView.findViewById(R.id.avatarView);
            holder.unreadImageView = (ImageView)convertView.findViewById(R.id.unreadImageView);
            convertView.setTag((Object)holder);
            holder.authorName.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", this.getContext()));
        } else {
            holder = (Holder)convertView.getTag();
        }
        holder.description.setText((CharSequence)conversation.getLastPart().getSummary());
        Participant admin = conversation.getLastAdmin();
        if (!(admin instanceof Participant.NullParticipant) && admin.hasDisplayName()) {
            this.updateAvatar(holder, conversation.getLastAdmin(), conversation.getParticipants());
        } else {
            this.updateAvatar(holder, new Participant());
            holder.authorName.setText((CharSequence)this.getContext().getResources().getString(R.string.intercomsdk_you));
        }
        holder.timeLabel.setText((CharSequence)new TimeUtils().getFormattedTime(conversation.getLastPart().getCreatedAt(), true));
        if (!conversation.getRead().booleanValue()) {
            holder.authorName.setTextColor(this.getContext().getResources().getColor(R.color.intercomsdk_text_light_black));
            holder.unreadImageView.setImageDrawable(this.getContext().getResources().getDrawable(R.drawable.intercomsdk_circle));
        } else {
            holder.authorName.setTextColor(this.getContext().getResources().getColor(R.color.intercomsdk_text_light_black));
            holder.unreadImageView.setImageDrawable(null);
        }
        return convertView;
    }

    private void updateAvatar(Holder holder, Participant user) {
        holder.authorName.setText((CharSequence)user.getName().split(" ")[0]);
        AvatarUtils.createAvatar(user.getAvatar(), holder.avatar, this.getContext());
    }

    private void updateAvatar(Holder holder, Participant admin, Map<String, Participant> involving) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(admin.getDisplayName());
        for (Map.Entry<String, Participant> entry : involving.entrySet()) {
            Participant p = entry.getValue();
            if (!p.isAdmin() || p.getId().equals(admin.getId())) continue;
            names.add(p.getDisplayName());
        }
        holder.authorName.setText((CharSequence)NameUtils.getFormattedAdmins(names, this.getContext()));
        AvatarUtils.createAvatar(admin.getAvatar(), holder.avatar, this.getContext());
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        int type = CONVERSATION_TYPE;
        if (this.getItem(position) instanceof Conversation.Loading) {
            return LOADING_TYPE;
        }
        return type;
    }

    public boolean isEnabled(int position) {
        return !(this.getItem(position) instanceof Conversation.Loading);
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    private class Holder {
        public TextView description;
        public TextView authorName;
        public TextView timeLabel;
        public ImageView avatar;
        public ImageView unreadImageView;

        private Holder() {
        }
    }
}

