/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.models.APIModels.Conversation;
import java.util.ArrayList;
import java.util.List;

public class ConversationList
implements Parcelable {
    private List<Conversation> conversations = new ArrayList<Conversation>();
    private int totalUnreadCount;
    private boolean morePagesAvailable;
    public static final Parcelable.Creator<ConversationList> CREATOR = new Parcelable.Creator<ConversationList>(){

        public ConversationList createFromParcel(Parcel in) {
            return new ConversationList(in);
        }

        public ConversationList[] newArray(int size) {
            return new ConversationList[size];
        }
    };

    public ConversationList() {
        this(new Builder());
    }

    private ConversationList(Builder builder) {
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
        this.totalUnreadCount = Math.max(builder.total_count, builder.total_unread_count);
        this.morePagesAvailable = builder.more_pages_available;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public int getTotalUnreadCount() {
        return this.totalUnreadCount;
    }

    protected ConversationList(Parcel in) {
        if (in.readByte() == 1) {
            in.readList(this.conversations, Conversation.class.getClassLoader());
        }
        this.totalUnreadCount = in.readInt();
        this.morePagesAvailable = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.conversations == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.conversations);
        }
        dest.writeInt(this.totalUnreadCount);
        dest.writeByte((byte)(this.morePagesAvailable ? 1 : 0));
    }

    public static final class Builder {
        private List<Conversation.Builder> conversations;
        private int total_count;
        private int total_unread_count;
        private boolean more_pages_available;

        public ConversationList build() {
            return new ConversationList(this);
        }
    }
}

